<?php
// require main include file
require_once(dirname(dirname(dirname(dirname(__FILE__)))) . '/admin/prepend.inc.php');
require_once(dirname(dirname(dirname(__FILE__)))) . '/functions/basic.php';
require_once(dirname(dirname(dirname(__FILE__)))) . '/functions/smarty.php';


if ( !isset($site) ) $site = ac_site_get();
if ( !isset($admin) ) $admin = ac_admin_get();


if ( !ac_admin_ismain() ) {
	echo 'You are not logged in.';
	exit;
}



// Preload the language file
ac_lang_get('admin');





// Smarty Template system setup
$smarty = new AC_Smarty('global');





// assigning smarty reserved vars
$smarty->assign('site', $site);
$smarty->assign('admin', $admin);


/*
	CHECK FOR UPDATES
*/
$newVersion = false;
$version = '';

// just main admin can see this, if it's turned ON (on=1=adminID)
if ( $site['updatecheck'] == 1 ) {
	// after more than 30 days since last check
	list($year, $month, $day) = explode('-', $site['updatedate']);
	$cutOff = date('Ymd', mktime(0, 0, 0, $month, $day + 30, $year));
	if ( $cutOff < date('Ymd') ) {
		// update date
		ac_sql_query("UPDATE #backend SET updatedate = CURDATE()");
		// fetch new version
		$version = (string)ac_http_get('http://www.activatelicense.com/update_checker.php?check_val=' . $GLOBALS['ac_app_id']);
		$newVersion = ( $version != '' ? version_compare($site['version'], $version, '<' ) : false );
		// if fetched, update version
		if ( $newVersion ) {
			ac_sql_update_one('#backend', 'updateversion', $version);
		}
	}
}
$smarty->assign('newVersion', $newVersion);
$smarty->assign('version', $version);

// check for updates link
$settings_update_link = '../../../';
if ( in_array('settings_update', $GLOBALS['ac_context_whitelist_admin']) )
	$settings_update_link .= 'admin/';
$settings_update_link .= 'main.php?action=settings_update';
$smarty->assign('settings_update_link', $settings_update_link);




// loading the main template
$smarty->display('iframe.updatecheck.htm');

?>