<?php
// smarty.php

// Subclassing the Smarty class, similar to how we would do so in our
// product code, but specifically for ac_global.  This is intended to
// replace OTA/TT/ProductSmarty class references.

if (!defined("AC_GLOBAL_USE_OLD_SMARTY"))
    require_once(ac_global('smarty/Smarty.class.php'));
else
    require_once(ac_admin('functions/smarty/Smarty.class.php'));

//require_once ac_global_functions("site.php");
require_once ac_global_functions("utf.php");

class AC_Smarty extends Smarty {

    var $_folder      = '';
    var $_smartyPath  = '';
    var $_publicPath  = '';
    var $_adminPath   = '';
    var $_globalPath  = '';
    var $_deskPath    = '';
    var $_pluginsPath = '';

    var $_ct_header_sent = false;

    function AC_Smarty($folder, $email = false, $mobile = false) {
    	$this->_folder = $folder;
        $this->_smartyPath  = ac_global('smarty');
        $this->_pluginsPath = ac_global('smarty_plugins');
        $this->_globalPath  = ac_global();
        $this->_adminPath   = ac_admin();
        $this->_publicPath  = ac_base();

        parent::Smarty();

        $this->compile_check = true;
//      $this->force_compile = true;
//      $this->debugging     = true;

		if ( !isset($GLOBALS['ac_app_partof']) ) $GLOBALS['ac_app_partof'] = null;

		$this->template_dir = array();
		if ( $folder != 'global' and $GLOBALS['ac_app_partof'] ) {
			if ( $folder == 'admin' ) {
				//
				$parentPath = dirname($this->_publicPath) . '/admin';
			} else/*if ( $folder == 'admin' )*/ {
				//
				$parentPath = dirname($this->_publicPath);
			}
			$this->template_dir[] = $parentPath . '/templates';
			$this->template_dir[] = $parentPath . '/js';
		}
		if ( $folder == 'public' ) {
			// public section
			$this->template_dir[] = $this->_publicPath . '/templates';
			$this->template_dir[] = $this->_publicPath . '/js';
		} elseif ( $folder == 'admin' ) {
			// admin section
			$this->template_dir[] = $this->_adminPath . '/templates';
			$this->template_dir[] = $this->_adminPath . '/js';
		} elseif ( $folder == 'global' ) {
			// ac_global is always added, so it doesn't have to be referenced here
			$this->template_dir[] = $this->_globalPath . '/templates';
			$this->template_dir[] = $this->_globalPath . '/js';
/* SUPPORTTRIO START */
		} else {
			// desk
			$this->template_dir[] = $this->_publicPath . '/desk/' . $folder . '/templates';
			$this->template_dir[] = $this->_publicPath . '/js';
		}
		if ( is_dir($this->_publicPath . '/kb/templates') ) {
			$prfx = $folder == 'admin' ? '/admin' : '';
			$this->template_dir[] = $this->_publicPath . "/kb$prfx/templates";
			$this->template_dir[] = $this->_publicPath . "/kb$prfx/js";
		}
		if ( $mobile ) {
			$this->template_dir[] = $this->template_dir[0];// move real folder to the end, for the case where mobile folder wants to use parent's
			$this->template_dir[0] .= '/mobile';
		}
/* SUPPORTTRIO END */

        if ($email)
            $this->template_dir[0] .= '/emails';
		if ( $folder == 'admin' or $folder == 'public' or $folder == 'global' ) {
			if ( $GLOBALS['ac_app_partof'] && !isset($GLOBALS['_hosted_account']) ) $GLOBALS['customCachePath'] = dirname($this->_publicPath);
			$this->compile_dir =
				( isset($GLOBALS['customCachePath']) ? $GLOBALS['customCachePath'] : $this->_publicPath ) .
				'/cache/' .
				( $folder == 'global' ? 'public' : $folder )
			;
		} else {
			$this->compile_dir = $this->_publicPath . '/desk/' . $folder . '/cache';
		}
		// assign final template_dir (array)
        if ( $folder != 'global' ) {// if not ac_global only
        	$this->template_dir[] = ac_global('templates'); // add ac_global templates to the list
        	$this->template_dir[] = ac_global('js'); // add ac_global javascript files to the list
        }
//      $this->cache_dir   = $this->_smartyPath . '/cache';
        $this->config_dir  = $this->_smartyPath . '/configs';
        $this->plugins_dir = array($this->_smartyPath . '/plugins', $this->_pluginsPath);
        if ( is_dir($this->_adminPath . '/functions/smarty_plugins') ) {
        	$this->addPluginDir($this->_adminPath . '/functions/smarty_plugins');
        }

		# Set up some custom variables

		$this->assign("globalurl", isset($GLOBALS["ac_global_url"]) ? $GLOBALS["ac_global_url"] : "");
		$this->assign('year', date('Y'));

		if (isset($_SESSION["ac_smarty_message"])) {
			$this->assign("resultMessage", $_SESSION["ac_smarty_message"]);
			unset($_SESSION["ac_smarty_message"]);
		}
    }

    function addPluginDir($path) {
    	if ( !in_array($path, $this->plugins_dir) )
    		$this->plugins_dir[] = $path;
    }

    function sendCTheader($str) {
    	$this->_ct_header_sent = true;
    	if ( !headers_sent() ) header($str);
    }

	function assign($key, $val = null, $convert = true) {
		if ($convert && $val !== null && isset($GLOBALS["ac_app_utf8"]) && $GLOBALS["ac_app_utf8"] && function_exists("_i18n"))
			$val = ac_utf_deepconv("UTF-8", _i18n("utf-8"), $val);

		parent::assign($key, $val);
	}

	function getvar($key) {
		# Shorthand for get_template_vars if you want a single variable.
		return $this->get_template_vars($key);
	}

	function setConstants() {
		$consts = get_defined_constants();

		foreach ($consts as $ck => $cv) {
			if (substr($ck, 0, 3) == "AC_")
				$this->assign($ck, $cv);
		}
	}

    function display($tpl, $cache_id = null, $compile_id = null) {
		$this->setConstants();
    	if ( !function_exists('smarty_modifier_i18n') )
    		require_once(dirname(dirname(__FILE__)) . '/smarty_plugins/modifier.i18n.php');
   		if ( !$this->_ct_header_sent )
			$this->sendCTheader('Content-Type: text/html; charset=' . smarty_modifier_i18n("utf-8"));
/*			if (function_exists('headers_list')) {
				$list = headers_list();
				$slist = strtolower(implode("--", $list));
				if (strpos($slist, "content-type:") === false) {
					header('Content-Type: text/html; charset=' . smarty_modifier_i18n("utf-8"));
				}
			} else {
				# Maybe we can do something else here.
			}
*/
    	$r = parent::display($tpl, $cache_id, $compile_id);
		ac_smarty_message_clear($this);
    	return $r;
    }

    function fetch($resource_name, $cache_id = null, $compile_id = null, $display = false) {
		$this->setConstants();
		$r = parent::fetch($resource_name, $cache_id, $compile_id, $display);
		return $r;
	}
}

?>
