<?php

require_once ac_global_functions("cron.php");
require_once ac_global_classes("select.php");
require_once ac_global_classes("pagination.php");

class cron_context extends ACP_Page {

	function cron_context() {
		$this->pageTitle = _a("Cron Manager/Monitor");
		$this->sideTemplate = $GLOBALS['ac_sidemenu_settings'];
		$this->ACP_Page();
	}

	function process(&$smarty) {
		$this->setTemplateData($smarty);
		$smarty->assign("content_template", "cron.htm");

		if (ac_ihook_exists("ac_cron_context_pre"))
			$smarty = ac_ihook("ac_cron_context_pre", $smarty);

		// check for privileges first!
		if ( !ac_admin_ismaingroup() || ( isset($GLOBALS['_hosted_account']) and !isset($_SESSION['ac_arc_login']) ) ) {
			// assign template
			ac_smarty_noaccess($smarty, $this);
			return;
		}

		$so = new AC_Select;
		$so->count();
		$total = (int)ac_sql_select_one(ac_cron_select_query($so));
		$count = $total;

		$paginator = new Pagination($total, $count, 20, 0, 'main.php?action=cron');
		$paginator->allowLimitChange = true;
		$paginator->ajaxAction = 'cron!ac_cron_select_array_paginator';
		$smarty->assign('paginator', $paginator);

		$sections = array(
			array("col" => "stringid", "label" => _a("Cron Identifier")),
			array("col" => "name", "label" => _a("Cron Name")),
			array("col" => "descript", "label" => _a("Cron Description")),
			array("col" => "filename", "label" => _a("Cron File")),
		);
		$smarty->assign("search_sections", $sections);

		// day of week
		$weekdays = array(-1 => _a("Every day of the week"));

		for ( $i = 0; $i < 7; $i++ ) $weekdays[$i] = ac_date_dayofweek($i);
		$smarty->assign("weekdays", $weekdays);
		// day of month
		$monthdays = array(-1 => _a("Every day of the month"));
		for ( $i = 1; $i < 32; $i++ ) $monthdays[$i] = $i;
		$smarty->assign("monthdays", $monthdays);
		// hours
		$hours = array(-1 => '*');
		for ( $i = 0; $i < 24; $i++ ) $hours[$i] = $i;
		$smarty->assign("hours", $hours);
		// hours
		$minutes1 = array(-1 => '*');
		$minutes2 = array(-2 => '-');
		for ( $i = 0; $i < 60; $i++ ) $minutes1[$i] = $minutes2[$i] = $i;
		$smarty->assign("minutes1", $minutes1);
		$smarty->assign("minutes2", $minutes2);

		$smarty->assign("cronBasePath", ac_basedir());

		// figure out server type
		$smarty->assign("isWindows", strtoupper(substr(PHP_OS, 0, 3)) === 'WIN');

		// figure out which ones are protected ones
		$smarty->assign('cron_protected', $GLOBALS['ac_cron_protected']);
	}
}

?>
