<?php

require_once ac_global_functions("group.php");
require_once ac_global_classes("select.php");
require_once ac_global_classes("pagination.php");
class group_context extends ACP_Page {

	function group_context() {
		$this->pageTitle = _a("Groups");
		$this->sideTemplate = "";
		$this->ACP_Page();
		if ( ac_site_isknowledgebuilder() and !ac_site_isstandalone() ) {
			ac_http_redirect($this->site['p_link2'] . '/admin/main.php?action=group');
		}
	}

	function process(&$smarty) {
		$this->setTemplateData($smarty);

		$smarty = ac_ihook("ac_group_context_post", $smarty);

		if ($this->admin["id"] != 1 && !$smarty->getvar("_group_can_add") && !$smarty->getvar("_group_can_edit") && !$smarty->getvar("_group_can_delete")) {
			ac_smarty_noaccess($smarty);
			return;
		}

		$smarty->assign("content_template", "group.htm");

		$so = new AC_Select;
		$so->count();
		$total = ac_sql_select_one(ac_group_select_query($so));
		$count = $total;

		$paginator = new Pagination($total, $count, 20, 0, 'main.php?action=group');
		$paginator->ajaxAction = 'group!ac_group_select_array_paginator';
		$smarty->assign('paginator', $paginator);

		$sections = array(
			array("col" => "title", "label" => _a("Titles")),
			array("col" => "descript", "label" => _a("Descriptions")),
		);

		$smarty->assign("search_sections", $sections);
	}
}

?>
