<?php

require_once(ac_global('functions/re.php'));

class Hooks_Edit_Context extends AC_Context {

    function Hooks_Edit_Context() {
    }

    function process(&$smarty) {
       // privilege check
        $admin = absolute_admin_check();

        if (!$admin || $admin['id'] != 1)
            return ac_smarty_noaccess($smarty);

        // assign template
        $smarty->assign('content_template', 'hooks_edit.tpl.htm');
        ac_smarty_submitted($smarty, $this);

        if (isset($_GET["id"])) {
            $smarty->assign('hook', ac_sql_select_row("
                SELECT
                    *
                FROM
                    `#hooks`
                WHERE
                    `id` = ".(int)$_GET["id"]
            ));
        }

        if ($smarty->get_template_vars('content_template') == 'hooks_edit.tpl.htm') {
            $smarty->assign('hlocations', ac_hook_locations());
            $smarty->assign('hgroups', ac_hook_groups());
        }
    }

    function formProcess(&$smarty) {
        if (!isset($_POST["mode2"]))
            return true;

        if (!ac_re_is_integer($_POST["priority"]))
            return ac_smarty_message($smarty, "You must enter a decimal number for the priority field.");

        $ary = array(
            "call" => $_POST["call"],
            "code"   => $_POST["code"],
            "description" => $_POST["description"],
            "groupid" => $_POST["groupid"],
            "priority" => $_POST["priority"],
            "status" => $_POST["status"],
        );

        switch ($_POST["mode2"]) {
            case 'update':
                ac_sql_update("#hooks", $ary, "`id` = ".(int)$_POST["id"]);
                break;
            case 'insert':
                ac_sql_insert("#hooks", $ary);
                break;
            default:
                break;
        }

        ac_smarty_message($smarty, "Your changes have been saved successfully.");
        $ctx = ac_hook_context($smarty, "viewhooks");
        $ctx->process($smarty);
    }
}

?>
