<?PHP

/*
 *
 */

require_once(ac_global_functions('import.php'));
require_once(ac_global_classes('page.php'));

class import_context extends ACP_Page {

	var $importer = 'import';
	var $backlink = '';

	var $multiDestination = false;

	// constructor
	function import_context() {
		// have to refetch application's ac_global.php file to ensure we have a reference
		require(ac_admin('functions/ac_global.php'));
		$this->pageTitle = _a("Import Tool");
		parent::ACP_Page();
	}




	function process(&$smarty) {
 		$this->setTemplateData($smarty);

		// relation ids (categories, departments, lists)
		$rels = ac_ihook('ac_import_relations');
		if ( !is_array($rels) ) $rels = array();
		$smarty->assign('rels', $rels);


		// header template? (for permission checks, notices, explanations, help, etc...)
		$tpl = ac_ihook('ac_import_header_template');
		if ( $tpl ) $smarty->assign('import_header_template', $tpl);

		// destinations template?
		$tpl = ac_ihook('ac_import_destinations_template');
		if ( $tpl ) $smarty->assign('import_destinations_template', $tpl);

		// additional import vars
		$vars = ac_ihook('ac_import_tplvars', 0); // returns associative array, keys are vars in smarty
		if ( is_array($vars) ) $smarty->assign($vars);

		// fields
		$fields = ac_ihook('ac_import_fields', 0, null);
		if ( !is_array($fields) ) $fields = array();
		$smarty->assign('fields', $fields);

		// import options
		$opts = ac_ihook('ac_import_options', 0);
		if ( !is_array($opts) ) $opts = array();//dbg($opts);
		$smarty->assign('opts', $opts);

		// relid could be provided
		$relid = (int)ac_http_param('relid');
		$smarty->assign('relid', $relid);

		// assign action/mode
		$smarty->assign('mode', 'import');

		// assign importer id
		$smarty->assign('importer', $this->importer);

		$smarty->assign('backlink', $this->backlink);

		$smarty->assign('multiDestination', $this->multiDestination);

		// assign template
		$smarty->assign('content_template', 'import.htm');
	}


}


?>
