<?php

require_once ac_global_functions("loginsource.php");
require_once ac_global_classes("select.php");
require_once ac_global_classes("pagination.php");

class loginsource_context extends ACP_Page {

	function loginsource_context() {
		$this->pageTitle = _a("Login Sources");
		$this->ACP_Page();
	}

	function process(&$smarty) {

		if ( !ac_admin_ismaingroup() || isset($GLOBALS['_hosted_account']) ) {
			ac_smarty_noaccess($smarty, $this);
			return;
		}

		ac_loginsource_sync();
		$smarty->assign("content_template", "loginsource.htm");

		$so = new AC_Select;
		$so->count();
		$total = (int)ac_sql_select_one(ac_loginsource_select_query($so));
		$count = $total;

		$paginator = new Pagination($total, $count, 20, 0, 'main.php?action=loginsource');
		$paginator->allowLimitChange = true;
		$paginator->ajaxAction = 'loginsource!ac_loginsource_select_array_paginator';
		$smarty->assign('paginator', $paginator);
		$this->setTemplateData($smarty);

		require_once ac_global_functions("group.php");
		$so = new AC_Select;
		$so->push("AND id != 1");	# Skip the visitor group
		$groups = ac_sql_select_array(ac_group_select_query($so, false));
		$smarty->assign("groups", $groups);

		if (ac_ihook_exists("acg_loginsource_context"))
			$smarty = ac_ihook("acg_loginsource_context", $smarty);
	}
}

?>
