<?PHP

/*
 *
 */
require_once(ac_global_classes('page.php'));

class settings_update_context extends ACP_Page {

	// constructor
	function settings_update_context() {
		if ( ac_site_isknowledgebuilder() ) {
			$this->pageTitle = sprintf(_a("About %s"), $GLOBALS['ac_app_name']);
		} else {
			$this->pageTitle = _a("Check for Updates");
		}
		$this->sideTemplate = $GLOBALS['ac_sidemenu_settings'];
		parent::ACP_Page();
	}



	function process(&$smarty) {
 		$this->setTemplateData($smarty);
		// check for privileges first!
		if ( $this->admin['id'] != 1 ) {
			// assign template
			$smarty->assign('content_template', 'noaccess.htm');
			return;
		}


		$fetched = false;
		$latest = (string)ac_http_get('http://www.activatelicense.com/update_checker.php?check_val=' . $GLOBALS['ac_app_id']);
		if ( $latest != '' ) {
			$fetched = true;
			ac_sql_update_one('#backend', 'updateversion', $latest);
			$GLOBALS['site']['updateversion'] = $latest;
		}
		$shouldUpdate = ( ( $latest != 0 and $latest != '' ) ? version_compare($GLOBALS['site']['version'], $latest, '<' ) : false );
		$smarty->assign('latest', $latest);
		$smarty->assign('fetched', $fetched);
		$smarty->assign('shouldUpdate', $shouldUpdate);

		$smarty->assign('appID', $GLOBALS['ac_app_id']);
		$smarty->assign('encoding', ac_php_encoding());
		$smarty->assign('hash', md5($this->site['serial']));

		// assign template
		$smarty->assign('content_template', 'settings_update.htm');
	}


}

?>