<?php

require_once ac_global_functions('user.php');
require_once ac_global_classes("pagination.php");

class user_context extends ACP_Page {

	function user_context() {
		$this->pageTitle = _a('Users');
		$this->sideTemplate = "";
		$this->ACP_Page();
		#$this->subject = _a('User');
		#$this->tpl_view = 'user.htm';
		if ( ac_site_isknowledgebuilder() and !ac_site_isstandalone() ) {
			ac_http_redirect($this->site['p_link2'] . '/admin/main.php?action=user');
		}
	}

	function permissions(&$smarty) {
		$smarty->assign("hasedit", true);
		$smarty->assign("hasdelete", true);
	}

	function export() {
		$ary = array(
			"user" => ac_http_param("export_user") == "true",
			"name" => ac_http_param("export_name") == "true",
			"email" => ac_http_param("export_email") == "true",
			"filterid" => ac_http_param("filterid"),
		);

		ac_user_export($ary);
	}

	function process(&$smarty) {
		$this->setTemplateData($smarty);

		$smarty = ac_ihook("ac_user_context_pre", $smarty);

		if ($this->admin["id"] != 1 && !$smarty->getvar("_user_can_add") && !$smarty->getvar("_user_can_edit") && !$smarty->getvar("_user_can_delete")) {
			ac_smarty_noaccess($smarty);
			return;
		}

		if (ac_http_param("export")) {
			$this->export();
			return;
		}

		$this->permissions($smarty);
		$so = new AC_Select;
		$so->count();
		$total = ac_sql_select_one(ac_user_select_query_localcount($so),'',1,false);
		$count = $total;

		$paginator = new Pagination($total, $count, 20, 0, 'main.php?action=user');
		$paginator->ajaxAction = 'user!ac_user_select_paginator';
		$smarty->assign('paginator', $paginator);

		# Global paginator

		$so->clear();
		$so->count();
		$total = ac_sql_select_one(ac_user_select_query($so, true),'',1,true);
		$count = $total;

		$gpag = new Pagination($total, $count, 20, 0, 'main.php?action=user');
		$gpag->ajaxAction = 'user!ac_user_select_paginator_global';
		$smarty->assign('global_paginator', $gpag);

		$smarty->assign('global_count', $total);

		# Groups

		require_once ac_global_functions("group.php");

		$so = new AC_Select;
		$so->push("AND id > 1");				# Exclude the Visitors group

		if (!ac_admin_ismaingroup()) {
			$groupstr = implode("','", $GLOBALS["admin"]["groups"]);
			$so->push("AND id IN ('$groupstr')");
		}

		$so->orderby("title");
		$groups = ac_group_select_array($so);
		$smarty->assign("groups", $groups);
		$smarty->assign("fgroups", $groups);
		$smarty->assign("ac_admin_ismaingroup", ac_admin_ismaingroup());

		# Sections

		$sections = array(
			array("col" => "username", "label" => _a("User names")),
			array("col" => "first_name", "label" => _a("First names")),
			array("col" => "last_name", "label" => _a("Last names")),
			array("col" => "email", "label" => _a("Email addresses")),
		);

		$smarty->assign("search_sections", $sections);
		$smarty->assign("content_template", 'user.htm');

		if ( !isset($GLOBALS['ac_app_id']) ) require(ac_admin('functions/ac_global.php'));
		$smarty->assign("app_id", $GLOBALS['ac_app_id']);
	}
}

?>
