<?php

class Users_Context extends AC_Context {
    function Users_Context() {
        $this->subject = _a("Admin User");
		$this->title   = _a("Admin Users");
        $this->tpl_view = 'users_view.tpl.htm';
        $this->tpl_edit = 'users_edit.tpl.htm';
        $this->admin = ac_admin_get();
    }

    function process(&$smarty) {
        if (!ac_admin_isadmin())
            return ac_smarty_noaccess($smarty);

        ac_ajax_dontrun();

        ac_smarty_load_get($smarty);
        ac_smarty_submitted($smarty, $this);

        if ($this->error) {
            $_GET["mode"] = "edit";
            $_GET["id"]   = $_POST["id"];
            $_SERVER["REQUEST_METHOD"] = "GET";
        }

        require_once ac_global_api('admin/users.php');

        $this->handle($smarty);
        ac_smarty_load_get($smarty);
    }

    function view(&$smarty) {
        $admin = $this->admin;
        require_once(ac_global_api('admin/users.php'));

        $smarty->assign('show_add', false);
        $smarty->assign('show_edit', false);
        $smarty->assign('show_delete', false);

        ac_ihook('ac_users_context_view', $smarty, $GLOBALS['admin']);

        if (isset($_SESSION['_view_show_edit'])) {
            $smarty->assign('show_edit', $_SESSION['_view_show_edit']);
            unset($_SESSION['_view_show_edit']);
        }
        if (isset($_SESSION['_view_show_delete'])) {
            $smarty->assign('show_delete', $_SESSION['_view_show_delete']);
            unset($_SESSION['_view_show_delete']);
        }
        if (isset($_SESSION['_view_show_add'])) {
            $smarty->assign('show_add', $_SESSION['_view_show_add']);
            unset($_SESSION['_view_show_add']);
        }

        $smarty->assign('content_template', 'users_view.tpl.htm');
        $smarty->assign('users', users_select('list', ac_admin_parent_of($admin)));

        if (isset($GLOBALS['show_global']))
            $smarty->assign('global', users_select('list_global', 0));
    }

    function delete(&$smarty) {
        if (ac_http_param('id')) {
            $ret = users_delete(ac_http_param('id'));
        }
        ac_smarty_message_delete($smarty, $this->subject);
        ac_smarty_redirect($smarty, "main.php?action=admins");
    }

    function add(&$smarty) {
        if (isset($GLOBALS['over_user_limit']) && $GLOBALS['over_user_limit']) {
            ac_smarty_message($smarty, _a("Sorry!  Your action could not be completed because you have reached your user limit"));
            ac_smarty_redirect($smarty, "main.php?action=admins");
        }
		$adminid = 0;
		$absid   = intval(ac_http_param("id"));

		if ($absid > 0)
			$adminid = ac_sql_select_one("SELECT id FROM #admin WHERE absid = '$absid'");

        $smarty = ac_ihook('ac_users_context_addedit', $smarty, $adminid);
        $smarty->assign('content_template', 'users_edit.tpl.htm');
    }

    function edit(&$smarty) {
        if (ac_http_param('id')) {
            require_once ac_global_api('admin/users.php');
            $smarty->assign('user', users_select('one', ac_admin_parent_of($this->admin), ac_http_param('id')));
        }

        $this->add($smarty);
    }

    function update(&$smarty) {
        if (isset($_POST['id'])) {
            $absid = intval($_POST['id']);

			ac_auth_update($this->ary, $absid);
            $adminid = ac_sql_select_one("id", "#admin", "`absid` = '$absid'");
            users_update($absid, -1);
            ac_ihook('ac_users_context_update', $adminid);

            ac_smarty_message_update($smarty, $this->subject);
        }

        ac_smarty_redirect($smarty, "main.php?action=admins");
    }

    function insert(&$smarty) {
        if (isset($GLOBALS['over_user_limit']) && $GLOBALS['over_user_limit']) {
            ac_smarty_message($smarty, _a("Sorry!  Your action could not be completed because you have reached your user limit"));
            ac_smarty_redirect($smarty, "main.php?action=admins");
        }

        if (isset($GLOBALS['admin']['acctid']))
            $acctid = intval($GLOBALS['admin']['acctid']);
        else
            $acctid = 0;

        if ($acctid > 0)
            $this->ary["acctid"] = $acctid;

		$id = ac_auth_create($this->ary["username"], $this->ary["password"], $this->ary["first_name"], $this->ary["last_name"], $this->ary["email"]);
        users_import($id);

        ac_smarty_message_insert($smarty, $this->subject);
        ac_smarty_redirect($smarty, "main.php?action=admins");
    }

    function catchall(&$smarty, $mode) {
        switch ($mode) {
            case 'import':
                if (isset($GLOBALS['over_user_limit']) && $GLOBALS['over_user_limit']) {
                    ac_smarty_message($smarty, _a("Sorry!  Your action could not be completed because you have reached your user limit"));
                    ac_smarty_redirect($smarty, "main.php?action=admins");
                }

                if (ac_http_param('id')) {
                    $ret = users_import(ac_http_param('id'));
                    ac_smarty_message_insert($smarty, $this->subject);
                }

                ac_smarty_redirect($smarty, "main.php?action=admins");
                break;

            default:
                break;
        }
    }

    function formProcess(&$smarty) {
        if (!isset($_POST["mode"]))
            return true;

        $this->ary = array(
            "password"      => $_POST["password"],
            "first_name"    => $_POST["first_name"],
            "last_name"     => $_POST["last_name"],
            "email"         => $_POST["email"],
        );

        if (isset($_POST["username"]))
            $this->ary["username"] = $_POST["username"];

        if (function_exists('ishosted') && ishosted()) {
            $hostedid = $GLOBALS['admin']['acctid'];
            if ($hostedid > 0)
                $this->ary["username"] = sprintf("%d_%s", $hostedid, $this->ary["username"]);
            else
                unset($this->ary["username"]);
        }

        if ($this->ary["password"] == "") {
			if (isset($_POST["id"])) {
				ac_smarty_message($smarty, _a("You must enter a password"));
				$this->error = true;
				return true;
			}
            unset($this->ary["password"]);
        } elseif (!isset($_POST["password_repeat"]) || $_POST["password_repeat"] == "") {
            ac_smarty_message($smarty, _a("You must retype your password"));
            $this->error = true;
            return true;
        } elseif ($this->ary["password"] != $_POST["password_repeat"]) {
            ac_smarty_message($smarty, _a("Your password and repeated password do not match"));
            $this->error = true;
            return true;
        } else {
            $this->ary["password"] = md5($this->ary["password"]);
        }

        require_once ac_global_functions('auth.php');

        if (!ac_auth_isconnected())
            ac_auth_connect();

        return true;
    }
}

?>
