<?php
/**
* CPAINT (Cross-Platform Asynchronous INterface Toolkit)
*
* http://sf.net/projects/cpaint
* 
* released under the terms of the GPL
* see http://www.fsf.org/licensing/licenses/gpl.txt for details
* 
*
* proxy script to pass request on to remote servers
*
* @package    CPAINT
* @author     Paul Sullivan <wiley14@gmail.com>
* @author     Dominique Stender <dstender@st-webdevelopment.de>
* @copyright  Copyright (c) 2005-2006 Paul Sullivan, Dominique Stender - http://sf.net/projects/cpaint
* @version 	   2.0.3
*/

//---- includes ----------------------------------------------------------------
	/**
	*	@include config
	*/
	require_once("cpaint2.config.php");
	
//---- main code ---------------------------------------------------------------

  error_reporting (E_ALL ^ E_NOTICE ^ E_WARNING); 
  set_time_limit(0);
  @set_magic_quotes_runtime(0);
  
  if ($_REQUEST['cpaint_remote_url'] != "") {
    $cp_remote_url      = urldecode($_REQUEST['cpaint_remote_url']);
    $cp_remote_method   = urldecode($_REQUEST['cpaint_remote_method']);
    $cp_remote_query    = urldecode($_REQUEST['cpaint_remote_query']);
    $cp_response_type   = strtoupper($_REQUEST['cpaint_response_type']);
  }

  // propagate XML header if necessary
  if ($cp_response_type == 'XML'
    || $cp_response_type == 'OBJECT') {
    header("Content-type:  text/xml");
  }

  // transfer mode specifics
  if ($cp_remote_method == 'GET') {
    $cp_remote_url    .= '?' . $cp_remote_query;
    $cp_request_body  = '';

    // prepare parameters
    $url_parts  = parse_url($cp_remote_url);
  
    // build basic header
    $cp_request_header  = 'GET ' . $url_parts['path'] . '?' . str_replace(' ', '+', $url_parts['query']) . " HTTP/1.0\r\n"
                        . "Host: " . $url_parts['host'] . "\r\n";
  
  } elseif ($cp_remote_method == 'POST') {
    $cp_request_body  = '&' . $cp_remote_query;

    // prepare parameters
    $url_parts  = parse_url($cp_remote_url);
		
		// check against whitelist
		if ($cpaint2_config["proxy.security.use_whitelist"] == true) {
			$url_allowed = false;
			foreach($cpaint2_proxy_whitelist as $whitelistURL) {
				$whiteList_parts = parse_url("http://" . $whitelistURL);
				$url_parts_temp = parse_url($cp_remote_url);
				if (array_key_exists("path", $whiteList_parts)) {
					if ((strtolower($whiteList_parts["path"]) == strtolower($url_parts_temp["path"])) && (strtolower($whiteList_parts["host"]) == strtolower($url_parts_temp["host"]))) $url_allowed = true;					
				} else {	// no path, check only host
					if (strtolower($whiteList_parts["host"]) == strtolower($url_parts_temp["host"]))	$url_allowed = true;
				}
			}
			if ($url_allowed == false) die("[CPAINT] The host or script cannot be accessed through this proxy.");
		}
    
    // build basic header
    $cp_request_header  = 'POST ' . $url_parts['path']  . " HTTP/1.0\r\n"
                        . "Host: " . $url_parts['host'] . "\r\n"
                        . "Content-Type:  application/x-www-form-urlencoded\r\n";
  }

  // add port if none exists
  if (!isset($url_parts['port'])) {
    $url_parts['port'] = 80;
  }

  // add content-length header
  $cp_request_header .= "Content-Length: " . strlen($cp_request_body) . "\r\n";

  // add authentication to header if necessary
  if ($url_parts['user'] != '') {
    $cp_request_header .= 'Authorization: Basic ' . base64_encode($url_parts['user'] . ':' . $url_parts['pass']) . "\r\n";
  }
  
  if(function_exists("curl_init")){
    $curl_session = curl_init($cp_remote_url);
		curl_setopt($curl_session, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0);
		curl_setopt($curl_session, CURLOPT_FORBID_REUSE, true);

		if ($url_parts['user'] != '') {
			curl_setopt($curl_session, CURLOPT_USERPWD, $url_parts['user'] . ':' . $url_parts['pass']);
			curl_setopt($curl_session, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
		}
		if ($cp_remote_method == 'GET') {
      curl_setopt($curl_session, CURLOPT_GET, true);
    }

		if ($cp_remote_method == 'POST') {
		  curl_setopt($curl_session, CURLOPT_HTTPHEADER, array("Content-Type:  application/x-www-form-urlencoded"));
			curl_setopt($curl_session, CURLOPT_GET, false);
			curl_setopt($curl_session, CURLOPT_POST, true);
			curl_setopt($curl_session, CURLOPT_POSTFIELDS, $cp_request_body);
		}

		curl_exec($curl_session);

		if (curl_errno($curl_session) != 0) {
			die('[CPAINT] CURL experienced the error "' . curl_error($curl_session) . '"');
		}

		curl_close($curl_session);
  } else {

    // open connection
    $cp_socket = @fsockopen($url_parts['host'], $url_parts['port'], $error, $errstr, 10);
    
    if ($cp_socket !== false) {
      // send headers
      @fwrite($cp_socket, $cp_request_header . "\r\n\r\n");
      
      // send body if necessary
      if ($cp_request_body != '') {
        @fwrite($cp_socket, $cp_request_body . "\r\n");
      }
      
      while (!feof($cp_socket)) {
        $http_data = $http_data . fgets($cp_socket);
      }
  
      list($http_headers, $http_body) = explode("\r\n\r\n", $http_data, 2);
      echo($http_body);
      @fclose($cp_socket);
    }
  }

?>
