<?php
// admin.php

require_once dirname(__FILE__) . '/auth.php';
require_once dirname(__FILE__) . '/prefix.php';
require_once dirname(__FILE__) . '/session.php';
require_once dirname(__FILE__) . '/sql.php';
require_once dirname(__FILE__) . '/ihook.php';

$ihooks = ac_admin('functions/ihooks.php');

if (file_exists($ihooks))
    require_once $ihooks;

// For ac_admin_get() to work, two ihooks must be declared.  The first,
// ac_admin_get_query, returns the result set of an ac_sql_query call
// which should comprise all of the columns from #admin, #admin_p,
// whatever tables that you want to include in the array that will be
// returned by ac_admin_get().  The second, ac_admin_get_post, doesn't
// need to be declared; it's there to modify the array after everything
// else has been done and the function is finishing up.  Both of these
// features are necessary in TrioLive.

function ac_admin_get() {
	if ( isset($GLOBALS['admin']) && isset($GLOBALS['admin']['username']) ) {
		if ($GLOBALS["admin"]["id"] != 0 && isset($GLOBALS['ac_editor_rootpath']) && !isset($GLOBALS["_hosted_account"])) {
			$_SESSION["ACIsLoggedIn"] = true;
			$_SESSION["ACRootPath"]   = ( ac_site_isstandalone() ? ac_base() : dirname(ac_base()) ) . '/' . $GLOBALS['ac_editor_rootpath'];
		}

		return $GLOBALS['admin'];
	}
    if ( defined('ACP_USER_NOAUTH') and ACP_USER_NOAUTH ) {
	    if (!ac_auth_isconnected())
	        ac_auth_connect();

	    ac_auth_define_cookie();

        //$authenticated = ac_auth_ok();
		if (ac_ihook_exists("ac_admin_get_noauth"))
			return ac_ihook("ac_admin_get_noauth");
		else
			return false;
    }
    if (!isset($_SESSION[ac_prefix("acp_admin")]) || ac_session_need_update()) {
        // Get the global authenticator to do authentication
        $authenticated = ac_auth_ok();

        if( !$authenticated ) {
			if (ac_ihook_exists("ac_admin_get_noauth"))
				return ac_ihook("ac_admin_get_noauth");
			else
				return false;
        }

        // User is authenticated, fetch his local data
        $userId = ac_auth_id();

        $r = ac_admin_get_totally_unsafe($userId, 'absolute');
        if ( !$r ) {
			if (ac_ihook_exists("ac_admin_get_noauth"))
				return ac_ihook("ac_admin_get_noauth");
			else
				return false;
        }
        $_SESSION[ac_prefix("acp_admin")] = $r;
    } else {
        $r = $_SESSION[ac_prefix("acp_admin")];
    }
    $_SESSION['authenticated_username'] = $r['username'];

    return $r;
}

function ac_admin_get_totally_unsafe($id, $method = 'local') {
	if ($method == 'absolute') {
		$sql = ac_ihook('ac_admin_get_query', $id);
	} else {
		# This is just in case a product is built without the local ihook--at least it'll
		# function.  In most cases with our apps, this is called with id=1, and it doesn't matter
		# then if we use the absolute query.
		if (ac_ihook_exists("ac_admin_get_query_local"))
			$sql = ac_ihook('ac_admin_get_query_local', $id);
		else
			$sql = ac_ihook("ac_admin_get_query", $id);
	}

    if ( !$sql ) return false;

    if ( mysql_num_rows($sql) == 0 ) return false;
    // fetch his info to return
    $r = mysql_fetch_assoc($sql);
	if ($method == 'absolute')
		$thisUser = ac_auth_record_id($id);
	else
		$thisUser = ac_auth_record_id($r['absid']);

    $r['username']   = $thisUser['username'];
    $r['first_name'] = $thisUser['first_name'];
    $r['last_name']  = $thisUser['last_name'];
    $r['email']      = $thisUser['email'];
    $r["fullname"]   = $thisUser['first_name'] . ' ' . $thisUser['last_name'];

    if (isset($thisUser['acctid']))
        $r['acctid'] = $thisUser['acctid'];
    // update his info
    ac_admin_marktime("id = '$r[id]'");
    $r = ac_ihook('ac_admin_get_post', $r);

    $r['accessadmin'] = 1;

    return $r;
}

// If we're logged in with our admin status cached in $_SESSION, then
// return true.  Otherwise, run the full check in ac_admin() and return
// whether it was true or not.  $id is a specific id that we want to
// match, and if it's a (positive) non-zero number then we must do a
// full check.

function ac_admin_isauth($id = 0) {
    if ($id < 1 && isset($_SESSION[ac_prefix("acp_admin")]) && $_SESSION[ac_prefix("acp_admin")]['id'])
        return true;

    $admin = ac_admin_get();

    if ($id < 1 && isset($admin['id']) && $admin['id'] > 0)
        return true;
    else
        return $admin['id'] == $id && $id > 0;
}

function ac_admin_isadmin() {
	$admin = ac_admin_get();
	if ( !isset($admin['id']) ) return false;
	if ( $admin['id'] < 1 ) return false;
	if ( !isset($admin['p_admin']) ) return true;
	return ( $admin['p_admin'] == 1 );
}

function ac_admin_ismain() {
	$admin = ac_admin_get();
	return ( ac_admin_isadmin() && ac_admin_isauth(1) );
}

function ac_admin_ismaingroup() {
	if ( !ac_admin_isadmin() ) return false;
	$admin = ac_admin_get();
	if ( isset($admin['groups']) ) return isset($admin['groups'][3]);
	return ac_admin_ismain();
}

function ac_admin_isuser() {
	$admin = ac_admin_get();
	if ( !isset($admin['id']) ) return false;
	if ( $admin['id'] < 1 ) return false;
	if ( !isset($admin['p_admin']) ) return false;
	return ( $admin['p_admin'] != 1 );
}

function ac_admin_isguest() {
	$admin = ac_admin_get();
	if ( !isset($admin['id']) ) return true;
	if ( $admin['id'] == 0 ) return true;
	return false;
}


// Just return one of the attributes of the admin array.

function ac_admin_attr($attr) {
    $key = ac_prefix("acp_admin");
    if (!isset($_SESSION[$key])) {
        $ary = ac_admin_get();

        if (!$ary)
            return false;

        return $ary[$attr];
    }

    return $_SESSION[$key][$attr];
}

function ac_admin_parent_of(&$admin) {
    if (isset($admin['parentid'])) {
        if ($admin['parentid'] == 0)
            return intval($admin['id']);
        else
            return intval($admin['parentid']);
    } else {
        return intval($admin['id']);
    }
}

function ac_admin_list($parentid = 0, $fieldName = 'parentid') {
    $admin = ac_admin_get();

    if (!$admin)
        return array();

    $allAdmins = array();

    $sql = ac_ihook('ac_admin_list_query', $admin);

    while( $row = mysql_fetch_assoc($sql) ) {
        if ($parentid > 0 && isset($row[$fieldName]) && $row[$fieldName] != $parentid && $row['id'] != $parentid)
            continue;

        // fetch user from global auth table
        $userObj = ac_auth_record_id($row['absid']);
        if ( $userObj != null ) {
            $row['fullname'] = $row['firstname'] = $userObj['first_name'];
            $row['lastname'] = $userObj['last_name'];
            if ( $row['lastname'] != '' ) $row['fullname'] .= ' ' . $row['lastname'];

            $allAdmins[$row['id']] = ac_sql_unescape_array($row);
        } else {
            $row['fullname'] = '';
            $row['lastname'] = '';
            $row['firstname'] = '';
        }
    }

    return $allAdmins;
}

function ac_admin_lookup($user, $email, $type = 'admin', $action = 'account_lookup') {
	$GLOBALS['_context_post_result'] = false;
    // assume there is an error
    $message = _a("User information invalid.");

    if (function_exists('ishosted') && ishosted()) {
        $globalUser = ac_auth_hosted_record_user_email($user, $email);
        if ($globalUser === null)
            return $message;
    } else {
        $globalUser = ac_auth_record_user_email($user, $email);
        if ($globalUser === null)
            return $message;
    }

    $absid = $globalUser['id'];

    // fetch user info
    $table = ( ac_site_ismodern() ? 'user' : 'admin' );
    $log = ac_sql_query("SELECT * FROM `#$table` WHERE `absid` = '$absid'");
    $log_num = ac_sql_num_rows($log);

    // user not found
    if ( !$log_num ) return $message;

    // user found
	$GLOBALS['_context_post_result'] = true;
    // fetch him
    $user_info = ac_sql_fetch_assoc($log);
    $user_info['username'] = $globalUser['username'];
    $user_info['password'] = $globalUser['password'];
    $user_info['first_name'] = $globalUser['first_name'];
    $user_info['last_name'] = $globalUser['last_name'];
    $user_info['email'] = $globalUser['email'];
    $user_info['full_name'] = implode(' ', array(trim($user_info['first_name']), trim($user_info['last_name'])));
    // link to admin home
	if ($type == 'admin')
		$site_link = ac_site_alink();
	else
		$site_link = ac_site_plink();
    $s1 = base64_encode($user_info['password']);
    $s2 = base64_encode($user_info['username']);
    $s3 = $user_info['absid'] + 728134;
    $string = urlencode($s1 . $s2);
    // link to change pass
    $site_link .= "/index.php?action=$action&r=$s3&r2=$string";
    $site       = ac_site_get();
    $subject    = _a('Password reset request.');
    // call smarty to make an e-mail body
    $smarty = new AC_Smarty( ac_site_isvisualedit() ? 'public' : 'admin', true);
    // assign link to template
    $smarty->assign('site', $site);
    $smarty->assign('user', $user_info);
    $smarty->assign('site_link', $site_link);
    $text = $smarty->fetch('account_lookup.tpl.txt');
    require_once ac_global_functions('mail.php');
    if (isset($site['sname'])) {
        ac_mail_send('text', $site['sname'], $site['em_from'], $text, $subject, $email, $user_info['full_name']);
    }
    else {
    		$email_from = ( isset($site['emfrom']) ) ? $site['emfrom'] : $email;
        ac_mail_send('text', _a("Password Lookup"), $email_from, $text, $subject, $email, $user_info['full_name']);
    }
    $message = _a("Please check your email to confirm your password resetting.");
    return $message;
}

function ac_admin_resetpass($r, $r2, $section = 'admin') {
    // assume there is an error
    $message = _a("User information invalid.");
    // escape posted data
    $id = (int)$r - 728134;
    // try to find a user
    $user_info = ac_auth_record_id($id);
    // user found
    if ( $user_info ) {
        // additional check
        $s1 = base64_encode($user_info['password']);
        $s2 = base64_encode($user_info['username']);
        $string = $s1 . $s2;
        // additional check passed

        if ( $string == $r2 ) {
            //define new pass
            $token = md5(time() . $_SERVER['REMOTE_ADDR']);
            $pass = substr($token, 0, 7);
            $passec = md5($pass);
			mysql_query("UPDATE acp_globalauth SET password = '$passec' WHERE id = '$user_info[id]'", $GLOBALS["auth_db_link"]);
	        $user_info['full_name'] = implode(' ', array(trim($user_info['first_name']), trim($user_info['last_name'])));
            // prepare to send e-mail
            $email = $user_info['email'];
            // If they request password reset from admin or public side, direct them back to the appropriate section
            $site_link = ($section == 'admin') ? ac_site_alink() : ac_site_plink();
            $subject = _a('Your new password.');
            $site = ac_site_get();
            // prepare Smarty for mail body
            $smarty = new AC_Smarty(ac_site_isvisualedit() ? 'public' : 'admin', true);
            // assign link to template
            $smarty->assign('site', $site);
            $smarty->assign('user', $user_info);
            $smarty->assign('site_link', $site_link);
            // assign new password
            $smarty->assign('pass', $pass);
            $text = $smarty->fetch('account_newpass.tpl.txt');
            require_once ac_global_functions('mail.php');
            if (isset($site['sname']))
                ac_mail_send('text', $site['sname'], $site['em_from'], $text, $subject, $email, $user_info['full_name']);
            else
                ac_mail_send('text', _a("Password Reset"), $email, $text, $subject, $email, $user_info['full_name']);
            $message = _a("Password Reset. Please check your email for the new password.");
        }
    }
    return $message;
}

function ac_admin_failures($ip) {
    $s_date = date("Y-m-d");
    $s_time = date("H:i:s");
    list($year, $month, $day) = explode("-", $s_date);
    list($hours, $minutes, $seconds) = explode(":", $s_time);
    $time_cutoff = date("H:i:s", mktime($hours, $minutes - 5, $seconds, $month, $day, $year));

    $sql = ac_sql_query("SELECT * FROM `#admin_b_log` WHERE `ip` = '$ip' AND `date` = '$s_date' AND `time` >= '$time_cutoff'");

    if (!$sql)
        die(mysql_error());

    return ac_sql_num_rows($sql);
}

function ac_admin_marktime($where) {
	if ( ac_site_isknowledgebuilder() || ac_site_issupporttrio3() ) {
	    $ary = array(
	        '=last_login' => 'NOW()',
	    );
//	} elseif ( ac_site_is12all5() ) {
	} else {
	    $ary = array(
	        '=ldate' => 'CURDATE()',
	        '=ltime' => 'CURTIME()',
	    );
	}

	$table = ( ac_site_isknowledgebuilder() || ac_site_is12all5() || ac_site_issupporttrio3() ? '#user' : '#admin' );
    ac_sql_update($table, $ary, $where);
}

function ac_admin_logfailure($user, $pass, $ip, $host) {
    $ary = array(
        'user' => $user,
        'pass' => $pass,
        'ip'   => $ip,
        'host' => $host,
        '=time' => 'CURTIME()',
        '=date' => 'CURDATE()',
    );

    ac_sql_insert("#admin_b_log", $ary);
}

function ac_admin_check_details($user, $pass) {
    $encpass = md5($pass);
    $log_num = ac_sql_select_one("COUNT(*) FROM #admin WHERE user = '$user' AND pass = '$encpass'");

    if ( $log_num == 1 ) {
        ac_admin_marktime("user = '$user'");
        return true;
    }

    return false;
}

function ac_admin_create($absid, $user, $email, $parentid = 0) {
    $site = ac_site_get();
    $ary = array(
        'absid'       => $absid,
        'lang'        => $site['lang'],
        '=date_added' => 'CURDATE()',
        'parentid'    => $parentid,
        'user'        => $user,
        'email'       => $email,
    );

    ac_sql_insert("#admin", $ary);

    $ary = array(
        'id' => ac_sql_insert_id(),
    );

    ac_sql_insert("#admin_p", $ary);
}

function ac_admin_has_absid($absid) {
    $absid = intval($absid);
    $count = ac_sql_select_one("SELECT COUNT(*) FROM `#admin` WHERE `absid` = '$absid'");

    return $count > 0;
}

function ac_admin_set($authId) {
	$auth = ac_auth_record_id($authId);
    $key = ac_auth_format($auth, $auth['id']);
    $_SESSION["globalauth_".$key] = true;
    ac_auth_set_cookie(AC_AUTH_COOKIE, $key, 0);
    $_SESSION[ac_prefix("acp_admin")] = ac_admin_get_totally_unsafe($authId, 'absolute');
    return $_SESSION[ac_prefix("acp_admin")];
}

?>