<?php
// auth.php

// Functions to authenticate users via the acp_globalauth table, and to
// store auth credentials in cookies.

require_once dirname(__FILE__) . "/sql.php";
require_once dirname(__FILE__) . "/prefix.php";
require_once dirname(__FILE__) . "/http.php";
require_once dirname(__FILE__) . "/auth_h.php";

$authPath = dirname(dirname(dirname(__FILE__))) . "/admin";
if ( defined('AC_KB_STANDALONE') and !AC_KB_STANDALONE ) {
	$authPath = dirname(ac_basedir()) . '/admin';
} elseif ( isset($GLOBALS['updaterStep']) and isset($GLOBALS['doUpdate']) ) {
	if ( $GLOBALS['subapp'] ) $authPath = dirname(ac_basedir()) . '/admin';
}
require_once $authPath . '/authentication_db.inc.php';

if ( !defined("AC_AUTH_USERP_PASSP") ) define("AC_AUTH_USERP_PASSP", 0);
if ( !defined("AC_AUTH_USERM_PASSP") ) define("AC_AUTH_USERM_PASSP", 1);
if ( !defined("AC_AUTH_USERM_PASSM") ) define("AC_AUTH_USERM_PASSM", 2);

function _ac_auth_var($name) {
    return ac_http_param($name);
}

function ac_auth_ok() {
	ac_auth_define_cookie();
    $id = ac_auth_id();

    if ($id < 0)
        return ac_auth_failed();

    $cval = $_COOKIE[AC_AUTH_COOKIE];
    if (ac_auth_ok_session($cval))
        return true;

    // If we get to this point, we'll have to ask the sql server if this
    // user is ok.

    if (!($fmt = ac_auth_has_userid($id)))
        return ac_auth_failed();

    if ($fmt == $cval)
        return true;

    return ac_auth_failed();
}

function ac_auth_record_id($id = 0) {
    if (!ac_auth_isconnected())
        ac_auth_connect();

	$id = intval($id);
    $rs = mysql_query("SELECT *, NOW() AS a_now FROM `acp_globalauth` WHERE `id` = ".$id, $GLOBALS["auth_db_link"]);
    if (mysql_num_rows($rs) > 0)
        $row = mysql_fetch_assoc($rs);
    else
        return null;

    if (!$row)
        return null;

    return $row;
}

function ac_auth_record_username($username = '') {
    if (!ac_auth_isconnected())
        ac_auth_connect();

	$username = ac_auth_escape($username);
    $rs = mysql_query("SELECT *, DATABASE(), NOW() AS a_now FROM `acp_globalauth` WHERE `username` = '$username'", $GLOBALS["auth_db_link"]);
    if (mysql_num_rows($rs) > 0)
        $row = mysql_fetch_assoc($rs);
    else
        return null;

    if (!$row)
        return null;

    return $row;
}

function ac_auth_record_email($email, $allrows = false) {
	if (!ac_auth_isconnected())
	    ac_auth_connect();

	$email = ac_auth_escape($email);
	$rs = mysql_query("SELECT *, NOW() AS a_now FROM `acp_globalauth` WHERE `email` = '".$email."'", $GLOBALS["auth_db_link"]);
	if (mysql_num_rows($rs) > 0) {
		if ($allrows) {
			$rval = array();

			while ($row = mysql_fetch_assoc($rs))
				$rval[] = $row;

			return $rval;
		} else
			$row = mysql_fetch_assoc($rs);
	} else
	    return null;

	if (!$row)
	    return null;

	return $row;
}

function ac_auth_record_user_email($user, $email) {
	$user = ac_auth_escape($user);
	$email = ac_auth_escape($email);
    $id = ac_sql_select_one("id", "acp_globalauth", "`username` = '".$user."' AND `email` = '".$email."'", true);

    if ($id == false)
        return null;

    return ac_auth_record_id($id);
}

function ac_auth_record() {
    if (!ac_auth_ok())
        return null;
    return ac_auth_record_id(ac_auth_id());
}

function ac_auth_sql($mode, $user, $pass) {
    $where = '0';
    switch ($mode) {
        case AC_AUTH_USERP_PASSP:
            $where = "`username` = '".$user."' AND MD5(`password`) = '".$pass."'";
            break;
        case AC_AUTH_USERM_PASSP:
            $where = "MD5(`username`) = '".$user."' AND MD5(`password`) = '".$pass."'";
            break;
        case AC_AUTH_USERM_PASSM:
            $where = "MD5(`username`) = '".$user."' AND `password` = '".$pass."'";
            break;
        default:
            break;
    }

    return "
        SELECT
            `id`
        FROM
            `acp_globalauth`
        WHERE " . $where;
}

function ac_auth_define_cookie() {
    if (!defined("AC_AUTH_COOKIE"))
        define("AC_AUTH_COOKIE", ac_prefix("acp_globalauth_cookie"));
}

function ac_auth_cookie_format($prefix) {
	return $prefix . "acp_globalauth_cookie";
}

function ac_auth_id($mode = AC_AUTH_USERP_PASSP) {
    if (!ac_auth_isconnected())
        ac_auth_connect();

    ac_auth_define_cookie();

    if (!isset($_COOKIE[AC_AUTH_COOKIE])) {
        $user = ac_auth_escape(_ac_auth_var("user"));
        $pass = ac_auth_escape(_ac_auth_var("pass"));

        if (!$user || !$pass)
            return -1;

        $rs = mysql_query(ac_auth_sql($mode, $user, $pass), $GLOBALS["auth_db_link"]);

        if ($row = mysql_fetch_assoc($rs)) {
            $_COOKIE[AC_AUTH_COOKIE] = ac_auth_format($row, $row['id']);
            return $row['id'];
        }
        return -1;
    }

    return intval(substr($_COOKIE[AC_AUTH_COOKIE], 32));
}

function ac_auth_format(&$row, $id) {
    if (!$row)
        return "";

    return md5("acp_" . $row["username"]) . $id;
}

function ac_auth_failed() {
	ac_auth_define_cookie();
    @setcookie(AC_AUTH_COOKIE, "", time() - 3600, "/");
    unset($_COOKIE[AC_AUTH_COOKIE]);

    require_once dirname(__FILE__) . "/ihook.php";
    ac_ihook('ac_auth_logout_post');

    return false;
}

function ac_auth_has_userid($id) {
    if (!ac_auth_isconnected())
        ac_auth_connect();

    $res = mysql_query("SELECT username, password FROM acp_globalauth WHERE id = ".(int)$id, $GLOBALS["auth_db_link"]);
    $cnt = mysql_num_rows($res);

    if ($cnt == 1) {
        $row = mysql_fetch_assoc($res);
        $ret = ac_auth_format($row, $id);
        unset($row);
    } else {
        $ret = false;
    }

    mysql_free_result($res);
    return $ret;
}

function ac_auth_ok_session($cval) {
    $key = "globalauth_".$cval;

    if (!isset($_SESSION[$key]))
        return false;
    return $_SESSION[$key] ? true : false;
}

function ac_auth_isconnected() {
    return isset($GLOBALS["auth_db_link"]);
}

function ac_auth_connect() {
    if (!defined("ACP_AUTHDB_SERVER") || !defined("ACP_AUTHDB_USER") || !defined("ACP_AUTHDB_PASS"))
        return null;

    if (defined("ACP_DB_HOST") ) {
    	if ( ACP_DB_HOST == ACP_AUTHDB_SERVER && ACP_DB_USER == ACP_AUTHDB_USER && ACP_DB_PASS == ACP_AUTHDB_PASS && ACP_DB_NAME == ACP_AUTHDB_DB ) {
    		$GLOBALS['auth_db_link'] =& $GLOBALS['db_link'];
    		return $GLOBALS['auth_db_link'];
    	}
    }
    $GLOBALS["auth_db_link"] = ac_auth_connect_args(ACP_AUTHDB_SERVER, ACP_AUTHDB_USER, ACP_AUTHDB_PASS, ACP_AUTHDB_DB);

	if (isset($GLOBALS["ac_auth_utf8"]))
		mysql_query("SET NAMES 'utf8'", $GLOBALS["auth_db_link"]);
    return $GLOBALS["auth_db_link"];
}

function ac_auth_connect_args($server, $user, $pass, $dbname) {
    if (!defined("ACP_ENGINE_SERVER") || $GLOBALS['db_link_crc'] != $GLOBALS['auth_db_link_crc']) {
		$db = mysql_connect($server, $user, $pass, true);
		if (!$db) {
			if (isset($GLOBALS["_hosted_account"]))
				die("Error (1003): We're having some difficulty connecting to your database; we're already looking into the problem; please contact us at support@activecampaign.com if you have any concerns.");
			else
				die("Unable to connect to your authentication database; please ensure that the information held in /admin/authentication_db.inc.php is correct.");
		}
        mysql_select_db($dbname, $db) or die("Unable to select database $dbname after connecting to MySQL: " . ac_auth_sql_error());
    } else {
        $db = $GLOBALS['db_link'];
    }
    return $db;
}

function ac_auth_disconnect() {
    if (ac_auth_isconnected())
        mysql_close($GLOBALS['auth_db_link']);
}

function ac_auth_login_md5($user, $pass, $remember = false) {
    if (!ac_auth_isconnected())
        ac_auth_connect();

    ac_auth_define_cookie();

	$user = ac_auth_escape($user);
	$pass = ac_auth_escape($pass);

	$rs = mysql_query("
		SELECT
			*
		FROM
			`acp_globalauth`
		WHERE
			BINARY `username` = '$user'
		AND
			BINARY `password` = '$pass'
	", $GLOBALS["auth_db_link"]);

	$auth = mysql_fetch_assoc($rs);

	if ($auth == false)
		return ac_auth_failed();

    $key = ac_auth_format($auth, $auth['id']);
    $_SESSION["globalauth_".$key] = true;
    ac_auth_set_cookie(AC_AUTH_COOKIE, $key, $remember);

    require_once dirname(__FILE__) . "/ihook.php";
    ac_ihook('ac_auth_login_post', $remember);
    return true;
}

function ac_auth_login_source($user, $pass, $remember = false) {
    if (!ac_auth_isconnected())
        ac_auth_connect();

    ac_auth_define_cookie();

	if (!$GLOBALS["loginsource"]->auth($user, $pass)) {
		return ac_auth_failed();
	}

	$auth = $GLOBALS["loginsource"]->c_info;

    $key = ac_auth_format($auth, $auth['id']);
    $_SESSION["globalauth_".$key] = true;
    ac_auth_set_cookie(AC_AUTH_COOKIE, $key, $remember);

    require_once dirname(__FILE__) . "/ihook.php";
    ac_ihook('ac_auth_login_post', $remember);
    return true;
}

function ac_auth_set_cookie($cookie, $key, $remember) {
    if (@setcookie($cookie, $key, ($remember ? time() + 1296000 : 0), "/"))
        $_COOKIE[$cookie] = $key;
    else
        unset($_COOKIE[$cookie]);
}

function ac_auth_login_plain($user, $pass, $remember = false) {
	if (isset($GLOBALS["loginsource"]))
		return ac_auth_login_source($user, $pass, $remember);

    return ac_auth_login_md5($user, md5($pass), $remember);
}

function ac_auth_logout() {
    ac_auth_failed();
}

function ac_auth_delete($id) {
	$id = intval($id);
    return ac_sql_delete("acp_globalauth", "`id` = ".$id, true);
}

function ac_auth_create_array($ary, $encodePassword = true) {
	return ac_auth_create($ary['username'], $ary['password'], $ary['first_name'], $ary['last_name'], $ary['email'], $encodePassword);
}

function ac_auth_create($user, $pass, $fname, $lname, $email, $encodePassword = true) {
    if (!ac_auth_isconnected())
        ac_auth_connect();

    if ( $encodePassword ) $pass = md5($pass);

	$user = ac_auth_escape($user);
	$fname = ac_auth_escape($fname);
	$lname = ac_auth_escape($lname);
	$email = ac_auth_escape($email);

    mysql_query("
        INSERT INTO acp_globalauth
            (username, password, first_name, last_name, email)
        VALUES
            ('$user', '$pass', '$fname', '$lname', '$email')
    ", $GLOBALS["auth_db_link"]);

	$newid = mysql_insert_id($GLOBALS["auth_db_link"]);

	if ($auth = ac_auth_record_id($newid)) {
		ac_auth_productset_add($newid);
	}

	return $newid;
}

function ac_auth_product_update($authid, $set) {
	$set = ac_auth_escape($set);
	$authid = (int)$authid;
	mysql_query("UPDATE acp_globalauth SET productset = '$set' WHERE id = '$authid'", $GLOBALS["auth_db_link"]);
}

function ac_auth_productset_add($authid) {
	if (!isset($GLOBALS["ac_app_id"]))
		return;

	$auth = ac_auth_record_id($authid);

	if (!$auth)
		return;

	if (!in_array("productset", array_keys($auth)))
		return;

	$set = ac_auth_product_add($auth["productset"], $GLOBALS["ac_app_id"]);
	ac_auth_product_update($authid, $set);
}

function ac_auth_productset_remove($authid) {
	if (!isset($GLOBALS["ac_app_id"]))
		return;

	$auth = ac_auth_record_id($authid);

	if (!$auth)
		return;

	if (!in_array("productset", array_keys($auth)))
		return;

	$set = ac_auth_product_remove($auth["productset"], $GLOBALS["ac_app_id"]);

	if ($set == "")
		ac_auth_delete($authid);
	else
		ac_auth_product_update($authid, $set);
}

function ac_auth_product_add($set, $id) {
	if ($set == "")
		return $id;

	$ary = explode(",", $set);
	$ary[] = $id;

	return implode(",", $ary);
}

function ac_auth_product_remove($set, $id) {
	if ($set == "")
		return "";

	$ary = explode(",", $set);
	if (!in_array($id, $ary))
		return $set;

	if (count($ary) == 1)
		return "";

	$key = array_search($id, $ary);
	unset($ary[$key]);

	return implode(",", $ary);
}

function ac_auth_update(&$ary, $id) {
    $tmp = array();

    if (isset($ary['username']))
        $tmp['username'] = $ary['username'];
    if (isset($ary['password']))
        $tmp['password'] = $ary['password'];
    if (isset($ary['first_name']))
        $tmp['first_name'] = $ary['first_name'];
    if (isset($ary['last_name']))
        $tmp['last_name'] = $ary['last_name'];
    if (isset($ary['email']))
        $tmp['email'] = $ary['email'];

	if (isset($ary['sourceid'])) {
		$tmp['sourceid'] = intval($ary['sourceid']);
		$tmp['=sourceupdated'] = 'NOW()';
	}

	if ( count($tmp) == 0 ) return false;

	# This escapes for us
    $setstr = ac_sql_set_str($tmp, true);

    if (!ac_auth_isconnected())
        ac_auth_connect();

    return mysql_query("
        UPDATE
            `acp_globalauth`
        SET
            $setstr
        WHERE
            `id` = '$id'
    ", $GLOBALS["auth_db_link"]);
}

function ac_auth_escape($string, $useInLike = false) {
	if (!ac_auth_isconnected())
		ac_auth_connect();
    if (is_array($string)) {
        ac_auth_escape_array($string);
        return $string;
    }
    if (version_compare(phpversion(), "4.3.0") == "-1") {
        $string = mysql_escape_string($string);
    } else {
        $string = mysql_real_escape_string($string, $GLOBALS["auth_db_link"]);
    }
    if ( $useInLike ) $string = addcslashes($string, '%_');
    return $string;
}

function ac_auth_escape_array(&$ary) {
    foreach ($ary as $key => $val) {
        if (is_array($val))
            ac_auth_escape_array($ary[$key]);
        else
            $ary[$key] = ac_auth_escape($val);
    }
    return $ary;
}

function ac_auth_hash_encode($userID, $userName, $serial, $admin = false) {
	// this function should return hash of these 3 values
	$delimiter = '*|*';
	$order = array(6, 3, 1, 4, 2, 5);
	$original = $userID . $delimiter . $userName . $delimiter . md5($serial) . $delimiter . (int)$admin;
	$encoded = base64_encode($original);
	$length = strlen($encoded);
	$chunkSize = ceil($length / 6);
	$chunks = array();
	while ( strlen($encoded) > 0 ) {
		$chunks[] = substr($encoded, 0, $chunkSize);
		$encoded = substr($encoded, $chunkSize);
	}
	$hash = '';
	foreach ( $order as $o ) $hash .= $chunks[ $o - 1 ];
	return urlencode($hash);
}

function ac_auth_hash_decode($hash) {
	// this function should return false if no match or userInfo array if user is found
	$delimiter = '*|*';
	$order = array(6, 3, 1, 4, 2, 5);
	$hash = urldecode($hash);
	$length = strlen($hash);
	$chunkSize = ceil($length / 6);
	$lastPart = $length - $chunkSize * 5;
	$chunks = array();
	// first deal with last part
	$chunks[] = substr($hash, 0, $lastPart);
	$hash = substr($hash, $lastPart);
	while ( strlen($hash) > 0 ) {
		$chunks[] = substr($hash, 0, $chunkSize);
		$hash = substr($hash, $chunkSize);
	}
	$encoded = '';
	for ( $i = 1; $i < 7; $i++ ) {
		$pos = array_search($i, $order);
		if ( !isset($chunks[$pos]) ) return false;
		$encoded .= $chunks[$pos];
		//echo $pos . ' => ' . $i . ', ';
	}
	if ( strlen($encoded) != $length ) return false;
	$original = base64_decode($encoded);
	$arr = explode($delimiter, $original);
	if ( !isset($arr[3]) ) return false;
	$table = ( $arr[3] == 1 ? 'admin' : 'users' );
	$sql = ac_sql_query("
		SELECT
			auth.*,
			cfg.serial
		FROM
			#$table auth,
			#backend cfg
		WHERE
			auth.id = '$arr[0]'
		AND
			auth.user = '$arr[1]'
		AND
			MD5(cfg.serial) = '$arr[2]'
		AND
			cfg.rss = 1
	") or die(mysql_error($GLOBALS['db_link']));
	if ( mysql_num_rows($sql) != 1 ) return false;
	$userInfo = mysql_fetch_assoc($sql);
	unset($userInfo['serial']);
	$userInfo['admin'] = (bool)$arr[3];
	return $userInfo;
}

function ac_auth_search($string, $format = '%%%s%%', $fields = array()) {
	$escaped = sprintf($format, ac_auth_escape($string, true));
	if ( !is_array($fields) or !count($fields) ) $fields = array('username', 'first_name', 'last_name', 'email');
	$conds = array();
	foreach ( $fields as $v ) {
		$conds[] = "`$v` LIKE '$escaped'";
	}
	if ( !$conds ) $conds = array(1);
	$cond = implode(" OR ", $conds);
	$r = array();
	$query = "
		SELECT
			*
		FROM
			`acp_globalauth`
		WHERE
			$cond
		ORDER BY
			`username`
	";
	if ( !ac_auth_isconnected() ) {
		ac_auth_connect();
	}
	$sql = mysql_query($query, $GLOBALS["auth_db_link"]);
	while ( $row = mysql_fetch_assoc($sql) ) {
		$r[$row['id']] = $row;
	}
	return $r;
}

function ac_auth_sql_error() {
	return mysql_error($GLOBALS['auth_db_link']);
}

function ac_auth_sql_error_number() {
	return mysql_errno($GLOBALS['auth_db_link']);
}

?>
