<?php
// base.php

// The base functions, which support including any file from the base of
// the AC directory (ac_base), from the admin directory (ac_admin), and
// from the ac_global library (ac_global).

function ac_basedir() {
    if ( isset($GLOBALS['ac_app_path']) )
    	return $GLOBALS['ac_app_path'];
    else
		return dirname(dirname(dirname(__FILE__)));
}

function ac_base($file = '') {
    if ($file != '')
        return ac_basedir() . '/' . $file;
    return ac_basedir();
}

function ac_admin($file = '') {
    if ($file != '')
        return ac_basedir() . '/admin/' . $file;
    return ac_basedir() . '/admin';
}

function ac_api($file = '') {
    if ($file != '')
        return ac_basedir() . '/api/' . $file;
    return ac_basedir() . '/api';
}

function ac_lang($file = '') {
	$base = ac_basedir();
	// if not standalone
	$standalone = true;
	if ( isset($GLOBALS['site']) and function_exists('ac_site_isstandalone') ) {
		$standalone = ac_site_isstandalone();
	} elseif ( defined('AC_KB_STANDALONE') ) {
		$standalone = AC_KB_STANDALONE;
	}
	if ( !$standalone )
		$base = dirname($base);
    if ($file != '')
        return $base . '/lang/' . $file;
    return $base . '/lang';
}

function ac_global_folder() {
	return basename(dirname(dirname(__FILE__)));
}

function ac_global($file = '') {
    if ( isset($GLOBALS['ac_library_path']) )
    	$basedir = $GLOBALS['ac_library_path'];
    else
		$basedir = ac_basedir() . '/' . basename(dirname(dirname(__FILE__)));
	if ($file != '')
        return $basedir . '/' . $file;
    return $basedir;
}

function ac_global_includes($file = '') {
    if ($file != '')
        return ac_global() . '/includes/' . $file;
    return ac_global() . '/includes';
}

function ac_global_url($path = '') {
    if ( isset($GLOBALS['ac_library_url']) )
    	$basedir = $GLOBALS['ac_library_url'];
    else
		$basedir = ac_site_plink() . '/' . basename(dirname(dirname(__FILE__)));
	if ($path != '')
        return $basedir . '/' . $path;
    return $basedir;
}

function ac_global_api($file = '') {
    if ($file != '')
        return ac_global() . '/api/' . $file;
    return ac_global() . '/api';
}

function ac_global_charts($file = '') {
    if ($file != '')
        return ac_global() . '/charts/' . $file;
    return ac_global() . '/charts';
}

function ac_global_classes($file = '') {
    if ($file != '')
        return ac_global() . '/classes/' . $file;
    return ac_global() . '/classes';
}

function ac_global_context($file = '') {
    if ($file != '')
        return ac_global() . '/context/' . $file;
    return ac_global() . '/context';
}

function ac_global_pear($file = '') {
    if ($file != '')
        return ac_global() . '/pear/' . $file;
    return ac_global() . '/pear';
}

function ac_global_functions($file = '') {
    if ($file != '')
        return ac_global() . '/functions/' . $file;
    return ac_global() . '/functions';
}

function ac_global_smarty_plugins($file = '') {
    if ($file != '')
        return ac_global() . '/smarty_plugins/' . $file;
    return ac_global() . '/smarty_plugins';
}

function ac_init() {
    ac_unescape_gpc();
}

function ac_unescape_gpc() {
    // turn off escaping
    @set_magic_quotes_runtime(0);
    if ( get_magic_quotes_gpc() ) {
        $input = array(&$_GET, &$_POST, &$_COOKIE, &$_ENV, &$_SERVER);
        while ( list($k,$v) = each($input) ) {
            foreach ( $v as $key => $val ) {
                if ( !is_array($val) ) {
                    $input[$k][$key] = stripslashes($val);
                    continue;
                }
                $input[] =& $input[$k][$key];
            }
        }
        unset($input);
    }
}

?>