<?php

#require_once dirname(__FILE__) . '/product.php';

function ac_cache_dir($file = '') {
	if (isset($GLOBALS["customCachePath"])) {
		$base = $GLOBALS["customCachePath"] . "/cache";
	} else {
		$base = ac_base("cache");
	}

	if ($file)
		return $base . "/" . $file;
	else
		return $base;
}

function ac_cache_load($fname, $filter = null) {
	if ( $filter and !function_exists($filter) ) $filter = null;
	$data  = null;
	$cfile = ac_cache_dir($fname);
	if ( file_exists($cfile) ) $data = ac_file_get($cfile);
	if ( !$data ) return null;
	if ( $filter ) $data = $filter($data);
	return $data;
}

function ac_cache_save($fname, $data, $filter = null) {
	if ( $filter and !function_exists($filter) ) $filter = null;
	if ( $filter ) $data = $filter($data);
	$cfile = ac_cache_dir($fname);
	return ac_file_put($cfile, (string)$data);
}

?>
