<?php

require_once(ac_global_classes('context.php'));
require_once(ac_global_functions('sql.php'));

function ac_context_params(&$params) {
    $url = '';

    foreach ($params as $var => $val)
        $url .= "&".urlencode($var)."=".urlencode($val);

    return $url;
}

function ac_context_admin($action, $params = array()) {
    return ac_site_alink("main.php?action=".urlencode($action) . ac_context_params($params));
}

function ac_context_public($action, $params = array()) {
    return ac_site_plink("index.php?action=".urlencode($action) . ac_context_params($params));
}

function ac_context_ischecked($var) {
    if ($var == '')
        return 0;
    return 1;
}

function ac_context_process($smarty) {
    require_once ac_admin('functions/context.php');

    $proc = ContextFactory::GetContext($smarty);
    $proc->process($smarty);
}

function ac_context_switch(&$smarty, $where, $action, $whitelist = array()) {
	$action = basename($action);

	# What if it's . or ..?  Or a hidden filename?

	if ($action == "" || strpos($action, ".") !== false)
		/*$action = 'startup';*/return;

	if ( ( $where == "global" or count($whitelist) > 0 ) and !in_array($action, $whitelist) )
		return;

	# First check the program's context directory; then check ac_global.
	# Just in case we want to support context overloading.

	$path = "";

	switch ($where) {
		case "public":
			$path = ac_base("context");
			break;

		case "admin":
			$path = ac_admin("context");
			break;

		case "global":
			$path = ac_global("context");
			break;

		default:
			return;
	}

	$file  = "$path/$action.php";
	$class = strtolower($action) . "_context";

	if (is_file($file)) {
		require_once $file;

		if (class_exists($class)) {
			return new $class;
		}
	}

	return null;
}


function ac_context_find(&$smarty, $action, $admin = false) {
	// looking for which context to load up
	$where = ( $admin ? 'admin' : 'public' );

	/*
		APPLICATION CONTEXT SWITCHER
	*/
	$obj = ac_context_switch($smarty, $where, $action);
	if ( is_object($obj) and method_exists($obj, 'process') ) return $obj;

	/*
		AC GLOBAL CONTEXT SWITCHER
	*/
	$whitelistIndex = 'ac_context_whitelist';
	if ( $admin ) $whitelistIndex .= '_admin';
	$whitelist = ( isset($GLOBALS[$whitelistIndex]) ? $GLOBALS[$whitelistIndex] : array() );
	$obj = ac_context_switch($smarty, 'global', $action, $whitelist);
	if ( is_object($obj) and method_exists($obj, 'process') ) return $obj;

	/*
		STARTUP FALLBACK CONTEXT
	*/
	$obj = ac_context_switch($smarty, $where, 'startup');
	if ( is_object($obj) and method_exists($obj, 'process') ) return $obj;

	die('Context not found. System halted.');
}

?>
