<?php
// export.php

// Functions for exporting csv/xml/html/xls lists

function ac_export_headers($type, $fileName) {
	if ( $type == 'csv' ) {
		header("Content-type: text/plain; charset=" . _i18n("utf-8"));
		header("Content-Disposition: attachment; filename=$fileName.csv");
	} elseif ( $type == 'xls' ) {
		header("Content-type: application/vnd.ms-excel; charset=" . _i18n("utf-8"));
		header("Content-Disposition: attachment; filename=$fileName.xls");
	} elseif ( $type == 'xml' ) {
		header("Content-type: application/xml; charset=" . _i18n("utf-8"));
		header("Content-Disposition: attachment; filename=$fileName.xml");
	} elseif ( $type == 'html' ) {
		header("Content-type: text/html; charset=" . _i18n("utf-8"));
		header("Content-Disposition: attachment; filename=$fileName.html");
	} else {
		echo _a("Export mode not supported.");
		exit;
	}
	header("Pragma: no-cache");
	header("Expires: 0");
}

function ac_export_print($arr, $type, $wrapper = '', $delimiter = '') {
	if ( $type == 'xml' ) {
		ac_export_print_xml($arr, $wrapper, $delimiter);
	} elseif ( $type == 'csv' ) {
		ac_export_print_csv($arr, $wrapper, $delimiter);
	} else { // html,xls
		ac_export_print_html($arr, $wrapper, $delimiter);
	}
}

function ac_export_print_xml($arr, $wrapper = '', $delimiter = '') {
	require_once(ac_global_functions('ajax.php'));
	// print out headers
    ac_flush("<?xml version='1.0' encoding='" . _i18n("utf-8") . "'?>\n");
	// print out root node
	ac_flush("<export>\n");
	// now start printing data
	while ( $row = ac_sql_fetch_assoc($arr['rs']) ) {
		if ( ac_ihook_exists('ac_export_row') ) $row = ac_ihook('ac_export_row', $row, $arr);
		ac_flush(ac_xml_write_new($row, 'row') . "\n");
	}
	// close root node
	ac_flush("</export>\n");
}

function ac_export_print_html($arr, $wrapper = '', $delimiter = '') {
	// first print out fields (headers)
	ac_flush("<table>\n\t<tr>\n");
	foreach ( $arr['fields'] as $v ) {
		ac_flush("\t\t<th>" . ac_str_htmlspecialchars($v) . "</th>\n");
	}
	// finish fields row
	ac_flush("\t</tr>\n\n");
	// now start printing data
	while ( $row = ac_sql_fetch_assoc($arr['rs']) ) {
		if ( ac_ihook_exists('ac_export_row') ) $row = ac_ihook('ac_export_row', $row, $arr);
		// print every field
		ac_flush("\t</tr>\n\n");
		foreach ( $row as $v ) {
			ac_flush("\t\t<td>" . ac_str_htmlspecialchars($v) . "</td>\n");
		}
		// finish this row
		ac_flush("\t</tr>\n");
	}
	// finish the table
	ac_flush("</table>\n");
}

function ac_export_print_csv($arr, $wrapper = '', $delimiter = '') {
	// first print out fields (headers)
	$first = true;
	foreach ( $arr['fields'] as $v ) {
		if ( !$first ) ac_flush($delimiter);
		$first = false;
		ac_flush($wrapper . ac_str_escape_csv($v, $wrapper) . $wrapper);
	}
	// finish fields row
	ac_flush("\n");
	// now start printing data
	while ( $row = ac_sql_fetch_assoc($arr['rs']) ) {
		if ( ac_ihook_exists('ac_export_row') ) $row = ac_ihook('ac_export_row', $row, $arr);
		// print every field
		$first = true;
		foreach ( $row as $v ) {
			if ( !$first ) ac_flush($delimiter);
			$first = false;
			ac_flush($wrapper . ac_str_escape_csv($v, $wrapper) . $wrapper);
		}
		// finish this row
		ac_flush("\n");
	}
}

?>
