<?php

require_once ac_global_classes("select.php");

function ac_group_select_query(&$so, $ihookconditions = true, $opts = array()) {
	if (ac_ihook_exists("ac_group_select_query_condition") && $ihookconditions)
		$so->push(ac_ihook("ac_group_select_query_condition"));

	if (!$so->counting && ac_ihook_exists("ac_group_select_query_columns"))
		$so->slist = array_merge(array("*"), ac_ihook("ac_group_select_query_columns", $opts));

	return $so->query("
		SELECT
			*
		FROM
			#group g
		WHERE
			[...]
	");
}

function ac_group_select_row($id) {
	$id = intval($id);
	if ( !$id ) return false;
	$so = new AC_Select;
	$so->push("AND id = '$id'");

	$row = ac_sql_select_row(ac_group_select_query($so, false));

	if (ac_ihook_exists("ac_group_select_row"))
		$row = ac_ihook("ac_group_select_row", $row);

	return $row;
}

function ac_group_select_array_userpage($authid) {
	$authid = intval($authid);
	$ary    = ac_group_select_array();
	if ($authid > 0) {
		$mine   = ac_sql_select_list("
			SELECT
				groupid
			FROM
				#user_group
			WHERE
				userid = (
					SELECT
						subu.id
					FROM
						#user subu
					WHERE
						subu.absid = '$authid'
				)
		");
	} else {
		$mine = array();
	}

	foreach ($ary as $i => $group) {
		if (in_array($group["id"], $mine))
			$ary[$i]["_selected"] = 1;
		else
			$ary[$i]["_selected"] = 0;
	}

	return $ary;
}

function ac_group_select_array($so = null, $ids = null, $opts = array()) {
	if ($so === null || !is_object($so))
		$so = new AC_Select;

	$so->orders = array("title");

	if ($ids !== null) {
		if ( !is_array($ids) ) $ids = explode(',', $ids);
		$tmp = array_diff(array_map("intval", $ids), array(0));
		$ids = implode("','", $tmp);
		$so->push("AND id IN ('$ids')");
	}

	$rval = ac_sql_select_array(ac_group_select_query($so, true, $opts));

	if (ac_ihook_exists("ac_group_select_array"))
		$rval = ac_ihook("ac_group_select_array", $rval);

	return $rval;
}

function ac_group_select_box($so = null, $ids = null) {
	if ($so === null || !is_object($so))
		$so = new AC_Select;

	$so->orders = array("title");

	if ($ids !== null) {
		$tmp = array_map("intval", explode(",", $ids));
		$ids = implode("','", $tmp);
		$so->push("AND id IN ('$ids')");
	}

	$rs  = ac_sql_query(ac_group_select_query($so));
	$ary = array();

	while ($row = ac_sql_fetch_assoc($rs))
		$ary[$row["id"]] = $row;

	return $ary;
}

function ac_group_select_array_paginator($id, $sort, $offset, $filter) {
	$admin = ac_admin_get();
	$so = new AC_Select;

	$filter = intval($filter);
	if ($filter > 0) {
		$conds = ac_sql_select_one("SELECT conds FROM #section_filter WHERE id = '$filter' AND userid = '$admin[id]' AND sectionid = 'group'");
		$so->push($conds);
	}

	$so->count();
	$total = ac_sql_select_one(ac_group_select_query($so, true, array("paginator")));

	switch ($sort) {
		default:
		case "01":
			$so->orderby("title"); break;
		case "01D":
			$so->orderby("title DESC"); break;
		case "02":
			$so->orderby("descript"); break;
		case "02D":
			$so->orderby("descript DESC"); break;
	}

	$offset = (int)$offset;
	$so->limit("$offset, 20");
	$rows = ac_group_select_array($so, null, array("paginator"));

	return array(
		"paginator"   => $id,
		"offset"      => $offset,
		"total"       => $total,
		"cnt"         => count($rows),
		"rows"        => $rows,
	);
}

function ac_group_relate_user($userid, $groups) {
	$userid = intval($userid);
	ac_sql_query("DELETE FROM #user_group WHERE userid = '$userid'");

	foreach ($groups as $groupid) {
		$groupid = intval($groupid);
		ac_sql_query("INSERT INTO `#user_group` (userid, groupid) VALUES ('$userid', '$groupid')");
	}
}

function ac_group_canaccess($userid, $groups) {
	# Start out as true.  We may change this if there is a more global reason for you not
	# to have access to a group; for now, it's all app-specific.
	$rval = true;

	if (ac_ihook_exists("ac_group_canaccess"))
		$rval = $rval && ac_ihook("ac_group_canaccess", $userid, $groups);

	return $rval;
}

function ac_group_filter_post() {
	$whitelist = array("title", "descript");

	$ary = array(
		"userid" => $GLOBALS['admin']['id'],
		"sectionid" => "group",
		"conds" => "",
		"=tstamp" => "NOW()",
	);

	if (isset($_POST["qsearch"]) && !isset($_POST["content"])) {
		$_POST["content"] = $_POST["qsearch"];
	}

	if (isset($_POST["content"]) and $_POST['content'] != '') {
		$content = ac_sql_escape($_POST["content"], true);
		$conds = array();

		if (!isset($_POST["section"]) || !is_array($_POST["section"]))
			$_POST["section"] = $whitelist;

		foreach ($_POST["section"] as $sect) {
			if (!in_array($sect, $whitelist))
				continue;
			$conds[] = "$sect LIKE '%$content%'";
		}

		$conds = implode(" OR ", $conds);
		$ary["conds"] = "AND ($conds) ";
	}

	$conds_esc = ac_sql_escape($ary['conds']);
	$filterid = ac_sql_select_one("
		SELECT
			id
		FROM
			#section_filter
		WHERE
			userid = '$ary[userid]'
		AND
			sectionid = 'group'
		AND
			conds = '$conds_esc'
	");

	if (intval($filterid) > 0)
		return array("filterid" => $filterid);
	ac_sql_insert("#section_filter", $ary);
	return array("filterid" => ac_sql_insert_id());
}

function ac_group_permission($key) {
	$rval = ac_ihook("ac_group_permission", $key);

	if ($rval === $key)
		return false;
	else
		return $rval;
}

function ac_group_insert_post() {
	if (!ac_group_permission("add"))
		return ac_ajax_api_nopermission(_a("add groups"));

	$ary = array(
		"title" => $_POST["title"],
		"descript" => $_POST["descript"],
	);

	$ary = ac_ihook("ac_group_insert_post", $ary);

	$done = ac_sql_insert("#group", $ary);
	if ( !$done ) {
		return ac_ajax_api_result(false, _a("Group could not be added."), array("group_id" => 0));
	}

	$group_id = ac_sql_insert_id();

	$r = ac_ihook("ac_group_relations", $group_id);
	if ( !$r ) {
		return ac_ajax_api_added(_a("Group"), array("group_id" => $group_id));
	} else {
		return $r;
	}
}

function ac_group_update_post() {
	if (!ac_group_permission("edit"))
		return ac_ajax_api_nopermission(_a("edit groups"));

	$ary = array(
		"title" => $_POST["title"],
		"descript" => $_POST["descript"],
	);

	$ary = ac_ihook("ac_group_insert_post", $ary);

	$id = intval($_POST["id"]);
	ac_sql_update("#group", $ary, "id = '$id'");

	$r = ac_ihook("ac_group_relations", $id);
	ac_session_drop_cache();
	unset($GLOBALS["admin"]);
	$GLOBALS["admin"] = ac_admin_get();
	if ( !$r ) {
		return ac_ajax_api_updated(_a("Group"));
	} else {
		return $r;
	}
}

function ac_group_delete($id, $alt) {
	if (!ac_group_permission("delete"))
		return ac_ajax_api_nopermission(_a("delete groups"));

	$id  = intval($id);
	$alt = intval($alt);

	if ($id < 4)
		return ac_ajax_api_nopermission(_a("delete groups"));

	ac_group_delete_relational($id, $alt);
	ac_sql_query("DELETE FROM #group WHERE id = '$id'");
	return ac_ajax_api_deleted(_a("Group"));
}

function ac_group_delete_relational($id, $alt) {
	if ($alt == 0) {
		$group = ac_group_select_row($id);
		$users = ac_sql_select_array("SELECT * FROM #user_group GROUP BY userid HAVING COUNT(userid) < 2");
		$list = array();

		if ( isset($group["p_admin"]) and $group["p_admin"] == 1 )
			$alt = 3;	# Admin group
		else
			$alt = 2;	# User group

		foreach ($users as $user) {
			if ($user["groupid"] == $id)
				$list[] = $user["userid"];
		}

		$list_str = implode("','", $list);

		ac_sql_query("UPDATE #user_group SET groupid = '$alt' WHERE userid IN ('$list_str') AND groupid = '$id'");
		ac_sql_query("DELETE FROM #user_group WHERE groupid = '$id'");
	} else {
		ac_sql_query("UPDATE #user_group SET groupid = '$alt' WHERE groupid = '$id'");
	}

	ac_ihook("ac_group_delete_relational_post", $id, $alt);
}

function ac_group_delete_multi($ids, $alt) {
	if (!ac_group_permission("delete"))
		return ac_ajax_api_nopermission(_a("delete groups"));

	$tmp = array_map("intval", explode(",", $ids));

	$in  = array_search(1, $tmp);
	if ($in !== false)
		unset($tmp[$in]);
	$in  = array_search(2, $tmp);
	if ($in !== false)
		unset($tmp[$in]);
	$in  = array_search(3, $tmp);
	if ($in !== false)
		unset($tmp[$in]);

	foreach ($tmp as $id)
		ac_group_delete_relational($id, $alt);

	$ids = implode("','", $tmp);
	ac_sql_query("DELETE FROM #group WHERE id IN ('$ids')");
	return ac_ajax_api_deleted(_a("Groups"));
}

?>
