<?php

// can't call hookcalls.php here because SESSION will just get overwritten when session_start() is called later
//require_once(ac_admin('functions/hookcalls.php'));

require_once(ac_global('functions/sql.php'));
require_once(ac_global('functions/xml.php'));

// Execute PHP code in a set of hooks marked with $call, in order of
// their priority from highest to lowest.  Calls with identical
// priorities will execute in an undefined order.

function ac_hook($call) {
    $res = ac_sql_query("
        SELECT
            h.`code`,
            g.`status`
        FROM
            `#hooks` h,
            `#hooks_groups` g
        WHERE
            h.`call` = '".$call."'
        AND g.`id` = h.`groupid`
        ORDER BY h.`priority` DESC
    ");

    while ($row = ac_sql_fetch_assoc($res)) {
        if ($row['status'] == 'enabled')
            eval(stripslashes($row['code']));
    }
}

function ac_hook_conf($groupid, $key) {
    if (!isset($_SESSION['_ac_hooks']) || !isset($_SESSION['_ac_hooks'][$groupid]) || !isset($_SESSION['_ac_hooks'][$groupid]['key:'.$key])) {
        if (!ac_hook_enabled($groupid))
            return null;

        $res = ac_sql_query("
            SELECT
                `key`,
                `value`
            FROM
                `#hooks_config`
            WHERE
                `groupid` = ".(int)$groupid
        );

        while ($row = ac_sql_fetch_assoc($res))
            $_SESSION['_ac_hooks'][$groupid]['key:'.$row['key']] = $row['value'];
    }

    return $_SESSION['_ac_hooks'][$groupid]['key:'.$key];
}

function ac_hook_conf_sys($key) {
    return ac_hook_conf(0, $key);
}

function ac_hook_group($groupid) {
    return ac_sql_select_array("
        SELECT
            *
        FROM
            `#hooks_groups`
        WHERE
            `id` = ".(int)$groupid."
        AND `status` = 'enabled'
    ");
}

function ac_hook_group_enabled($groupid) {
    return ac_sql_select_one("status", "#hooks_groups", "`id` = ".intval($groupid)) == 'enabled';
}

function ac_hook_sys_enabled() {
    return ac_hook_conf_sys("status") == "enabled";
}

function ac_hook_locations() {
    require_once(ac_admin('functions/hookcalls.php'));
    return $_SESSION['_ac_hook_calls'];
}

function ac_hook_groups() {
    $ret = array("0" => "---");
    $ary = ac_sql_select_array("
        SELECT
            `id`,
            `name`
        FROM
            `#hooks_groups`
    ");

    foreach ($ary as $row)
        $ret[$row['id']] = $row['name'];

    return $ret;
}

function ac_hook_group_hooks($groupid) {
    return ac_sql_select_list("SELECT id FROM `#hooks` WHERE `groupid` = ".(int)$groupid);
}

function ac_hook_export($hookid) {
    $ary = ac_sql_select_row("
        SELECT
            *
        FROM
            `#hooks`
        WHERE
            `id` = ".(int)$hookid
    );

    unset($ary['id']);
    $ary['code'] = base64_encode(stripslashes($ary['code']));

    return ac_xml_write($ary, "", "hook");
}

function ac_hook_import(&$ary) {
    if (!isset($ary['hook']))
        return false;

    $hook = $ary['hook'];
    if (!isset($hook['groupid'])
        || !isset($hook['description'])
        || !isset($hook['priority'])
        || !isset($hook['status'])
        || !isset($hook['code'])
        || !isset($hook['call']))
            return false;

    $hook['groupid'] = (int)$hook['groupid'];
    $hook['priority'] = (int)$hook['priority'];
    $hook['code'] = base64_decode($hook['code']);

    ac_sql_insert("#hooks", $hook);
}

function ac_hook_import_dep(&$ary) {
    if (!isset($ary['dep']))
        return false;

    $dep = $ary['dep'];

    if (!isset($dep['groupid'])
        || !isset($dep['deptype'])
        || !isset($dep['from'])
        || !isset($dep['to']))
            return false;

    $dep['groupid'] = (int)$dep['groupid'];

    ac_sql_insert("#hooks_deps", $dep);
}

function ac_hook_export_plugin($groupid) {
    $groupid = (int)$groupid;
    $grp   = ac_sql_select_row("SELECT * FROM `#hooks_groups` WHERE `id` = ".$groupid);
    $deps  = ac_sql_select_array("SELECT * FROM `#hooks_deps` WHERE `groupid` = ".$groupid);
    $hooks = ac_sql_select_array("SELECT * FROM `#hooks` WHERE `groupid` = ".$groupid);

    $grp['install_pre'] = base64_encode(stripslashes($grp['install_pre']));
    $grp['install_post'] = base64_encode(stripslashes($grp['install_post']));
    for ($i = 0; $i < count($deps); $i++) {
        unset($deps[$i]['id']);
        $grp["dep-".$i] = $deps[$i];
    }

    for ($i = 0; $i < count($hooks); $i++) {
        unset($hooks[$i]['id']);
        $hooks[$i]['code'] = base64_encode(stripslashes($hooks[$i]['code']));
        $grp["hook-".$i] = $hooks[$i];
    }

    return ac_xml_write($grp,"","plugin");
}

function ac_hook_install_plugin($xml) {
    global $smarty;
    $top = ac_xml_read($xml);

    if (!is_array($top))
        return false;

    if (isset($top["plugin"])) {
        $ary = $top["plugin"];
        $grp = array(
            "name"         => $ary["name"],
            "version"      => $ary["version"],
            "description"  => $ary["description"],
            "status"       => $ary["status"],
            "=ctime"       => "NOW()",
            "install_pre"  => base64_decode($ary["install_pre"]),
            "install_post" => base64_decode($ary["install_post"]),
        );

        ac_sql_insert("#hooks_groups", $grp);
        $group_id = ac_sql_insert_id();
        for ($i = 0;; $i++) {
            $key = "hook-" . $i;

            if (!isset($ary[$key]))
                break;

            $ary[$key]['groupid'] = $group_id;
            $hook = array("hook" => $ary[$key]);
            ac_hook_import($hook);
        }

        eval($grp["install_pre"]);
        return true;
    } else {
        return false;
    }
}

function ac_hook_uninstall_plugin($groupid) {
    $groupid = (int)$groupid;
    $ary = ac_sql_select_row("SELECT * FROM `#hooks_groups` WHERE `id` = ".$groupid);

    if (!$ary)
        return;

    eval($ary["install_post"]);

    ac_sql_delete("#hooks", "`groupid` = ".$groupid);
    ac_sql_delete("#hooks_deps", "`groupid` = ".$groupid);
    ac_sql_delete("#hooks_config", "`groupid` = ".$groupid);
    ac_sql_delete("#hooks_groups", "`id` = ".$groupid);
}


function ac_hook_context(&$smarty, $mode) {
    if (!is_array($smarty->template_dir))
        $smarty->template_dir = array($smarty->template_dir, $smarty->_globalPath . '/templates');
    $smarty->assign('pageTitle', _a("Plugins"));

    if ($mode == "")
        $mode = "view";

    switch ($mode) {
            // plugins
        case 'view':
            require(ac_global('context/plugins_view_context.php'));
            return new Plugins_View_Context();
        case 'add':
        case 'edit':
            require(ac_global('context/plugins_edit_context.php'));
            return new Plugins_Edit_Context();
        case 'delete':
            if (isset($_GET["id"])) {
                $gid = intval($_GET["id"]);
				ac_hook_uninstall_plugin($gid);
                $hookids = ac_hook_group_hooks($gid);
                ac_sql_delete("#hooks", "IN ('".implode($hookids)."')");
                ac_sql_delete("#hooks_groups", "`id` = ".$gid);
                ac_smarty_message($smarty, "The plugin has been successfully deleted.");
            }
            return ac_hook_context($smarty, "view");
        case 'import':
            $xml = file_get_contents($_FILES['file']['tmp_name']);
            $result = ac_hook_install_plugin($xml);
            ac_smarty_message($smarty, ($result ? "Your plugin was successfully installed." : "Could not import file because important data was missing."));
            return ac_hook_context($smarty, "view");
        case 'export':
            require(ac_global('context/plugins_export_context.php'));
            return new Plugins_Export_Context();
            // dependancies
        case 'deldep':
        case 'adddep':
        case 'editdep':
            require(ac_global('context/deps_edit_context.php'));
            return new Deps_Edit_Context();
            // hooks
        case 'importhook':
            $xml = file_get_contents($_FILES['file']['tmp_name']);
            $ary = ac_xml_read($xml);
            ac_hook_import($ary);
            return ac_hook_context($smarty, "viewhooks");
        case 'exporthook':
            require(ac_global('context/hooks_export_context.php'));
            return new Hooks_Export_Context();
        case 'addhook':
        case 'edithook':
            require(ac_global('context/hooks_edit_context.php'));
            return new Hooks_Edit_Context();
        case 'delhook':
            if (isset($_GET["id"])) {
                ac_sql_delete("#hooks", "`id` = ".(int)$_GET["id"]);
                ac_smarty_message($smarty, "Your hook has been successfully deleted.");
            }
            return ac_hook_context($smarty, "viewhooks");
        case 'viewhooks':
        default:
            require(ac_global('context/hooks_view_context.php'));
            return new Hooks_View_Context();
    }
}

?>
