<?php

$GLOBALS['ac_ihook_table'] = array();

function ac_ihook_define($key, $func) {
    global $ac_ihook_table;

    if (!ac_ihook_exists($key)) {
        $ac_ihook_table[$key] = array();
    }

    array_push($ac_ihook_table[$key], $func);
}

function ac_ihook_undefine($key, $func) {
    global $ac_ihook_table;

    if (ac_ihook_exists($key)) {
        $index = array_search($func, $ac_ihook_table[$key]);

        if ($index != FALSE) {
            $ac_ihook_table[$key] =
                array_splice($ac_ihook_table[$key], $index, 1);
        }
    }
}

function ac_ihook_exists($key) {
    return array_key_exists($key, $GLOBALS['ac_ihook_table']);
}

function ac_ihook($key) {
    global $ac_ihook_table;

    $ret = null;

    if (ac_ihook_exists($key)) {
        foreach ($ac_ihook_table[$key] as $func) {
            $args = func_get_args();
            array_splice($args, 0, 1);
            $ret  = call_user_func_array($func, $args);
        }
	} else {
		# If there is no function, return the first parameter.
		$args = func_get_args();
		array_splice($args, 0, 1);
		if (count($args) > 0)
			return $args[0];
	}

    return $ret;
}

?>
