<?php

require_once dirname(__FILE__) . "/cache.php";

// not used anymore
function ac_import_src($running = false) {
	// gather input
	$admin = ac_admin_get();
	$uid = ( $admin['id'] == 0 ? 1 : $admin['id'] );
	$relid = ac_http_param('relid');
	if ( is_array($relid) ) {
		$relid = array_diff(array_map('intval', $relid), array(0)); // don't allow zeros
		//$relid = array_map('intval', $relid); // allow zeros
	} else {
		$relid = (int)ac_http_param('relid');
	}
	$destination = (int)ac_http_param('destination');
	$type = (string)ac_http_param('type');
	$delimiter = (string)ac_http_param('delimiter_file');
	$text = (string)ac_http_param('import_text');
	$file = ac_http_param('import_file');
	// define result
	$r = array(
		'relid' => $relid,
		'valid' => false,
		'succeeded' => false,
		'message' => '',
		'filename' => '',
		'rows' => 0,
		'fields' => array(),
		'standardfields' => ac_ihook('ac_import_fields', $relid, $destination),
		'customfields' => ac_ihook('ac_import_custom_fields', $relid, $destination),
		'delimiter_file' => $delimiter,
	);
	/*
	if ( !ac_admin_isadmin() ) {
		$r['message'] = _a('Only admin users can import files.');
		return $r;
	}
	*/
	if ( !$r['customfields'] ) $r['customfields'] = array();
	// if input type is textarea, save the file for future use
	$path = ac_cache_dir() . "/";
	if ( $type == 'text' ) {
		if ( trim($text) == '' ) {
			$r['message'] = _a('You did not enter any data into a text box. Please add data first...');
			return $r;
		}
		$r['delimiter_file'] = $delimiter = (string)ac_http_param("delimiter_text");
		$filename = 'csvimport-' . $uid . '-tmpfile.csv';
		unset($_POST["import_text"]);
		$_POST["import_file"] = array($filename);
		$_POST["type"] = "file";
		$file = array($filename);
		$text = ac_utf_conv("utf-8", _i18n("utf-8"), $text);
		if ( !@file_put_contents($path . $filename, $text) ) {
			$r['message'] = _a('Could not save the content to import.');
			return $r;
		}
	// if input type is file, check if file(s) uploaded properly
	}
	$uploaded = false;
	if ( !is_array($file) ) $file = array();
	foreach ( $file as $filename ) {
		if ( file_exists($path . $filename) ) {
			$text = @file_get_contents($path . $filename);
			if ( $text ) {
				$text = ac_utf_conv(_i18n("utf-8"), "UTF-8", $text);
				$uploaded = true;
				break; // only one file at the time in importer
			}
		}
	}
	if ( !$uploaded ) {
		$r['message'] = _a('You did not upload a file to import. Please do that first...');
		return $r;
	}
	$r['filename'] = $filename;
	// do stuff with $text (data) string variable
	// get array from CSV file
	$csv = ac_import_csv2array($text, $delimiter);
	unset($text);
	// get fields
	$r['fields'] = ac_import_columns($csv);
	// save CSV data if running
	$r['rows'] = count($csv);
	if ( $running ) $r['data'] = $csv;
	if ( count($r['fields']) == 0 ) {
		$r['message'] = _a('This is either not a CSV file, or no columns could be matched. Please try using different settings.');
		return $r;
	}
	// count required fields
	$required = 0;
	foreach ( $r['standardfields'] as $row ) {
		if ( $row['req'] ) $required++;
	}
	foreach ( $r['customfields'] as $row ) {
		if ( $row['req'] ) $required++;
	}
	if ( count($r['fields']) < $required ) {
		$r['message'] = sprintf(_a('This CSV file does not have enough columns to complete the import. It needs to have at least %d columns.'), $required);
		return $r;
	}
	$r['valid'] = true;
	if ( ac_ihook_exists('ac_import_valid_check') ) {
		$r['valid'] = (bool)ac_ihook('ac_import_valid_check', $r);
	}
	$r['succeeded'] = true;
	$r['message'] = _a('CSV content successfully parsed.');
	return $r;
}

function ac_import_delimiter_guess($data) {
	$lines = explode("\n", str_replace("\r", "\n", str_replace("\r\n", "\n", $data)));

	# Nothing here?
	if (count($lines) == 0)
		return "comma";

	$line = $lines[0];

	# Get rid of any escapes -- we don't want to deal with them.
	$line = preg_replace('/\\./', '', $line);

	# We're mainly checking for commas, semicolons, and tabs.  Check
	# in order, starting with any combinations which have quote characters
	# surrounding field values.

	if (preg_match('/"\s*,\s*"/', $line))
		return "comma";
	if (preg_match('/\'\s*,\s*\'/', $line))
		return "comma";
	#--
	if (preg_match('/"\s*;\s*"/', $line))
		return "semicolon";
	if (preg_match('/\'\s*;\s*\'/', $line))
		return "semicolon";
	#--
	if (preg_match('/"[ ]*\t[ ]*"/', $line))
		return "tab";
	if (preg_match('/\'[ ]*\t[ ]*\'/', $line))
		return "tab";

	# If we get here, that means we don't seem to be using quotes surrounding
	# field values.  The matches here are a bit less precise.

	if (preg_match('/.,./', $line))
		return "comma";
	if (preg_match('/.;./', $line))
		return "semicolon";
	if (preg_match('/\S\t\S/', $line))
		return "tab";

	# Weird.  We're not sure.  Better go with comma.
	return "comma";
}

function ac_import_delimiter($delimiter) {
	switch ( $delimiter ) {
		case 'comma':
			$delimiter = ',';
			break;
		case 'semicolon':
			$delimiter = ';';
			break;
		case 'tab':
			$delimiter = "\t";
			break;
		//case 'pipe':
			//$delimiter = '\|';
			//break;
		default:
			$delimiter = ',';
	}
	return $delimiter;
}

function ac_import_csv2array(&$data, $delimiter) {
	$delimiter = ac_import_delimiter($delimiter);
	ob_implicit_flush(true);
	$arr = array();
//dbg(memory_get_usage(), 1);
	//$lines = preg_split("/\r\n|\r|\n/", $data);
	$lines = explode("\n", str_replace("\r", "\n", str_replace("\r\n", "\n", $data)));
//dbg(memory_get_usage(), 1);
	$data = null;
	//unset($data);
//dbg(memory_get_usage(), 1);
	foreach ( $lines as $line ) {
		//$line = trim($line);
		$line = trim($line);
		if ( $line != '' ) {
			//$arr[] = ac_import_csvline2array(trim($line), $delimiter);
			$arr[] =
				preg_replace(
					"/^\"(.*)\"$/",
					"$1",
					preg_replace(
						"/\"\"/",
						"",
						preg_split("/$delimiter(?=(?:[^\"]*\"[^\"]*\")*(?![^\"]*\"))/", $line)
					)
				)
			;
			//$arr[] = ac_import_csvline2array(trim($line), $delimiter);
		}
		unset($line);
	} // end while
//dbg(memory_get_usage(), 1);
	unset($lines);
//dbg(memory_get_usage(), 1);
	//dbg($arr);
	return $arr;
}

function ac_import_csvline2array($string, $delimiter = ',') {
	$expr = "/$delimiter(?=(?:[^\"]*\"[^\"]*\")*(?![^\"]*\"))/";
	$results = preg_split($expr, $string);
	unset($string);
	$results = preg_replace("/\"\"/", "\"", $results);
	return preg_replace("/^\"(.*)\"$/", "$1", $results);



	return
		preg_replace(
			"/^\"(.*)\"$/",
			"$1",
			preg_replace(
				"/\"\"/",
				"\"",
				preg_split("/$delimiter(?=(?:[^\"]*\"[^\"]*\")*(?![^\"]*\"))/", $string)
			)
		)
	;
}


function ac_import_columns($fields) {
	$columns = array();
	//dbg($fields);
	$emailFound = false;
	$dateFound = false;
	$fnFound = false;
	$lnFound = false;
	if ( isset($fields[0]) && is_array($fields[0]) ) {
		foreach ( $fields[0] as $k => $field ) {
			$default = '';
			if ( !$emailFound ) {
				if ( ac_str_is_email($field) or ac_str_instr('mail', strtolower($field)) ) {
					$default = 'email';
					$emailFound = true;
				}
			}
			if ( !$dateFound ) {
				if (
					preg_match('/^\d{10}$/', $field) or
					preg_match('/^\d+-\d+-\d+$/', $field) or
					preg_match('/^\d+-\d+-\d+ \d+:\d+:\d+$/', $field) or
					ac_str_instr('create', strtolower($field)) or
					ac_str_instr('date', strtolower($field)) or
					ac_str_instr('tstamp', strtolower($field))
				) {
					$default = 'date';
					$dateFound = true;
				}
			}
			if ( !$fnFound ) {
				if (
					ac_str_instr('first', strtolower($field)) ||
					"name" == strtolower($field)
				) {
					$default = 'firstname';
					$fnFound = true;
				}
			}
			if ( !$lnFound ) {
				if (
					ac_str_instr('last', strtolower($field))
				) {
					$default = 'lastname';
					$lnFound = true;
				}
			}
			$columns[] = array(
				'id' => $k,
				'name' => $field,
				'type' => ( is_numeric($field) ? 'numeric' : 'text' ),
				'default' => $default,
			);
		}
	}
	return $columns;
}

function ac_import_csv_parse($data, $delimiter) {
	// get array from CSV file
	$csv = ac_import_csv2array($data, $delimiter);
	// get fields
	return /*$fields =*/ ac_import_columns($csv);
}



function ac_import_mapping_get($dest = array()) {
	$r = array();
	//$dest = ac_http_param('dest');
	if ( !is_array($dest) ) return $r;
	foreach ( $dest as $k => $v ) {
		if ( $v != 'DNI' ) {
			$r[$v] = $k;
		}
	}
	return $r;
}

function ac_import_mapping_check($post, $r) {
	return true; // ?!?!
}




// not used anymore
function ac_import_file_remove($id) {
	$r = array(
		'succeeded' => false,
		'message' => '',
		'id' => $id
	);
	$r['succeeded'] = ac_file_upload_remove(ac_cache_dir(), '', $id);
	if ( $r['succeeded'] ) {
		$r['message'] = sprintf(_a("File '%s' removed."), substr($id, strlen('csvimport-')));
	} else {
		$r['message'] = sprintf(_a("File '%s' could not be removed."), substr($id, strlen('csvimport-')));
	}
	return $r;
}



function ac_import_log_init($import) {
	if ( !defined('AC_SYNC_DEBUG') or !AC_SYNC_DEBUG ) return;
	if ( !isset($import['id']) ) $import['id'] = 0;
	$GLOBALS['_synclog'] = @fopen(ac_cache_dir('importlog-' . $import['id']), 'a');
	return;
}

function ac_import_log_store($msg, $deep = true) {
	if ( !defined('AC_SYNC_DEBUG') or !AC_SYNC_DEBUG ) return;
	if ( !isset($GLOBALS['_synclog']) or !$GLOBALS['_synclog'] ) return;
	// try to add datetimestamps
	$stamp = date('Y-m-d H:i:s');
	// do microtime processing
	$now = ac_microtime_get();
	if ( !isset($GLOBALS['_ac_import_timer']) ) {
		// first instance, set zero
		$time = 'starting';
	} else {
		// subtract from previous stamp, 6 decimal roundup
		$time = round($now - $GLOBALS['_ac_import_timer'], 6);
	}
	// set this stamp as last
	$GLOBALS['_ac_import_timer'] = $now;
	// add digits to form 8char string
	if ( strlen("$time") < 8 ) $time .= str_repeat(0, 8 - strlen($time));
	//if ( ac_str_instr('E-', "$time") ) $time = 'tooshort';//$time = '0.000000';
	// add it to msg
	if ( $deep ) $msg = "[[$stamp $time]] $msg";
	@fwrite($GLOBALS['_synclog'], $msg . "\n");
}

function ac_import_log_comment($comment = '') {
	if ( !ac_str_instr('<script>', $comment) and !ac_str_instr('parent.', $comment) and $comment != '</table>' ) {
		ac_import_log_store($comment/*, false*/);
	}
	if ( !( defined('AC_IMPORT_PRINT') and AC_IMPORT_PRINT ) ) return;
	ac_flush($comment . "\n<br />\n\n");
}

function ac_import_log_row($post, $row, $result) {
	if ( defined('AC_IMPORT_LOGTABLE') and AC_IMPORT_LOGTABLE ) {
		// save him into *_import(_log) table
		$insert = array(
			'id' => 0,
			'processid' => $post['process_id'],
			'email' => ( isset($row[$post['fieldslist']['email']]) ? trim($row[$post['fieldslist']['email']]) : '' ),
			'res' => (int)$result['succeeded'],
			'code' => $result['code'],
			'msg' => $result['message'],
			'=tstamp' => 'NOW()',
		);
		ac_sql_insert(AC_IMPORT_LOGTABLE, $insert);
	}
	if ( !( defined('AC_IMPORT_PRINT') and AC_IMPORT_PRINT ) ) return;
	if ( !defined('AC_IMPORT_PRINT_HEADER') ) {
		define('AC_IMPORT_PRINT_HEADER', 1);
		echo '<table width="100%" class="font_10">';
		echo '<tr>';
		echo '<th>' . _a('Imported') . '</th>';
		foreach ( $row as $k => $v ) {
			// figure out if this one is mapped
			$props = '';
			if ( false !== ( $key = array_search($k, $post['fieldslist']) ) ) {
				$alt = sprintf(_a('Mapped into field: %s'), $key);
				$props = ' alt="' . $alt . '" title="' . $alt . '" class="ac_mapped_column"';
			}
			echo '<th' . $props . '>' . $k . '</th>';
		}
		echo '</tr>';
	}
	if ( !isset($GLOBALS['importrowid']) ) $GLOBALS['importrowid'] = 0;
	$GLOBALS['importrowid']++;
	$rowid = $GLOBALS['importrowid'];
	//$prefix = ( ac_site_is12all5() ? '../../' : '' );
	echo "<tr>\n";
	echo '<td>';
	echo
		'<img src="../ac_global/media/circle_' .
		( $result['succeeded'] ? 'green' : 'grey' ) .
		'.gif" onmouseout="ac_dom_toggle_display(\'importresult' . $rowid .
		'\', \'inline\')" onmouseover="ac_dom_toggle_display(\'importresult' . $rowid . '\', \'inline\')" />'
	;
	echo '<div id="importresult' . $rowid . '" class="ac_help" style="display: none;">' . $result['message'] . '</div>';
	echo '</td>';
	foreach ( $row as $k => $v ) {
		// figure out if this one is mapped
		$props = '';
		if ( false !== ( $key = array_search($k, $post['fieldslist']) ) ) {
			$alt = sprintf(_a('Mapped into field: %s'), $key);
			$props = ' alt="' . $alt . '" title="' . $alt . '" class="ac_mapped_column"';
		}
		echo '<td' . $props . '>' . ac_str_shorten(trim(strip_tags($v)), 30) . '</td>';
	}
	echo "\n</tr>\n\n";
	//echo '</table>';
	flush();
}



function ac_import_run($post, $test = false, $offset = 0, $prepareOnly = false) {
	# import_src will use $_POST for this, so we can get rid of this now.
	unset($post["import_text"]);

	ac_import_log_init($post);
	if ( isset($post['process_id']) ) {
		ac_import_log_store("\nPicking up Import Job (process #$post[process_id]) at $offset\n");
	} else {
		$date = date('Y-m-d H:i:s');
		ac_import_log_store("\nStarting Import Job at $date\n");
	}
	// set output to true
	if ( !defined('AC_IMPORT_PRINT') ) define('AC_IMPORT_PRINT', 1);
	// print javascript
	$charset = _i18n("utf-8");
	$prehtml = "<meta http-equiv='Content-Type' content='text/html; charset=$charset' />\n";
	$prehtml .= '
		<script>
			function ac_dom_toggle_display(id, val) {
				document.getElementById(id).style.display = ( document.getElementById(id).style.display == val ? "none" : val );
			}
		</script>
		<style>
		div.ac_help {
			z-index: 999;
			/*display: none;*/
			position:absolute;
			border: 1px solid #B4CDE6;
			padding: 10px;
			width:200px;
			margin-top:6px;
			font-size:10px;
			background:#F0F6FB;
			color:#333333;
		}
		.ac_mapped_column {
			background-color: #ccc;
		}
		</style>
		<link href="css/default.css" rel="stylesheet" type="text/css" />

	';
	ac_import_log_comment($prehtml);
	ac_flush($prehtml);
	if ( $test ) {
		//ac_import_log_comment(_a('Testing Import'));
	} else {
		//ac_import_log_comment(_a('Starting Import'));
	}

	$r = ac_import_src(true);
	// if didn't even connect, return
	if ( !$r['succeeded'] ) return $r;

	if (isset($_POST["import_file"])) {
		$post["import_file"] = $_POST["import_file"];
		$post["type"]        = $_POST["type"];
	}

	// default values
	$r['succeeded'] = false;
	$r['failed'] = 0;
	$r['found'] = count($r['data']);
	$r['imported'] = 0;
	$r['failedrows'] = array();
	$r['importedrows'] = array();

	$useProcesses = function_exists('ac_process_create');
	// this process id
	if ( !isset($post['process_id']) ) {
		if ( $useProcesses ) {
			// comming from form submission, has action param here
			if (isset($r['delimiter_file']))
				$post['delimiter_file'] = $r['delimiter_file'];
			$post['process_id'] = ac_process_create(ac_http_param('action'), $r['found'], $post, false, '0000-00-00 00:00:00');
			ac_process_setdata($post['process_id'], $post);
			/*
			if ( !$test and $prepareOnly ) {
				ac_process_spawn(array('id' => $post['process_id'], 'stall' => 5 * 60));
			}
			*/
		} else {
			// old style - KB3
			$post['process_id'] = rand('100000', '900000');// setting a random process id
		}
	}
	$r['process_id'] = $post['process_id'];

	if ( $useProcesses ) {
		// autoupdate
		//$admin = ac_admin_get();
		//$secondInterval = ( isset($admin['autoupdate']) ? $admin['autoupdate'] : 60 );
		$secondInterval = 10;

		$callback = ( !$test and $prepareOnly ) ? "parent.import_progressbar_callback" : "null";
		ac_import_log_comment(
			'
				<script>//alert(\'process: ' . $r['process_id'] . '\');
					if (parent && parent.ac_progressbar_register && parent.document.getElementById("progressBar")){
						parent.ac_progressbar_register("progressBar", "' . $r['process_id'] . '", 0, ' . $secondInterval . ', true, ' . $callback . ');
						parent.processID = "' . $r['process_id'] . '";
					}
				</script>
			'
		);
	}

	if ( !$test and $prepareOnly ) {
		if ( $useProcesses ) ac_process_spawn(array('id' => $post['process_id'], 'stall' => 5 * 60));
		$r['succeeded'] = true;
		return $r;
	}

	// options
	$post['delete_all'] = (int)isset($post['sync_option_delete_all']);

	if ( !isset($post['dest']) ) {
		$r['message'] = _a('Fields not mapped properly. Aborting...');
		return $r;
	}
	$post['fieldslist'] = ac_import_mapping_get($post['dest']);

	// 2do: check against required fields again

	if ( isset($GLOBALS['_ac_sync_lists']) ) unset($GLOBALS['_ac_sync_lists']);

	ac_import_log_comment(sprintf(_a('Found %d results.  Starting import now...'), $r['found']));
	$i = 0;
	foreach ( $r['data'] as $row ) {
		$i++;
		if ( $i > $offset ) {
			$rs = ac_import_row($post, $row, $test);
			if ( $useProcesses ) ac_process_update($post['process_id']);
			if ( $rs['succeeded'] ) {
				$r['importedrows'][] = $row;
			} else {
				$r['failedrows'][] = $row;
			}
			$r['imported'] += $rs['succeeded'];
			ac_import_log_row($post, ac_utf_deepconv("UTF-8", _i18n("utf-8"), $row), $rs);
		}
	}

	if ($r['imported'] == 0) {
		# Mark this as if it were completed; something is probably wrong here (e.g., import file
		# is missing, bad data, etc.)
		ac_process_end($post['process_id']);
	}

	// cleanup if not a test
	if ( !$test ) {
		// delete all check
		if ( $post['delete_all'] ) ac_ihook('ac_import_delete_all', $post);
		//ac_ihook('ac_import_cleanup', $post, $r);
	}
	$r['failed'] = $r['found'] - $r['imported'] - $offset;
	// done
	$r['succeeded'] = ( $r['found'] == $r['imported'] );
	$r['message'] = sprintf(_a('Import Completed. %d items found, %d items imported.'), $r['found'], $r['imported']);
	$jsfunc = ( $r['succeeded'] ? 'ac_result_show' : 'ac_error_show' );
	if ( $r['found'] > 0 ) ac_import_log_comment('</table>');

	ac_import_log_comment(
		'
			<script>
				if (parent && parent.ac_ui_api_callback)
					parent.ac_ui_api_callback();
				if (parent && parent.' . $jsfunc . ')
					parent.' . $jsfunc . '("' . htmlentities($r['message']) . '");
			</script>
		'
	);

	if ( $useProcesses ) {
		ac_import_log_comment(
			'
				<script>
					if (parent && parent.ac_progressbar_register && parent.document.getElementById("progressBar")) {
						parent.ac_progressbar_set("progressBar", 100);
						parent.ac_progressbar_unregister("progressBar");
					}
				</script>
			'
		);
	}

	if ( $test ) {
		ac_import_log_comment(_a('Import Test Completed'));
	} else {
		ac_import_log_comment(_a('Import Completed'));
		// remove the import file
		if ( $r['filename'] and file_exists(ac_cache_dir($r['filename'])) ) {
			@unlink(ac_cache_dir($r['filename']));
		}
	}
	ac_import_log_comment(_a('Imported: ') . $r['imported']);
	ac_import_log_comment(_a('Failed: ') . $r['failed']);
	return $r;
}

function ac_import_row($post, $row, $test) {
	return ac_ihook('ac_import_row', $post, $row, $test);
}

function ac_import_report($processid) {
	$processid = (int)$processid;
	$table = AC_IMPORT_LOGTABLE;
	$r = array(
		'counts' => array(),
		'lists'  => array(),
		'total'  => 0,
	);
	$query = "SELECT email, code, msg, tstamp FROM $table WHERE processid = '$processid' AND res = 0 ORDER BY tstamp DESC";
	$sql = ac_sql_query($query);
	while ( $row = ac_sql_fetch_assoc($sql) ) {
		$destination = ac_ihook('ac_import_row_report', $row);
		$r['lists'][$destination][] = $row;
	}
	$r['counts'] = array_map('count', $r['lists']);

	$r['total'] = array_sum($r['counts']);

	return $r;
}

?>
