<?php

require_once ac_global_classes("select.php");
require_once ac_global_functions("auth.php");

function ac_loginsource_select_query(&$so) {
	return $so->query("
		SELECT
			*
		FROM
			#loginsource
		WHERE
			[...]
	");
}

function ac_loginsource_select_row($id) {
	$id = intval($id);
	$so = new AC_Select;
	$so->push("AND id = '$id'");

	return ac_sql_select_row(ac_loginsource_select_query($so));
}

function ac_loginsource_select_array($so = null, $ids = null) {
	if ($so === null || !is_object($so))
		$so = new AC_Select;

	if ($ids !== null) {
		$tmp = array_map("intval", explode(",", $ids));
		$ids = implode("','", $tmp);
		$so->push("AND id IN ('$ids')");
	}

	return ac_sql_select_array(ac_loginsource_select_query($so));
}

function ac_loginsource_select_array_paginator($id, $sort, $offset, $limit, $filter) {
	ac_loginsource_sync();

	$admin = ac_admin_get();
	$so = new AC_Select;

	$so->count();
	$total = (int)ac_sql_select_one(ac_loginsource_select_query($so));

	switch ($sort) {
		default:
		case "01":
			$so->orderby("enabled DESC, ident"); break;
		case "01D":
			$so->orderby("enabled DESC, ident DESC"); break;
		case "02":
			$so->orderby("enabled DESC, `order`"); break;
		case "02D":
			$so->orderby("enabled DESC, `order` DESC"); break;
	}

	$limit  = (int)$limit;
	$offset = (int)$offset;
	$so->limit("$offset, $limit");
	$rows = ac_loginsource_select_array($so);

	return array(
		"paginator"   => $id,
		"offset"      => $offset,
		"limit"       => $limit,
		"total"       => $total,
		"cnt"         => count($rows),
		"rows"        => $rows,
	);
}

function ac_loginsource_update_post() {
	$ary = array(
		"enabled"     => intval(isset($_POST["enabled"])),
		"host"        => $_POST["host"],
		"port"        => intval($_POST["port"]),
		"user"        => $_POST["user"],
		"pass"        => $_POST["pass"],
		"dbname"      => $_POST["dbname"],
		"tableprefix" => $_POST["tableprefix"],
		"basedn"      => $_POST["basedn"],
		"loginusesdn" => intval(isset($_POST["loginusesdn"])),
		"loginattr"   => $_POST["loginattr"],
		"binddn"      => $_POST["binddn"],
		"bindpw"      => $_POST["bindpw"],
		"userattr"    => $_POST["userattr"],
	);

	if ($_POST["ad_basedn"] != "") {
		$ary["basedn"]      = $_POST["ad_basedn"];
		$ary["binddn"]      = $_POST["ad_admin_dn"];
		$ary["bindpw"]      = $_POST["ad_admin_pw"];
		$ary["loginusesdn"] = 1;
		$ary["loginattr"]   = "cn";
		$ary["userattr"]    = "samAccountName";
	}

	if (isset($_POST["groupset"]) && is_array($_POST["groupset"]))
		$ary["groupset"] = implode(",", $_POST["groupset"]);

	$id = intval($_POST["id"]);
	$sql = ac_sql_update("#loginsource", $ary, "id = '$id'");

	ac_ihook("acg_loginsource_update", $id);

	if ( !$sql ) {
		return ac_ajax_api_result(false, _a("Login source could not be updated."));
	}

	return ac_ajax_api_updated(_a("Login source"));
}

function ac_loginsource_sync() {
	# Go through every file in /ac_global/loginsource and, if it's a valid file, add it to
	# the database.  If there are database entries not present in the filesystem, we should
	# also remove them.

	$unfiles   = ac_file_find(ac_global("loginsource"), "");
	// patch to move the local to the front
	if ( in_array(ac_global("loginsource/local.php"), $unfiles) ) {
		$unfiles   = array_unique(array_merge(array(ac_global("loginsource/local.php")), $unfiles));
	}
	$unsources = ac_loginsource_select_array();
	$files     = array();
	$vars      = array();

	foreach ($unfiles as $file) {
		$data = ac_file_get($file);
		$mat  = array();
		if (preg_match('/\$loginident = "([^"]+)";/', $data, $mat)) {
			$ident = $mat[1];
			$files[$ident] = $file;
		}

		if (preg_match('/\$loginvars = "([^"]*)";/', $data, $mat)) {
			$vars[$ident] = $mat[1];
		}
	}

	# First, check to see what should be removed.

	$delist = array();
	foreach ($unsources as $source) {
		if (!isset($files[$source["ident"]])) {
			$delist[] = $source["id"];
		}

		$sources[$source["ident"]] = $source;
	}

	# Now, add any new files.

	foreach ($files as $ident => $file) {
		$max = ac_sql_select_one("SELECT MAX(`order`) FROM #loginsource");

		if ($max === "")		# No rows in the table
			$max = 1;
		else
			$max = $max + 1;

		if (!isset($sources[$ident])) {
			$ary = array(
				"enabled"  => $ident == "Local" ? 1 : 0,
				"ident"    => $ident,
				"vars"     => $vars[$ident],
				"file"     => basename($file),
				"groupset" => "3",
				"order"    => $max,
			);

			# This is a temporary fix--we'll have a comprehensive solution for default
			# port values (or perhaps others) in the future.
			if ($ary["ident"] == "LDAP")
				$ary["port"] = 389;

			ac_sql_insert("#loginsource", $ary);
		} else {
			$ary = array(
				"ident"    => $ident,
				"vars"     => $vars[$ident],
				"file"     => basename($file),
			);

			$id = $sources[$ident]["id"];
			ac_sql_update("#loginsource", $ary, "id = '$id'");
		}
	}

	# And remove the bad sources.

	$delist_str = implode("','", $delist);
	ac_sql_query("DELETE FROM #loginsource WHERE id IN ('$delist_str')");
}

function ac_loginsource_select_local() {
	$so = new AC_Select;
	$so->push("AND ident = 'Local'");

	$rows = ac_loginsource_select_array($so);

	if (count($rows) > 0)
		return $rows[0];
	else
		return false;
}

function ac_loginsource_determine($user, $pass, $adminaccess = 1) {
	# If the user already exists, we'll return the source record that we should
	# be using to connect with.  If not, we return null.

	$auth   = ac_auth_record_username($user);
	$source = false;

	if ($auth["id"] == 1) {
		$source               = ac_loginsource_select_local();
		$file                 = basename($source["file"]);
		$source["_classname"] = sprintf("%sLoginSource", $source["ident"]);

		if (file_exists(ac_global("loginsource/$file"))) {
			require_once ac_global("loginsource/$file");
		} else {
			$source = false;
		}
	}

	if ($auth !== false && $auth["sourceid"] > 0) {
		$source = ac_loginsource_select_row($auth["sourceid"]);

		if ($source && $source["enabled"]) {
			$file                 = basename($source["file"]);
			$source["_classname"] = sprintf("%sLoginSource", $source["ident"]);

			if (file_exists(ac_global("loginsource/$file"))) {
				require_once ac_global("loginsource/$file");
			} else {
				$source = false;
			}
		} else {
			# We can't use this source--it's been disabled.  Treat this
			# as if the user had no sourceid at all.
			$source = false;
		}
	}

	if ($source === false) {
		# First, find the groups which we'll accept in our login sources, based on $adminaccess.
		# We always omit the Visitor group (id=1).
		$adminaccess = intval($adminaccess);

		if ($adminaccess == 1)
			$okgroups = ac_sql_select_list("SELECT id FROM #group WHERE p_admin = '$adminaccess' AND id != 1");
		else
			$okgroups = ac_sql_select_list("SELECT id FROM #group WHERE id != 1");

		$so = new AC_Select;
		$so->push("AND enabled = 1");
		$so->orderby("`order` ASC");

		$list = ac_loginsource_select_array($so);

		# Keep trying login sources till we find one that works.
		$i = 0;
		foreach ($list as $attempt) {
			$agroups               = explode(",", $attempt["groupset"]);

			# Skip this login source if the groups don't match our hoped-for access.
			if (count(array_intersect($okgroups, $agroups)) < 1)
				continue;

			$file                  = basename($attempt["file"]);
			$attempt["_classname"] = sprintf("%sLoginSource", $attempt["ident"]);

			if (file_exists(ac_global("loginsource/$file"))) {
				require_once ac_global("loginsource/$file");

				$s = new $attempt["_classname"]($attempt);

				$s->connect();
				if ($s->authok($user, $pass)) {
					$source = $attempt;
					break;
				}
			}
		}

		# If it's still false, then just use the local one.
		if ($source === false) {
			$source               = ac_loginsource_select_local();
			$file                 = basename($source["file"]);
			$source["_classname"] = sprintf("%sLoginSource", $source["ident"]);

			if (file_exists(ac_global("loginsource/$file"))) {
				require_once ac_global("loginsource/$file");
			} else {
				$source = false;
			}
		}
	}

	if ($source === false) {
		# Still???
		die(_a("Your database does not have any login sources that we can use--not even the default local source."));
	}

	return $source;
}

function ac_loginsource_recognize($sourceid, $order) {
	$ary = array(
		"sourceid" => $sourceid,
		"order"    => $order,
	);

	# First clear out the table, then add the new record.  This method is liable to
	# change in the future.
	#ac_sql_query("TRUNCATE TABLE #loginsource_use");
	#ac_sql_insert("#loginsource_use", $ary);
}

function ac_loginsource_reorder($sourceid, $dir) {
	$sourceid  = intval($sourceid);
	$source    = ac_loginsource_select_row($sourceid);
	$sourceord = intval($source["order"]);

	if ($dir == "u")
		$swapord = $sourceord - 1;
	elseif ($dir == "d")
		$swapord = $sourceord + 1;
	else
		return;

	if ($swapord < 1)
		return;

	ac_sql_query("UPDATE #loginsource SET `order` = '$sourceord' WHERE `order` = '$swapord'");
	ac_sql_query("UPDATE #loginsource SET `order` = '$swapord' WHERE id = '$sourceid'");
}

?>
