<?php
// pagination.php

require_once(ac_global_classes('pagination.php'));
require_once(ac_global_functions('http.php'));

function ac_pagination_offset($container) {
    $pgindex = 'pagination_'.$container;

    if (!isset($_SESSION[$pgindex]))
        $_SESSION[$pgindex] = array('offset' => 0);

    if (ac_http_param('offset'))
        $_SESSION[$pgindex]['offset'] = intval(ac_http_param('offset'));
    else
        $_SESSION[$pgindex]['offset'] = 0;

    return $_SESSION[$pgindex]['offset'];
}

function ac_pagination_build(&$smarty, $pgvar, $base, &$rows, $limit, $offset, $total) {
    $pg = new Pagination($total, count($rows), $limit, $offset, $base);
    $pg->buildLinks();
    $smarty->assign($pgvar, $pg);
}

?>
