<?php

function ac_process_select_query(&$so) {
	return $so->query("
		SELECT
			*,
			`total` - `completed` AS remaining,
			IF(`ldate` IS NULL, 1, UNIX_TIMESTAMP(NOW()) - UNIX_TIMESTAMP(`ldate`)) AS stall
		FROM
			`#process`
		WHERE
		[...]
	");
}


function ac_process_select_count(&$so) {
	$so->count();
	return ac_sql_select_one(ac_process_select_query($so));
}

function ac_process_select_array($var = null) {
	if (!is_object($var))
		$so = new AC_Select;
	else
		$so = $var;

	if ($var !== null && !is_object($var)) {
		if ( !is_array($var) ) $var = explode(",", $var);
		$ids = implode("', '", array_map("intval", $var));
		$so->push("AND `id` IN ('$ids')");
	}
	//dbg(ac_prefix_replace(ac_process_select_query($so)));
	return ac_sql_select_array(ac_process_select_query($so), array('cdate', 'ldate'));
}

function ac_process_create($action, $total, $data = null, $spawn = true, $sdate = null) {
	$admin = ac_admin_get();
	$uid = ( $admin['id'] > 0 ? $admin['id'] : 1 );
	// check for existence
	if ( !is_null($data) or $spawn ) {
		$so = new AC_Select;
		$actionEsc = ac_sql_escape($action);
		$dataEsc = ac_sql_escape(serialize($data));
		$so->push("AND `userid` = '$uid'");
		$so->push("AND `action` = '$actionEsc'");
		$so->push("AND `data` = '$dataEsc'");
		if ( !is_null($sdate) ) {
			$sdateEsc = ac_sql_escape($sdate);
			$so->push("AND `ldate` = '$sdateEsc'");
		}
		$found = ac_process_awaiting($so, true);
		if ( $found > 0 ) {
			list($process) = ac_process_awaiting($so);
			if ( $spawn ) ac_process_spawn($process);
			return $process['id'];
		}
	}
	// create it in db
	$arr = array(
		'id' => 0,
		'userid' => $uid,
		'rnd' => mt_rand(1201000, 9871000),
		'action' => $action,
		'total' => $total,
		'completed' => 0,
		'percentage' => 0,
		'data' => serialize($data),
		'=cdate' => 'NOW()',
	);
	$datefields = array(/*'cdate', 'ldate'*/);
	if ( !is_null($sdate) ) {
		if ( $sdate == 'NULL' ) { // paused
			$arr['=ldate'] = 'NULL';
		} else {
			$arr['ldate'] = $sdate;
			$datefields = array('ldate');
		}
	} else {
		if ( $spawn ) {
			$arr['ldate'] = '0000-00-00 00:00:00'; // hack
			//$arr['=ldate'] = 'SUBDATE(NOW(), INTERVAL 5 MINUTE)'; // hack
		} else {
			$arr['=ldate'] = 'NOW()';
		}
	}
	$done = ac_sql_insert('#process', $arr, $datefields) or die(ac_sql_error());
	if ( !$done ) return false;
	// grab newly created process id
	$id = ac_sql_insert_id();
	// spawn separate process
	if ( $spawn /*and isset($arr['=ldate']) and $arr['=ldate'] != 'NULL'*/ ) {
		ac_process_spawn(array('id' => $id, 'stall' => 5 * 60));
	}
	return $id;
}

function ac_process_update($id, $increment = true) {
	$id = (int)$id;
	$arr = array('=ldate' => 'NOW()');
	if ( $increment ) {
		$arr['=completed'] = '`completed` + 1';
		$arr['=percentage'] = '`completed` / `total` * 100';
	}
/*
	$filename = ac_base('cache/process-' . $id . '.txt');
    if ($handle = fopen($filename, 'a')) {
	    $somecontent = str_repeat("\n", 3) . "PROCESS UPDATE:\n" . print_r(debug_backtrace(), 1);
    	fwrite($handle, $somecontent);
	    fclose($handle);
    }
*/
	return ac_sql_update('#process', $arr, "`id` = '$id'");
}

function ac_process_setdata($id, $data = null) {
	$id = (int)$id;
	return ac_sql_update_one('#process', 'data', serialize($data), "`id` = '$id'");
}

function _ac_process_pickup_preg_replace_cb($matches) {
	return "s:" . strlen($matches[2]) . ":\"$matches[2]\";";
}

function ac_process_pickup($id) {
	$process = ac_process_get($id);
	if ( !$process ) return;
	// if stalled for more than 4 minutes
	if ( $process['stall'] && $process['stall'] > 4 * 60 ) {
		$out = preg_replace_callback( '!s:(\d+):"([^"]*?)";!s', '_ac_process_pickup_preg_replace_cb', $process['data']);
		$process['data'] = @unserialize($out);
		$r = ac_ihook('ac_process_handler', $process); // this one might stall
		// but if it didn't, and returned result
		if ( isset($r['succeeded']) ) {
			// and result is false
			if ( !$r['succeeded'] ) {
				// should we remove this process?
				//ac_process_remove($id);
			}
		}
	}
}

function ac_process_info(&$process) {
	$process['name'] = sprintf(_a('Unknown Process (%s)'), $process['action']);
	$process['descript'] = '';
	if ( !isset($process['data']) ) return $process;
	$process['data'] = @unserialize($process['data']);
	if ( !$process['data'] ) return $process;
	$r = ac_ihook('ac_process_info', $process);
	if ( !$r ) return $process;
	if ( isset($r['name']) ) $process['name'] = $r['name'];
	if ( isset($r['descript']) ) $process['descript'] = $r['descript'];
	return $process;
}

function ac_process_end($id) {
	$id = (int)$id;
	ac_sql_query("UPDATE #process SET completed = total, percentage = 100 WHERE id = '$id'");
}

function ac_process_spawn($process) {
	$debug = (bool)ac_http_param('debugspawn');
	$url = ac_site_alink('process.php?id=' . $process['id']);
	// if stalled for more than 4 minutes
	if ( !$process['stall'] or $process['stall'] < 4 * 60 ) return;
	// respawn old process as a separate process
	//dbg($url);
	//dbg(ac_http_get($url));

	$ran = ac_http_spawn($url);
	if ( $debug ) ac_flush("\n\n$url spawned:\n-\n$ran\n-");

	if ( !$ran and isset($GLOBALS['__tryspawnonly']) ) return;

	if ( !$ran and function_exists('curl_init') ) {
		// Set up and execute the curl process
		$curl_handle = curl_init();
		curl_setopt($curl_handle, CURLOPT_URL, $url);
		curl_setopt($curl_handle, CURLOPT_CONNECTTIMEOUT, 2);
		curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl_handle, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($curl_handle, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($curl_handle, CURLOPT_HEADER, 0);
		//curl_setopt($curl_handle, CURLOPT_FOLLOWLOCATION, 1); // can't work if safe_mode is on or open_basedir is set
		$ran = curl_exec($curl_handle);
		curl_close($curl_handle);
		if ( ac_str_instr('404', $ran) or ac_str_instr('page not found', strtolower($ran) ) ) {
			$ran = false;
		}
		if ( $debug ) ac_flush("\n\n$url curled:\n-\n$ran\n-");
	}
	if ( !$ran ) {
		$ran = ac_http_get($url);
		if ( ac_str_instr('404', $ran) or ac_str_instr('page not found', strtolower($ran) ) ) {
			$ran = false;
		}
		if ( $debug ) ac_flush("\n\n$url fetched:\n-\n$ran\n-");

	}
	if ( !$ran and function_exists('proc_open') and strtoupper(substr(PHP_OS, 0, 3)) !== 'WIN' ) {
		$spawnres = !ac_php_spawn(sprintf('wget %s > /dev/null', $url), $debug);
		$ran = ( $spawnres['res'] and $spawnres['err'] != '' );
		if ( $debug ) ac_flush("\n\n$url spawned:\n-\n$ran\n-");
	}
	// if local file, finally try include
	if ( !$ran ) {
		ac_process_pickup($process['id']); // this runs process
		$ran = true;
	}
}

function ac_process_respawn($id = null, $debug = false) {
	$so = new AC_Select;
	if ( !is_null($id) && $id = (int)$id ) {
		$so->push("AND `id` = '$id'");
	} else {
		$so->limit("0, 5");
	}
	$processes = ac_process_awaiting($so);
	if ( $debug and count($processes) == 0 ) {
		ac_flush('There are no stalled processes at this time.');
	}
	foreach ( $processes as $process ) {
		// print out process info
		if ( $debug ) {
			ac_flush(print_r($process, 1));
		}
		ac_process_spawn($process);
	}
}

function ac_process_awaiting($so = null, $count = false) {
	if ( is_null($so) ) $so = new AC_Select;

	$so->push("AND `completed` < `total`");
	$so->push("AND `ldate` IS NOT NULL");
	if ( $count ) {
		return (int)ac_process_select_count($so);
	}
	$so->orderby("`ldate` ASC");
	return ac_process_select_array($so);
}

function ac_process_get($id) {
	$id = (int)$id;
	$so = new AC_Select;
	$so->push("AND `id` = '$id'");
	return ac_sql_select_row(ac_process_select_query($so), array('cdate', 'ldate'));
}

function ac_process_cleanup() {
	return ac_sql_delete('#process', "`completed` = `total` AND `ldate` < SUBDATE(NOW(), INTERVAL 10 DAY)");
}

function ac_process_remove($id) {
	$id = (int)$id;
	return ac_sql_delete('#process', "`id` = '$id'");
}

function ac_progressbar_update($id, $spawn = false) {
	$process = ac_process_get($id);
	if ( !$process ) {
		return ac_ajax_api_result(false, _a('Process not found.'));
	}
	if ( $process['remaining'] == 0 ) {
		$process['percentage'] = 100; // round it
	} elseif ( $spawn ) {
		ac_process_spawn($process);
	}
	unset($process['data']);
	return $process;
}

?>
