<?php

/*
error messages:
API_DISABLED_FOR_ORG: API is not enabled for this Organization or Partner
INVALID_LOGIN: Invalid username, password, security token; or user locked out.
*/

function ac_salesforce_connect($post) {
	require_once(ac_global_classes('salesforce/soapclient/SforcePartnerClient.php'));
	$connection = new SforcePartnerClient();
	$client = $connection->createConnection( ac_global_classes('salesforce/soapclient/partner.wsdl.xml') );
	try {
		$login = $connection->login($post['salesforce_username'], $post['salesforce_password'] . $post['salesforce_token']);
	} catch ( Exception $e ) {
		$msg = $e->getMessage();
		if ( ac_str_instr('API_DISABLED_FOR_ORG', $msg) ) {
			$msg = _a("API is not enabled for this SalesForce account. Please login into SalesForce to turn it on.");
		} elseif ( ac_str_instr('INVALID_LOGIN', $msg) ) {
			$msg = _a("Please check your login info: username, password and token. One of those is not correct.");
		}
		return array('message'=> $msg);
	}
	return $connection;
}

?>