<?php

require_once dirname(__FILE__) . '/prefix.php';

function ac_session_need_update() {
    $key = ac_prefix_first("acp_need_update");
    return isset($_SESSION[$key]) && $_SESSION[$key] == true;
}

function ac_session_drop_cache() {
    $_SESSION[ac_prefix_first("acp_need_update")] = true;
}

function ac_session_has($key) {
    if (ac_session_need_update())
        ac_session_unset($key);

    return isset($_SESSION['ac_' . $key]);
}

function ac_session_get($key) {
    return $_SESSION['ac_' . $key];
}

function ac_session_set($key, $val) {
    $_SESSION['ac_' . $key] = $val;
}

function ac_session_unset($key) {
    unset($_SESSION['ac_' . $key]);
}

?>
