<?php

if ( !defined('AC_API_REMOTE') ) define('AC_API_REMOTE', 0);
if ( !defined('AC_API_REMOTE_OUTPUT') ) define('AC_API_REMOTE_OUTPUT', 'xml');

// get params
$action = (string)ac_http_param('f');

if ( $action == '' ) {
    ac_api_error(_a("No command."));
	exit;
} elseif ( !isset($allowed[$action]) ) {
    ac_api_error(sprintf(_a("Unknown command: %s"), $action));
	exit;
}

$actionFile = ac_admin("api/$action.php"); // api files for both public and admin side are in admin/api!
$actionFunc = ($allowed[$action] != '' ? $allowed[$action] : $action);

if (!file_exists($actionFile)) {
	if (strpos($action, ".") !== false) {	# file.function
		$tmp = explode(".", $action);
		$actionFile = ac_admin("functions/$tmp[0].php");
		$actionFunc = $tmp[1];
	} elseif (strpos($action, "!") !== false) {	# file!ac_function
		$tmp = explode("!", $action);
		$actionFile = ac_global_functions("$tmp[0].php");
		$actionFunc = $tmp[1];
	} else {								# the function name is the same as the filename
		$actionFile = ac_admin("functions/$action.php");
	}
}

if ( /*$allowed[$action] == '' and*/ !file_exists($actionFile) ) {
	ac_api_error(_a("Action File does not exist, Corrupted installation. Reupload all the files."));
	exit;
}

// require the api function file
require_once($actionFile);

if ( !function_exists($actionFunc) ) {
	ac_api_error(_a("Action Function does not exist, Corrupted installation. Reupload all the files."));
	exit;
}

// declare requested action only
ac_ajax_declare($action, $actionFunc);

ac_api_run();

?>
