<?php

// turning off some php limits
@ignore_user_abort(1);
@ini_set('max_execution_time', 950 * 60);
@set_time_limit(950 * 60);
$ml = ini_get('memory_limit');
if ( $ml != -1 and (int)$ml < 512 and substr($ml, -1) == 'M' ) @ini_set('memory_limit', '512M'); // database exporter

// define paths
$globalPath  = dirname(dirname(__FILE__));
$publicPath = dirname($globalPath);
$configPath =
$adminPath = $publicPath . DIRECTORY_SEPARATOR . 'admin';


// define constants here
define('AC_LANG_NEW', 1);


require_once($adminPath . '/functions/ac_global.php');
require_once($globalPath . '/functions/instup.php');
require_once($globalPath . '/functions/base.php');
require_once($globalPath . '/functions/php.php');
require_once($globalPath . '/functions/http.php');
require_once($globalPath . '/functions/lang.php');
require_once($globalPath . '/functions/site.php');
require_once($globalPath . '/functions/file.php');
require_once($globalPath . '/functions/sql.php');
require_once($globalPath . '/functions/tz.php');
require_once($globalPath . '/functions/utf.php');

// this file has ihooks
require_once($globalPath . '/functions/ihook.php');
require_once($adminPath . '/functions/ihooks.php');


ac_ihook('ac_updater_prepend');

// load db info
require_once($adminPath . '/engine.inc.php');
require_once($adminPath . '/authentication_db.inc.php');
$GLOBALS['auth_db_link'] = mysql_connect(ACP_AUTHDB_SERVER, ACP_AUTHDB_USER, ACP_AUTHDB_PASS, true) or die("Unable to connect to your authentication database; please ensure that the information held in /admin/authentication_db.inc.php is correct.");
mysql_select_db(ACP_AUTHDB_DB, $GLOBALS['auth_db_link']) or die("Unable to select database after connecting to MySQL: " . ac_auth_sql_error());

if (defined("REQUIRE_MYSQLVER")) {
	$rval = verifyVersion($GLOBALS['db_link'], REQUIRE_MYSQLVER);
	if ($rval != "")
		die($rval);
}

// don't change time limit, show errors, start session
ac_php_environment(null, 1, true);

// fetch installed languages
$languages = ac_lang_choices();

$lang = ( isset($_COOKIE['ac_lang']) ? $_COOKIE['ac_lang'] : 'english' );
if ( isset($_POST['lang_ch']) and isset($languages[$_POST['lang_ch']]) ) {
	$lang = $_POST['lang_ch'];
	@setcookie('ac_lang', $lang, time() + 365 * 24 * 60 * 60, '/');
}
// Preload the language file
ac_lang_load(ac_lang_file($lang, 'admin'));


$versionHash =
	md5(
		base64_encode(base64_encode(base64_encode($thisVersion))) .
		'acp' .
		base64_encode(base64_encode($thisVersion)) .
		'rulz' .
		base64_encode($thisVersion)
	) .
	base64_encode(base64_encode($thisVersion))
;

$smarty = smarty_get();

$smarty->assign('requirements', $GLOBALS['ac_requirements']);
$smarty->assign('appname', $GLOBALS['ac_app_name']);
$smarty->assign('appid', $GLOBALS['ac_app_id']);
$smarty->assign('appver', $thisVersion);
$smarty->assign('lang', $lang);
$smarty->assign('languages', $languages);



// request variables
$dr3292 = (string)ac_http_param('dr3292');
$dl_t = (string)ac_http_param('dl_t');
$dl_s = (string)ac_http_param('dl_s');
$dl_dd = (string)ac_http_param('dl_dd');

//$act = (string)ac_http_param('act');
//$t = (string)ac_http_param('t');

$d_h      = $_SERVER['SERVER_NAME'];
$d_r      = ( isset($dr) ? $dr : $adminPath );//dirname(__FILE__);

$protocol = ( ( isset($_SERVER['HTTPS']) and strtolower($_SERVER['HTTPS']) == 'on' ) ? 'https' : 'http' );
$rd7      = $protocol . '://' . $_SERVER['SERVER_NAME'] . str_replace('\\', '/', $_SERVER['PHP_SELF']);
$rd764    = base64_encode($rd7);


if ( ac_http_is_ssl() ) {
	$port = ( $_SERVER['SERVER_PORT'] != 443 ? ':' . $_SERVER['SERVER_PORT'] : '' );
} else {
	$port = ( $_SERVER['SERVER_PORT'] != 80 ? ':' . $_SERVER['SERVER_PORT'] : '' );
}
$rd7port  = $protocol . '://' . $_SERVER['SERVER_NAME'] . $port . str_replace('\\', '/', $_SERVER['PHP_SELF']);

$siteurl  = str_replace("/admin/updater.php", '', $rd7port);

$GLOBALS["ac_help_imgpath"] = $siteurl . '/ac_global';



$smarty->assign('d_h', $d_h);
$smarty->assign('d_r', $d_r);
$smarty->assign('rd7', $rd764);
$smarty->assign('rd8', substr(md5($thisVersion), 13) . substr(md5($thisVersion), 0, 13));
$smarty->assign('rd9', base64_encode($thisVersion));

$smarty->assign('dr3292', $dr3292);
$smarty->assign('dl_t', $dl_t);
$smarty->assign('dl_s', $dl_s);
$smarty->assign('dl_dd', $dl_dd);
$smarty->assign('protocol', $protocol);
$smarty->assign('siteurl', $siteurl);

tz_init();
$smarty->assign('timezones', tz_box());




// first step is GET, second is POST, and no other steps

$allgood = ( $_SERVER['REQUEST_METHOD'] == 'POST' and (string)ac_http_param('dl_s') != '' );
$smarty->assign('allgood', $allgood);

$site = null;
$serial = '';
$oldVersion = '';
$p_link = '';

$content_template = ( $allgood ? 'updater.step2.htm' : 'updater.step1.htm' );
$smarty->assign('content_template', $content_template);

$sql = mysql_query("SHOW TABLES LIKE 'acp\_globalauth'", $GLOBALS['auth_db_link']);
$authTableFound = ( $sql and mysql_num_rows($sql) == 1 );
if ( !$authTableFound ) {
	$authenticated = true;
} else {
	$authenticated = ( isset($_COOKIE[ac_prefix("acp_globalauth_cookie")]) and substr($_COOKIE[ac_prefix("acp_globalauth_cookie")], 32) == 1 );
	// fetch backend (gotta go raw so it doesn't fail on bad query (old version support)
	$sql = mysql_query(ac_prefix_replace('SELECT * FROM #backend LIMIT 0, 1'), $db_link);
	if ( $sql and mysql_num_rows($sql) == 1 ) {
		$site = mysql_fetch_assoc($sql);
	} else {
		$site = ac_ihook('ac_updater_version');
	}
	if ( isset($site['version']) ) {
		$oldVersion = $site['version'];
	}
	if ( $authenticated and isset($site['serial']) ) {
		$serial = $site['serial'];
	}
	if ( isset($site['p_link']) ) {
		$p_link = $site['p_link'];
	} elseif ( isset($site['murl']) ) {
		$p_link = $site['murl'];
	}
}
$ask4URL = ( $p_link != $siteurl );

$smarty->assign('authenticated', $authenticated);
$smarty->assign('oldVersion', $oldVersion);
$smarty->assign('serial', $serial);
$smarty->assign('p_link', $p_link);
$smarty->assign('ask4URL', $ask4URL);

$step = ( $allgood ? 4 : 1 );
$smarty->assign('step', $step);

$requirementsMet = false;
$smarty->assign('requirementsMet', $requirementsMet);

// support for multiple apps
if ( !isset($GLOBALS['ac_app_subs']) ) $GLOBALS['ac_app_subs'] = array();
$smarty->assign('subapps', $GLOBALS['ac_app_subs']);

if ( file_exists($publicPath . '/docs/license.txt') ) {
	$license = ac_file_get($publicPath . '/docs/license.txt');
} elseif ( file_exists($globalPath . '/includes/license.php') ) {
	$license = ac_file_get($globalPath . '/includes/license.php');
} else {
	$license = '';
}

if ( ac_ihook_exists('ac_updater_branding') and !ac_ihook('ac_updater_branding') ) $license = '';
$smarty->assign('license', $license);


if ( !$allgood ) {
	// check for all needed settings for updater (and app) to work [smarty mainly]
	permissions_check($smarty, false);
	functions_check($smarty, false);
	// mysql_* function check
	// 2DO
	// session check
	$_SESSION['ac_updater'] = array();
	if ( $authenticated ) {
		$step++;

		// database backup code
		if ( isset($_GET['backup']) ) {
			@ini_set('memory_limit', '-1'); // database exporter

			// set to echo
			$GLOBALS['sqlstreamecho'] = 1;

			if ( isset($GLOBALS['ac_updater_backend']) ) {
				ac_prefix_push($GLOBALS['ac_updater_backend']);
			}

			ac_http_header_attach('backup.sql');
			ac_sql_stdout("# $GLOBALS[ac_app_name] MySQL Database Structure & Contents\r\n");
			ac_sql_stdout("# \r\n");
			ac_sql_stdout("# Host: " . ( isset($_SERVER['SERVER_NAME']) ? (string)$_SERVER['SERVER_NAME'] : 'localhost' ) . "\r\n");
			ac_sql_stdout("# Generation Time: " . date('M d, Y \a\t H:i A') . "\r\n");
			ac_sql_stdout("# PHP Version: " . phpversion() . "\r\n");
			ac_sql_stdout("#\r\n");
			ac_sql_stdout("# Database : `" . ac_sql_select_one("SELECT DATABASE()") . "`\r\n");
			ac_sql_stdout("#\r\n\r\n");

			// write2file version
			ac_sql_backup_all(true);
			exit;
		}
	}
} else {
	$requirementsMet = system_check($smarty, false);

	$_SESSION['ac_updater']['backend'] = $_POST;
	license_check($smarty, false, $d_r);
	// figure out step
	if ( $requirementsMet and !$smarty->get_template_vars('postProb') and !$smarty->get_template_vars('uploadProb') ) $step++;
	if ( !$ask4URL ) {
		$step++;
	} elseif ( isset($_SESSION['ac_updater']['plink']) ) $step++;
	$authenticated = true;
	$smarty->assign('authenticated', $authenticated);
}



$smarty->assign('step', $step);
$smarty->assign('requirementsMet', $requirementsMet);

$sysinfo = systeminfo(false);
$smarty->assign('sysinfo', $sysinfo);


$smarty->display('updater.htm');

?>
