var ac_amcharts_so = { };

function ac_amchart(obj) {
	// first check all object properties
	if ( obj.type != 'column' && obj.type != 'line' && obj.type != 'pie' && obj.type != 'xy' ) obj.type = 'pie';
	if ( !obj.width ) obj.width = '100%';
	if ( !obj.height ) obj.height = '400';
	if ( !obj.bgcolor ) obj.bgcolor = '#FFFFFF';
	if (typeof obj.location == "undefined") obj.location = "admin";

	var minFlash = '8';
	var amchartpath;

	switch (obj.location) {
		default:
		case "admin":
			amchartpath = ac_str_url(sprintf("../ac_global/am%s/", obj.type)); break;
		case "public":
			amchartpath = ac_str_url(sprintf("ac_global/am%s", obj.type)); break;
	}

	// now set new amChart
	ac_amcharts_so[obj.divid] = new SWFObject(
		sprintf(amchartpath + "am%s.swf", obj.type),	// movie url
		sprintf("am%s", obj.type),
		obj.width,                          // width
		obj.height,                         // height
		minFlash,                           // minimum flash version
		obj.bgcolor
	);

	ac_amcharts_so[obj.divid].addVariable("path", amchartpath);
	ac_amcharts_so[obj.divid].addVariable("settings_file", encodeURIComponent(obj.url));
	ac_amcharts_so[obj.divid].addVariable("chart_data", "");
	ac_amcharts_so[obj.divid].addVariable("preloader_color", "#999999");
	ac_amcharts_so[obj.divid].addVariable("left", "0");

	ac_amcharts_so[obj.divid].addVariable("additional_chart_settings", "<settings><export_as_image><file>" + amchartpath + "export.php</file></export_as_image><plot_area><margins><top>10</top></margins></plot_area></settings>");
	
	ac_amcharts_so[obj.divid].addParam("wmode", "transparent");

	if (typeof obj.write != "undefined")
		ac_amcharts_so[obj.divid].write(obj.divid);
}
