<?php

	// php 5 only

	require_once(ac_global_classes('Zend/Loader.php'));
	try {
		Zend_Loader::loadClass('Zend_Gdata');
		Zend_Loader::loadClass('Zend_Gdata_ClientLogin');
		Zend_Loader::loadClass('Zend_Http_Client');
		Zend_Loader::loadClass('Zend_Gdata_Query');
		Zend_Loader::loadClass('Zend_Gdata_Feed');

		$client = Zend_Gdata_ClientLogin::getHttpClient($user, $pass, 'cp');

		$gdata = new Zend_Gdata($client);
		$gdata->setMajorProtocolVersion(3);

		// perform query and get result feed
		$query = new Zend_Gdata_Query('http://www.google.com/m8/feeds/contacts/default/full');
		$query->maxResults = 5000;
		$feed = $gdata->getFeed($query);

		// parse feed and extract contact information into simpler objects
		$people = array();
		foreach ($feed as $entry) {
		  $xml = simplexml_load_string($entry->getXML());
		  $obj = new stdClass;
		  $obj->name = (string) $entry->title;
		  $obj->orgName = (string) $xml->organization->orgName;
		  $obj->orgTitle = (string) $xml->organization->orgTitle;

		  foreach ($xml->email as $e) {
		    $obj->emailAddress[] = (string) $e['address'];
		  }
		  foreach ($xml->phoneNumber as $p) {
		    $obj->phoneNumber[] = (string) $p;
		  }
		  foreach ($xml->website as $w) {
		    $obj->website[] = (string) $w['href'];
		  }

		  $person = get_object_vars($obj);
		  $person = array(
		  	"name" => $person["name"],
		  	"email" => ( isset($person["emailAddress"]) ) ? $person["emailAddress"][0] : "",
		  );
		  $people[] = $person;
		}
		if (!$people) {
			$r['message'] = _a('No records were found.');
			return $r;
		}
		$firstrow = current($people);
		$header = array_keys($firstrow);
		//dbg($header);
		$r['succeeded'] = true;
		$r['data'] = ac_array_csv($people, $header, $output = array());
	}
	catch (Exception $e) {
		$r['succeeded'] = false;
		// provide friendlier error messages
		switch ( $e->getMessage() ) {
			//case 'Security check: Illegal character in filename' :
			//break;
			case 'CAPTCHA challenge issued by server' :
				$error = _a('Incorrect username/password combination');
			break;
			default :
				$error = $e->getMessage();
			break;
		}
		$r['message'] = $error;
	}

?>