<?php

function smarty_function_ac_js($params, &$smarty) {
    $base = '';
    if ( isset($params['prfx']) ) {
    	$base = (string)$params['prfx'];
    } elseif ( isset($params['base']) ) {
    	$base = (string)$params['base'];
    	if ( $base != '' ) {
    		if ( $base != '/' ) $base .= '/'; // if requesting absolute root (/)
    	}
	} elseif (isset($_SERVER["SCRIPT_FILENAME"])) {
		$path = dirname($_SERVER["SCRIPT_FILENAME"]);
		if (!file_exists("$path/ac_global")) {
			$path = dirname($path);
			$base = "../";
		}
	} else {
		$path = dirname(__FILE__);
		if (!file_exists("$path/ac_global")) {
			$path = dirname($path);
			$base = "../";
		}
	}
	if ( function_exists('ac_site_isstandalone') and !ac_site_isstandalone() ) {
		if ( !isset($params['src']) ) {
			if (!preg_match('/^(http:|https:)/', $base))
				$base = '../' . $base;
		}
	} elseif ( defined('AC_KB_STANDALONE') and !AC_KB_STANDALONE ) {
		if ( !isset($params['src']) ) {
			if (!preg_match('/^(http:|https:)/', $base))
				$base = '../' . $base;
		}
	}

	/*
	// duplicate check
	if ( !isset($smarty->_ac_js) ) $smarty->_ac_js = array();
	foreach ( $smarty->_ac_js as $arr ) {
		if ( $params == $arr ) return ''; // we already printed this out in this smarty instance
	}
	$smarty->_ac_js[] = $params;
	*/

	if (isset($params['lib'])) {
		return "<script type='text/javascript' src='{$base}ac_global/$params[lib]'></script>";
	}

    if (isset($params['acglobal'])) {
        return '<script type="text/javascript" src="' . $base .'ac_global/js/ac.js.php?inc=' . $params['acglobal'] . '"></script>';
    }

    if (isset($params['src'])) {
		if (preg_match('/^(http:|https:)/', $params["src"]))
			$base = "";

        return '<script type="text/javascript" src="' . $base . $params['src'] . '"></script>';
    }

    return '';
}

?>
