<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */


/**
 * ActiveCampaign {chart} function plugin
 *
 * Type:     function<br>
 * Name:     editor<br>
 * Purpose:  call Flash Chart with appropriate XML file
 * @param array graph, width, weight, bgcolor, transparent, public, legend
 * @param Smarty
 */
function smarty_function_chart($params, &$smarty)
{
	// include the calling function
	require_once(ac_global_charts('charts.php'));
        require_once(ac_global_functions('charts.php'));
	// default params
	$graph = 'show=1';
	$width = 600;
	$height = 250;
	$bgcolor = 'ffffff';
	$transparent = true;
	$publicGraph = false;
	$showLegend = true;
	$update = 0;
	// set all the parameters if they don't exist
	if ( isset($params['graph']) ) $graph = $params['graph'];
	if ( isset($params['width']) AND (int)$params['width'] != 0 ) $width = (int)$params['width'];
	if ( isset($params['height']) AND (int)$params['height'] != 0 ) $height = (int)$params['height'];
	if ( isset($params['bgcolor']) ) $bgcolor = $params['bgcolor'];
	if ( isset($params['transparent']) ) $transparent = (bool)$params['transparent'];
	if ( isset($params['public']) ) $publicGraph = (bool)$params['public'];
	if ( isset($params['legend']) ) $showLegend = (bool)$params['legend'];
	if ( isset($params['update']) ) $update = (int)$params['update'];
	$swf = ac_charts_url() . '/ac_global/charts/charts.swf?random=' . md5(microtime());
	$shared = $smarty->get_template_vars('isShared');
    if (defined("AC_GLOBAL_CHARTS_NOCHARTDATA")) {
        $php = ac_charts_url() . ( $publicGraph ? '/index.php?' : ( $shared ? '/admin/' . $smarty->get_template_vars('reportsLink') . '&' : '/admin/main.php?' ) );
    } else {
        $php = ac_charts_url() . ( $publicGraph ? '/chartdata.php?random=' : '/admin/chartdata.php?random=' ) . md5(microtime());
    }
	if ( $graph != '' ) $php .= '&' . $graph;
	$php .= '&legend=' . (int)$showLegend;
	$php .= '&update=' . (int)$update;
	$lib = ac_charts_url() . '/ac_global/charts/charts_library';
	return InsertChart($swf, $lib, $php, $width, $height, $bgcolor, $transparent);
}



?>
