<?php
/*
	This file produces XML file needed for Desktop App
*/
// require main include file
require_once(dirname(dirname(__FILE__)) . '/prepend.inc.php');

if ( !$admin ) {
	echo 0;
	exit;
}

// Preload the language file
ac_lang_get('admin');


// fetch list of all his lists
$lists = list_get_all();
$lists_count = count($lists);

$listIDs = array_keys($lists);
$listCond = '';
if ( !ac_admin_ismaingroup() ) {
	$listCond = "WHERE l.id IN ('" . implode("', '", $listIDs) . "')";
}

$users = group_get_users($admin['groups']);
$userids = implode("', '", array_keys($users));

// check for privileges first?
// 2do



/*
	D O   A C T I O N S   F I R S T
*/


$action  = ac_http_param('action');
$id  = (int)ac_http_param('id');
$mid  = (int)ac_http_param('mid');
$status  = 0;
$message = '';

if ( $action == 'pause' ) {
	$status = ac_sql_update_one('#campaign', 'status', 3, "`id` = '$id' AND `userid` IN ('$userids')");
	if ( !$status ) $message = ac_sql_error();
} elseif ( $action == 'resume' ) {
	$status = ac_sql_update_one('#campaign', 'status', 2, "`id` = '$id' AND `userid` IN ('$userids')");
	if ( !$status ) $message = ac_sql_error();
} elseif ( $action == 'stop' ) {
	// mark it as stopped
	$status = ac_sql_update_one('#campaign', 'status', 4, "`id` = '$id' AND `userid` IN ('$userids')");
	if ( !$status ) $message .= ac_sql_error();
	// remove the temp table
	if ( $status ) {
		$status = ac_sql_query("DROP TABLE #x$id");
		if ( !$status ) $message .= ac_sql_error();
	}
	// mark it as cleaned up
	if ( $status ) {
		$status = ac_sql_update_one("#campaign", 'mail_cleanup', 1, "id = '$id' AND `userid` IN ('$userids')");
		if ( !$status ) $message .= ac_sql_error();
	}
	// remove the process
	if ( $status ) {
		$serialized = ac_sql_escape(serialize($id));
		$status = ac_sql_delete('#process', "`action` = 'campaign' AND `data` = '$serialized' AND `userid` IN ('$userids')");
		if ( !$status ) $message .= ac_sql_error();
	}
} elseif ( $action == 'delete' ) {
	// delete this campaign
	require_once(ac_admin('functions/campaign.php'));
	$r = campaign_delete($id);
	$status = $r['succeeded'];
	if ( !$status ) $message = $r['message'];
} else $action = false;



/*
	T H E N   F E T C H   T H E   Q U E U E
*/


$o = $r = array();


// fetch the queue
$so = new AC_Select();
$so->push("AND c.status IN (2, 3)");
$so->push("AND c.userid IN ('$userids')");
$so->orderby("c.name");
$queue = campaign_select_array($so);

foreach ( $queue as $k => $v ) {
	$queue[$k]['lists'] = campaign_lists($v['id']);
	$queue[$k]['msg'] = ac_sql_select_row("
		SELECT
			*
		FROM
			#campaign_message c,
			#message m
		WHERE
			c.messageid = m.id
		AND
			c.campaignid = '$v[id]'
		LIMIT 0, 1
	");
}
/*
while ( $row = mysql_fetch_assoc($sql) ) {
	if ( $row['inqueue'] > 0 ) {
		$row['messages'] = array();
		$sql2 = ac_sql_query("
			SELECT
				*
			FROM
				#campaign c
			WHERE
				nl = '$row[listid]'
			AND
				comp_send = 0
			AND
				status < 4
			ORDER BY
				mdate DESC, mtime DESC
		");
		while ( $row2 = mysql_fetch_assoc($sql2) ) {
			$sql3 = ac_sql_query("SELECT * FROM #message WHERE mesg_id = '$row2[id]' AND b = 0 LIMIT 1");
			$row2['msg'] = mysql_fetch_assoc($sql3);
			$nsent = $row2['send_amt'];
			$ntotal = $row2['total_amt'];
			if ( $nsent > $ntotal ) $nsent = $ntotal;
			$row2['nvs'] = ( $ntotal == 0 ? 0 : round($nsent / $ntotal * 100, 4) );
			if ( $row2['comp_transfer'] != 1 ) {
				$sql3 = ac_sql_query("SELECT offset, num_count FROM #mtbl_tr WHERE mesg_id = '$row2[id]'");
				if ( $row3 = mysql_fetch_assoc($sql3) ) {
					$percent_comp = ( $row3['num_count'] == 0 ? 0 : round($row3['offset'] / $row3['num_count'] * 100, 0) );
					if ( $percent_comp > 100 ) $percent_comp = 100;
					$row2['percent_comp'] = $percent_comp;
				}
			}
			if ( !isset($row2['percent_comp']) ) $row2['percent_comp'] = 0;
			$row2['stop'] = false;
			$s_date = date('Y-m-d');
			$s_time = date('H:i:s');
			list($year, $month, $day) = explode('-', $s_date);
			list($hours, $minutes, $seconds) = explode(':', $s_time);
			$s_p = 4;
			$displayDate = date('Y-m-d', mktime($hours, $minutes - $s_p, $seconds, $month, $day, $year));
			$limit_date = $displayDate;
			if ( $row2['ldate'] >= $limit_date ) {
				$displayDate = date('H:i:s', mktime($hours, $minutes - $s_p, $seconds, $month, $day, $year));
				$b_time = $displayDate;
				if ( $row2['ltime'] > $b_time ) $row2['stop'] = true;
			}
			list($year, $month, $day) = explode('-', $row2['mdate']);
			list($hour, $minute, $second) = explode(':', $row2['mtime']);
			$hour += ( $admin['t_offset_o'] == '+' ? $admin['t_offset'] : - $admin['t_offset'] );
			$row['mdate'] = date('Y-m-d', mktime($hour, $minute, $second, $month, $day, $year));
			$row['mtime'] = date('H:i:s', mktime($hour, $minute, $second, $month, $day, $year));
			list($year, $month, $day) = explode('-', $row2['ldate']);
			list($hour, $minute, $second) = explode(':', $row2['ltime']);
			$hour += ( $admin['t_offset_o'] == '+' ? $admin['t_offset'] : - $admin['t_offset'] );
			$row2['ldate'] = date('Y-m-d', mktime($hour, $minute, $second, $month, $day, $year));
			$row2['ltime'] = date('H:i:s', mktime($hour, $minute, $second, $month, $day, $year));
			$row['messages'][$row2['id']] = smart_unescape_array($row2);
		}
		$r[$row['listid']] = $row;
	}
}
*/



// fetch the scheduled campaigns
$so = new AC_Select();
$so->push("AND c.status = 1");
$so->push("AND c.type IN ('single', 'split', 'recurring', 'activerss')");
$so->push("AND c.userid IN ('$userids')");
$scheduled = campaign_select_array($so);

foreach ( $scheduled as $k => $v ) {
	$scheduled[$k]['lists'] = campaign_lists($v['id']);
	$scheduled[$k]['msg'] = ac_sql_select_row("
		SELECT
			*
		FROM
			#campaign_message c,
			#message m
		WHERE
			c.messageid = m.id
		AND
			c.campaignid = '$v[id]'
		LIMIT 0, 1
	");
}

?>
<xml>
<?php if ( count($queue) == 0 ) { ?>
	<queue />
<?php } else { ?>
	<queue>
<?php foreach ( $queue as $campaign ) { ?>
		<campaign>
			<id><?php echo $campaign['id']; ?></id>
			<mid><?php echo $campaign['msg']['messageid']; ?></mid>
			<subject><?php echo ( $campaign['msg']['subject'] != '' ? $campaign['msg']['subject'] : _a("No Subject") ); ?></subject>
			<percent><?php echo $campaign['nvs']; ?>%</percent>
			<sent><?php echo $campaign['send_amt']; ?></sent>
			<total><?php echo $campaign['total_amt']; ?></total>
			<transferred><?php echo $campaign['mail_transfer']; ?></transferred>
			<transfer><?php echo $campaign['percent_comp']; ?>%</transfer>
			<status><?php echo $campaign['status']; ?></status>
			<allowpause><?php echo (int)( $campaign['status'] == 2 ); ?></allowpause>
			<allowresume><?php echo (int)( $campaign['status'] == 3 ); ?></allowresume>
			<allowrequeue><?php echo (int)!$campaign['stop']; ?></allowrequeue>
			<started><?php echo $campaign['sdate']; ?></started>
			<updated><?php echo $campaign['ldate']; ?></updated>
<?php foreach ( $campaign['lists'] as $list ) { ?>
			<list>
				<id><?php echo $list['listid']; ?></id>
				<name><?php echo $list['name']; ?></name>
				<inqueue><?php /*echo $list['inqueue'];*/ ?></inqueue>
			</list>
<?php } ?>
		</campaign>
<?php } ?>
	</queue>
<?php } ?>


<?php if ( count($scheduled) == 0 ) { ?>
	<schedule />
<?php } else { ?>
	<schedule>
<?php foreach ( $scheduled as $campaign ) { ?>
		<campaign>
			<id><?php echo $campaign['id']; ?></id>
			<mid><?php echo $campaign['msg']['id']; ?></mid>
			<subject><?php echo ( $campaign['msg']['subject'] != '' ? $campaign['msg']['subject'] : _a("No Subject") ); ?></subject>
			<created><?php echo $campaign['cdate']; ?></created>
			<send><?php echo $campaign['sdate']; ?></send>
<?php foreach ( $campaign['lists'] as $list ) { ?>
			<list>
				<id><?php echo $list['listid']; ?></id>
				<name><?php echo $list['name']; ?></name>
				<scheduled><?php /*echo $list['scheduled'];*/ ?></scheduled>
			</list>
<?php } ?>
		</campaign>
<?php } ?>
	</schedule>
<?php } ?>
	<datetime><?php echo AC_CURRENTDATETIME; ?></datetime>
	<version><?php echo $site['version']; ?></version>
<?php if ( $action ) { ?>
	<action>
		<name><?php echo $action; ?></name>
		<status><?php echo $status; ?></status>
		<message><?php echo $message; ?></message>
	</action>
<?php } ?>
</xml>
