<?php

require_once ac_admin("functions/campaign.php");
//require_once ac_admin("functions/filter.php");
//require_once ac_admin("functions/message.php");
require_once ac_admin("functions/template.php");
require_once ac_global_classes("select.php");
require_once ac_global_classes("pagination.php");
class campaign_new_context extends ACP_Page {

	function campaign_new_context() {
		$this->pageTitle = _a("Create a New Campaign");
		//$this->sideTemplate = "side.message.htm";
		$this->ACP_Page();
	}

	function process(&$smarty) {
		$this->setTemplateData($smarty);

		if (!$this->admin["pg_message_add"] && !$this->admin["pg_message_edit"]) {
			$smarty->assign('content_template', 'noaccess.htm');
			return;
		}

		if ( list_get_cnt() == 0 ) {
			$smarty->assign('content_template', 'nolists.htm');
			return;
		}

		$smarty->assign("content_template", "campaign_new.htm");

		$so = new AC_Select();
		$so->select(array('t.id', 't.userid', 't.name', 't.subject', 't.format', 't.categoryid', 't.preview_mime'));
		$templates = template_select_array($so);
		$smarty->assign("templates", $templates);
		$smarty->assign("templatesCnt", count($templates));

		$recur_intervals = campaign_recur_intervals();
		$smarty->assign("recur_intervals", $recur_intervals);

		$mso = new AC_Select();
		$mso->push("AND m.hidden = 0");
		$mso->count();

		$messagecount = ac_sql_select_one(message_select_query($mso));
		$smarty->assign("messagecount", $messagecount);

		$smarty->assign("spamcheck", ( plugin_emailcheck() ? $this->site['serial'] : '' ));
		$smarty->assign("activerss", plugin_activerss());
		$smarty->assign("autoremind", plugin_autoremind());

		// get all current campaigns
		$so = new AC_Select();
		$so->push("AND (
			( c.type IN ('responder', 'reminder') AND c.status IN (1, 6) )
			OR
			( c.type IN ('single', 'recurring', 'split', 'activerss') AND c.status NOT IN (0, 1, 6, 7) )
		)"); // all of them!
		$so->orderby("c.sdate DESC, c.name"); // sort by sending date

		# Only use the last hundred.  We have clients with several hundred campaigns; showing
		# them all for link actions isn't going to be useful for them, and we have seen clients
		# where including all campaigns blows their PHP memory limit.

		$so->limit(100);
		$campaigns = campaign_select_array($so);
		$smarty->assign("campaigns", $campaigns);

		// global custom fields
		$fields = list_get_fields(array(), true); // no list id's, but global
		$smarty->assign("fields", $fields);

		// all custom fields
		$filter_fields = list_get_fields($this->admin['lists'], true); // ALL
		$smarty->assign("filter_fields", $filter_fields);
		#$smarty->assign("fields", $filter_fields);

		// preset message (coming from manage message page)
		$messageid = (int)ac_http_param('messageid');

		$campaignid = (int)ac_http_param('campaignid');

		// default campaign array (create new)
		$campaign = campaign_new();
		$campaign['mailer_log_file'] = $this->site['mailer_log_file'];

		$isEdit = false;
		$showAllMessages = false;

		if ( $campaignid > 0 ) {
			$row = campaign_select_row($campaignid);
			if ( $row ) {
				if ( !ac_str_instr('%UNSUBSCRIBELINK%', (string)$row['htmlunsubdata']) ) {
					$row['htmlunsubdata'] = _a('<div><a href="%UNSUBSCRIBELINK%">Click here</a> to unsubscribe from future mailings.</div>');
				}
				if ( !ac_str_instr('%UNSUBSCRIBELINK%', (string)$row['textunsubdata']) ) {
					$row['textunsubdata'] = _a('Click here to unsubscribe from future mailings: %UNSUBSCRIBELINK%');
				}
				// use this campaign
				$campaign = $row;
				//foreach ( $row as $k => $v ) $campaign[$k] = $v;
				// campaign info
				if ( in_array($row['status'], array(0, 1, 3, 6, 7)) and !ac_http_param('use') ) { // if not sending or completed
					// statuses that can be reused are : draft, scheduled, (while sending?) paused, stopped
					$campaign['id'] = $row['id']; // edit this campaign allowed
					$campaign['status'] = $row['status']; // reuse the same status
					if ( $row['status'] != 0 ) $isEdit = true;
				} else {
					$campaign['id'] = 0; // edit this campaign not allowed
					$campaign['status'] = 0; // set status to draft
				}
				$showAllMessages = true;

				if($campaign['status']==0 && $campaign['sdate']<AC_CURRENTDATETIME)
					$campaign['sdate'] = AC_CURRENTDATETIME;

				// lists+filter=step2
				$campaign['step'] = 2;
				if ( count($row['lists']) > 0 ) {
					if ( count($row['lists']) == 1 ) {
						$_SESSION['nla'] = $row['lists'][0]['id'];
					} else {
						$_SESSION['nla'] = explode('-', $row['listslist']);
					}
					if ( $row['filterid'] > 0 ) $campaign['filterid'] = $row['filterid'];
					$campaign['step'] = 3;
				}
				// message(s)=step3 (in case of splitting)
				if ( count($row['messages']) > 0 ) {
					if ( count($row['messages']) == 1 ) {
						$messageid = $row['messages'][0]['id'];
					} else {
						$messageid = explode('-', $row['messageslist']);
					}
					$campaign['step'] = 4;
				}
				// tlinks+treads+unsubaddon+options=step4
				/*
				if ( in_array($row['type'], array('single', 'recurring', 'split', 'activerss')) ) {
					if ( $campaign['sdate'] > $row['sdate'] and $row['status'] == 1 ) {
						// set date only if scheduled for future
						$campaign['sdate'] = $row['sdate'];
						$campaign['step'] = 5;
					}
				} elseif ( in_array($row['type'], array('responder', 'reminder')) ) {
					$campaign['step'] = 5;
				} else {//if ( $row['type'] == 'special' ) {
					//
				}
				*/
			}
		}

		// list filter
		$listfilter = ( isset($_SESSION['nla']) ? $_SESSION['nla'] : null );

		if(!isset($campaign['links']))
			$campaign['links'] = array();

		// assign all presets
		$smarty->assign('campaignid', $campaignid);
		$smarty->assign('campaign', $campaign);
		$smarty->assign('messageid', $messageid);
		$smarty->assign("listfilter", $listfilter);
		$smarty->assign("isEdit", $isEdit);
		$smarty->assign("showAllMessages", $showAllMessages);

		// default debugging
		$debugging = $campaign['mailer_log_file'];
		// custom debugging
		if ( ac_http_param_exists('debug') ) {
			$debugging = (int)ac_http_param('debug');
		}
		$smarty->assign("debugging", $debugging);

		$smarty->assign('isDemo', isset($GLOBALS['demoMode']));

		// message only stuff
		$smarty->assign("onsave", '');

		// separate list of filters by list
		$fso = new AC_Select();
		$fso->push("AND f.hidden = 0");
		$fso->orderby("f.name");
		$allfilters = filter_select_array($fso, null);
		$filters = array();
		foreach ( $allfilters as $row ) {
			$filterlists = ac_sql_select_list("SELECT listid FROM #filter_list WHERE filterid = '$row[id]'");
			foreach ( $filterlists as $v ) {
				$filters[$v][$row['id']] = $row;
			}
		}
		$smarty->assign("filters", $filters);
	}
}

?>

