<?php

require_once ac_admin("functions/list.php");
require_once ac_global_classes("select.php");
require_once ac_global_classes("pagination.php");
require_once ac_admin("functions/template.php");
class list_context extends ACP_Page {

	function list_context() {
		$this->pageTitle = _a("Lists");
		$this->ACP_Page();
	}

	function process(&$smarty) {

		$this->setTemplateData($smarty);

		$site = ac_site_get();
		$admin = ac_admin_get();

		if (!$this->admin["pg_list_add"] && !$this->admin["pg_list_edit"] && !$this->admin["pg_list_delete"]) {
			$smarty->assign('content_template', 'noaccess.htm');
			return;
		}

		$smarty->assign("content_template", "list.htm");
		$smarty->assign("side_content_template", "side.list.htm");
		$so = new AC_Select;
		$so->count();
		$so->greedy = true;
		$total = (int)ac_sql_select_one(list_select_query($so));
		$count = $total;

		$paginator = new Pagination($total, $count, $this->admin['lists_per_page'], 0, 'main.php?action=list');
		$paginator->allowLimitChange = true;
		$paginator->ajaxAction = 'list.list_select_array_paginator';
		$smarty->assign('paginator', $paginator);

		$sections = array(
			array("col" => "name", "label" => _a("List Names")),
			//array("col" => "from_name", "label" => _a("From Emails")),
			//array("col" => "from_email", "label" => _a("From Names")),
			//array("col" => "descript", "label" => _a("Descriptions")),
		);
		$smarty->assign("search_sections", $sections);

		$fields = list_get_fields(array(), true); // no list id's, but global
		$smarty->assign("fields", $fields);

		// get all groups
		$groups = group_get_all(0, "g.p_admin = 1");
		foreach ( $groups as $k => $v ) {
			$groups[$k]['admins'] = array();
			if ( ac_admin_ismaingroup() ) {
				$groups[$k]['admins'] = ac_sql_select_array("SELECT u.* FROM #user u, #user_group g WHERE u.id = g.userid AND g.groupid = '$k'");
			}
		}
		//dbg($groups);
		$smarty->assign('groupsList', $groups);
		$smarty->assign('groupsListCnt', count($groups));

		// get all bounces
		require_once(ac_admin('functions/bounce_management.php'));
		$bounces = bounce_management_select_array();
		//dbg($bounces);
		$smarty->assign('bouncesList', $bounces);
		$smarty->assign('bouncesListCnt', count($bounces));

		$so = new AC_Select();
		$so->select(array('t.id', 't.userid', 't.name', 't.subject', 't.format', 't.categoryid', 't.preview_mime'));
		$templates = template_select_array($so);
		$smarty->assign("templates", $templates);
		$smarty->assign("templatesCnt", count($templates));

		// get all confirmations
		require_once(ac_admin('functions/optinoptout.php'));
		$optsets = optinoptout_select_array();
		//dbg($optsets);
		$smarty->assign('optsetsList', $optsets);
		$smarty->assign('optsetsListCnt', count($optsets));

		// oauth for auto-sharing campaigns
		$pass = function_exists('curl_init') && function_exists('hash_hmac') && function_exists('json_decode') && (int)PHP_VERSION > 4;
		if ($pass) {
			$twitter_oauth = list_twitter_oauth_init();
			$twitter_oauth_request = list_twitter_oauth_getrequesttoken($twitter_oauth);
			$twitter_oauth_register_url = list_twitter_oauth_getregisterurl($twitter_oauth, $twitter_oauth_request);
			$twitter_oauth_token = "";
			$twitter_oauth_token_secret = "";
			if ( isset($twitter_oauth_request['oauth_token']) && isset($twitter_oauth_request['oauth_token_secret']) ) {
				$twitter_oauth_token = $twitter_oauth_request['oauth_token'];
				$twitter_oauth_token_secret = $twitter_oauth_request['oauth_token_secret'];
			}
			$smarty->assign('twitter_oauth_request_token', $twitter_oauth_token);
			$smarty->assign('twitter_oauth_request_token_secret', $twitter_oauth_token_secret);
			$smarty->assign('twitter_oauth_register_url', $twitter_oauth_register_url);
			if (ac_http_param_exists('facebook_logout') && ac_http_param('facebook_logout') != '') {
				$facebook_oauth = list_facebook_oauth_init();
				$facebook_session = list_facebook_oauth_getsession($facebook_oauth);
				ac_sql_query("UPDATE #list SET facebook_session = NULL WHERE id = '" . ac_http_param('facebook_logout') . "' LIMIT 1");
				$_SESSION['facebook_oauth_session'] = '';
			}
			else {
				$_SESSION['facebook_oauth_perms'] = ( ac_http_param_exists('perms') ) ? ac_http_param('perms') : '';
				$_SESSION['facebook_oauth_selected_profiles'] = ( ac_http_param_exists('selected_profiles') ) ? ac_http_param('selected_profiles') : '';
				$_SESSION['facebook_oauth_installed'] = ( ac_http_param_exists('installed') ) ? ac_http_param('installed') : '';
				// if the facebook session is set, and blank, check for it.
				// or if it's not set at all, check for it
				if (
					(isset($_SESSION['facebook_oauth_session']) && $_SESSION['facebook_oauth_session'] == '') ||
					!isset($_SESSION['facebook_oauth_session'])
				) {
					$_SESSION['facebook_oauth_session'] = ( ac_http_param_exists('session') ) ? ac_http_param('session') : '';
				}
			}
			// when coming back from facebook (after logging in or out), we could not use #form-1 in the URL (facebook does not like it), so we use &formid=1.
			// we then properly capture that, and redirect to #form-1.
			if ( ac_http_param_exists('formid') && ac_http_param('formid') != '' ) {
				ac_http_redirect($site["p_link"] . '/admin/main.php?action=list#form-' . ac_http_param('formid'));
			}
		}

		$smarty->assign('pass', $pass);
	}
}

?>