<?php

require_once ac_admin("functions/message.php");
require_once(ac_admin('functions/template.php'));
require_once ac_global_classes("select.php");
require_once ac_global_classes("pagination.php");
class message_context extends ACP_Page {

	function message_context() {
		$this->pageTitle = _a("Manage Messages");
		//$this->sideTemplate = "side.message.htm";
		$this->ACP_Page();
	}

	function process(&$smarty) {

		$this->setTemplateData($smarty);

		if (!$this->admin["pg_message_add"] && !$this->admin["pg_message_edit"] && !$this->admin["pg_message_delete"]) {
			$smarty->assign('content_template', 'noaccess.htm');
			return;
		}

		if ( list_get_cnt() == 0 ) {
			$smarty->assign('content_template', 'nolists.htm');
			return;
		}
		$smarty->assign("side_content_template", "side.campaign.htm");
		$smarty->assign("content_template", "message.htm");

		$so = new AC_Select;
		$so->push("AND m.hidden = 0");

		// list filter
		$filterArray = message_filter_post();
		$filter = $filterArray['filterid'];
		if ($filter > 0) {
			$conds = ac_sql_select_one("SELECT conds FROM #section_filter WHERE id = '$filter' AND userid = '{$this->admin['id']}' AND sectionid = 'message'");
			$so->push($conds);
		}
		$smarty->assign("filterid", $filter);
		$smarty->assign("listfilter", ( isset($_SESSION['nla']) ? $_SESSION['nla'] : null ));

		// get count
		$so->count();
		$total = (int)ac_sql_select_one(message_select_query($so));
		$count = $total;

		$paginator = new Pagination($total, $count, 20, 0, 'main.php?action=message');
		$paginator->allowLimitChange = true;
		$paginator->ajaxAction = 'message.message_select_array_paginator';
		$smarty->assign('paginator', $paginator);

		$sections = array(
			array("col" => "subject", "label" => _a("Message Subject")),
			array("col" => "fromemail", "label" => _a("From Email")),
			array("col" => "fromname", "label" => _a("From Name")),
			array("col" => "_content", "label" => _a("Content")),
			array("col" => "reply2", "label" => _a("Reply-To")),
		);
		$smarty->assign("search_sections", $sections);

		$fields = list_get_fields(array(), true); // no list id's, but global
		$smarty->assign("fields", $fields);

		$so = new AC_Select();
		$so->select(array('t.id', 't.userid', 't.name', 't.subject', 't.format', 't.categoryid', 't.preview_mime'));
		$templates = template_select_array($so);
		$smarty->assign("templates", $templates);
		$smarty->assign("templatesCnt", count($templates));

		$mso = new AC_Select();
		$mso->push("AND m.hidden = 0");
		$mso->count();

		$messagecount = ac_sql_select_one(message_select_query($mso));
		$smarty->assign("messagecount", $messagecount);

		// on save switch (currently supported actions: close, send)
		$onsave = (string)ac_http_param('onsave');
		$smarty->assign('onsave', $onsave);

		$smarty->assign("spamcheck", ( plugin_emailcheck() ? $this->site['serial'] : '' ));

	}
}

?>
