<?php

require_once ac_global_classes("select.php");
require_once ac_global_functions("group.php");

class public_context extends ACP_Page {

	function public_context() {
		$this->pageTitle = _a("Public Section");
		$this->sideTemplate = "";
		$this->ACP_Page();
		$this->admin = $GLOBALS["admin"];
	}

	function process(&$smarty) {
		$this->setTemplateData($smarty);
		if ($this->site["general_public"] != 1)
			return ac_smarty_noaccess($smarty, $this);

		$seo = $this->site['general_url_rewrite'];
		$smarty->assign("seo", $seo);

		$plink = ac_site_plink();
		$links = array(
			'public' => $plink,
			'user'   => $plink . ( $seo ? '/user/'  : '/?ul=' ),
			'group'  => $plink . ( $seo ? '/group/' : '/?gl=' ),
			'list'   => $plink . ( $seo ? '/list/'  : '/?nl=' )
		);
		$smarty->assign("links", $links);

		// if not in admin group, add group id right away
		$groupid = key($this->admin['groups']);
		$smarty->assign("groupid", $groupid);
		$maingroup = ac_admin_ismaingroup();
		$smarty->assign("maingroup", $maingroup);

		if ( !$maingroup ) $links['group'] .= $groupid;


		// fetch all groups for main admins
		$groups = array();
		if ( ac_admin_ismaingroup() ) $groups = ac_group_select_array();
		$smarty->assign("groups", $groups);

		$lists = list_get_all(true, true);
		$smarty->assign("lists", $lists);

		$smarty->assign("content_template", "public.htm");
	}
}

?>