<?php

require_once ac_admin("functions/service.php");
require_once ac_global_classes("select.php");
require_once ac_global_classes("pagination.php");
class service_context extends ACP_Page {

	function service_context() {
		$this->pageTitle = _a("External Services");
		$this->sideTemplate = "";
		$this->ACP_Page();
	}

	function process(&$smarty) {
		$this->setTemplateData($smarty);
		
		if ( !ac_admin_ismaingroup() ) {
			ac_smarty_noaccess($smarty);
			return;
		}
		
		$smarty->assign("content_template", "service.htm");

		$so = new AC_Select;
		$so->count();
		$total = (int)ac_sql_select_one(service_select_query($so));
		$count = $total;

		$paginator = new Pagination($total, $count, 20, 0, 'main.php?action=service');
		$paginator->allowLimitChange = true;
		$paginator->ajaxAction = 'service.service_select_array_paginator';
		$smarty->assign('paginator', $paginator);

	}
}

?>
