<?php

require_once ac_admin("functions/settings.php");
require_once ac_admin("functions/feedbackloop.php");
require_once ac_global_classes("select.php");
require_once ac_global_classes("pagination.php");
require_once ac_global_functions('ajax.php');
require_once ac_global_functions("group.php");

class settings_context extends ACP_Page {

	function settings_context() {
		$this->pageTitle = _a("Settings");
		$this->sideTemplate = "side.settings.htm";
		$this->ACP_Page();
	}

	function process(&$smarty) {

		// hosted check for cnames
		if ( isset($GLOBALS['_hosted_account']) ) {
			$thisurl = ac_http_geturl();
			if ( $GLOBALS["_hosted_cname"] != "" && ac_str_instr($GLOBALS['_hosted_cname'], $thisurl) && $GLOBALS['_hosted_cname'] != $_SESSION[$GLOBALS["domain"]]["account"] ) {
				$thisurl = str_replace($GLOBALS['_hosted_cname'], $_SESSION[$GLOBALS["domain"]]["account"], $thisurl);
				ac_http_redirect($thisurl);
			}
		}

		$this->setTemplateData($smarty);

		if ( !ac_admin_ismaingroup() ) {
			$smarty->assign('content_template', 'noaccess.htm');
			return;
		}

		//$smarty->assign("side_content_template", "side.subscriber.htm");
		$site = ac_site_get();

		$smarty->assign("zones", tz_box());

		$smarty->assign("rwCheck", ac_php_rewrite_check());

		$smarty->assign("__planid", "");
		if (isset($GLOBALS["domain"]) && isset($_SESSION[$GLOBALS["domain"]]["_hosted_planid"]))
			$smarty->assign("__planid", $_SESSION[$GLOBALS["domain"]]["_hosted_planid"]);

		$URI = ( isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : $_SERVER['PHP_SELF'] );
		$URI = substr($URI, 0, strpos($URI, '/admin/main.php'));
		$smarty->assign("URI", $URI);
		$smarty->assign("htaccess", ac_base('.htaccess'));

		$mailconnections = array();
		$sql = ac_sql_query("SELECT * FROM #mailer ORDER BY corder");
		while ( $row = mysql_fetch_assoc($sql) ) {
			$row['pass'] = ( $row['pass'] == '' ? '' : base64_decode($row['pass']) ); // decoding mail password
			$row['groups'] = ac_sql_select_box_array("SELECT groupid, groupid FROM #group_mailer WHERE mailerid = '$row[id]'");
			$row['groupslist'] = implode(',', $row['groups']);
			$mailconnections[$row['id']] = $row;
		}
		$smarty->assign("mailconnections", $mailconnections);
		$smarty->assign("mailconnectionscnt", count($mailconnections));


		// what is our upload limit?
		$smarty->assign('uploadLimit', ini_get('upload_max_filesize'));
		// what is our post limit?
		$smarty->assign('postLimit', ini_get('post_max_size'));
/*
		// addons
		$smarty->assign("emailcheck", plugin_emailcheck());
		$smarty->assign("activerss" , plugin_activerss());
		$smarty->assign("autoremind" , plugin_autoremind());
		$smarty->assign("flashforms" , plugin_flashforms());
*/
		$smarty->assign("hash" , md5($this->site['serial']));

		// hosted vars
		$hosted_cname = '';
		$hosted_domain = '';
		if ( isset($GLOBALS['_hosted_account']) ) {
			$hosted_cname = $GLOBALS['_hosted_cname'];
			$hosted_domain = isset($_SESSION[$GLOBALS['domain']]['account']) ? $_SESSION[$GLOBALS['domain']]['account'] : $GLOBALS['domain'];
		}
		$smarty->assign('hosted_cname', $hosted_cname);
		$smarty->assign('hosted_domain', $hosted_domain);

		$so = new AC_Select;
		$so->count();
		$total = (int)ac_sql_select_one(ac_group_select_query($so));
		$count = $total;

		$paginator_abuse = new Pagination($total, $count, 20, 0, 'main.php?action=group');
		$paginator_abuse->ajaxAction = 'abuse.abuse_select_array_paginator';
		$smarty->assign('paginator_abuse', $paginator_abuse);

		$so = new AC_Select;
		$so->count();
		$total = (int)ac_sql_select_one(feedbackloop_select_query($so));
		//$count = $total;
		$smarty->assign('fblcnt', $total);

		$so->orderby("f.tstamp DESC");
		$so->limit("0, 50");
		$feedbackloops = ac_sql_select_array(feedbackloop_select_query($so));
		$smarty->assign('feedbackloops', $feedbackloops);

		// get groups
		$so = new AC_Select;
		//$so->push("AND id > 1");				# Exclude the Visitors group
		$so->push("AND p_admin = 1");				# Exclude the non-admin groups
		$so->orderby("title");
		$groups = ac_group_select_array($so);
		$smarty->assign('groupsList', $groups);

		ac_smarty_submitted($smarty, $this);
		$smarty->assign("content_template", "settings.htm");
	}

	function formProcess(&$smarty) {
		// prepare data
		$update = array();

		if ( isset($_POST["general_url_rewrite"]) ) {
			$rwCheck = ac_php_rewrite_check();
			if ( !$rwCheck['apache'] ) {
				return ac_ajax_api_result(0, _a("You cannot enable the search-friendly URL feature on non-Apache web servers"));
			}
			if ( !$rwCheck['configured'] ) {
				$content = (string)ac_file_get(ac_base('example.htaccess'));
				$appURI = ( isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : $_SERVER['PHP_SELF'] );
				$appURI = substr($appURI, 0, strpos($appURI, '/admin/main.php'));
				$content = str_replace('/12allURI', $appURI, $content);
				if ( $rwCheck['htaccess'] ) {
					$content = ac_file_get(ac_base('.htaccess')) . "\n\n\n" . $content;
				}
				$created = @ac_file_put(ac_base('.htaccess'), $content);
				if ( !$created ) {
					// create
					return ac_ajax_api_result(0, _a("The system could not create/update your .htaccess file. Please configure the .htaccess file first before saving this setting."));
				}
			}
		}

		# General

		#$update["site_name"]                    = $_POST["site_name"];
		$update["p_link"]                        = $_POST["p_link"];
		$update["emfrom"]                        = $_POST["emfrom"];
		$update["general_maint"]                 = intval(isset($_POST["general_maint"]));
		$update["general_maint_message"]         = ( isset($_POST["general_maint"]) ) ? $_POST["general_maint_message"] : "";
		#$update["general_passprotect"]          = intval(isset($_POST["general_passprotect"]));
		$update["general_allow_rss"]             = intval(isset($_POST["general_allow_rss"]));

		# Admin

		if (isset($_POST["maxuploadfilesize"]))
		$update["maxuploadfilesize"]             = intval($_POST["maxuploadfilesize"]);

		# Public

		$update["general_url_rewrite"]           = intval(isset($_POST["public_url_rewrite"]) || isset($GLOBALS['_hosted_account']) );
		$update["general_public"]              	 = intval(!isset($_POST["general_public"]));

		# Local

		$update["lang"]                          = $_POST["lang"];
		$update["local_zoneid"]                  = $_POST["local_zoneid"];
		$update["dateformat"]                    = $_POST["dateformat"];
		$update["timeformat"]                    = $_POST["timeformat"];
		$update["datetimeformat"]                = $_POST["datetimeformat"];
		if (isset($_POST["sdord"]))
		$update["sdord"]                         = $_POST["sdord"];
		$update["mail_abuse"]              	     = intval(isset($_POST["mail_abuse"]) || isset($GLOBALS['_hosted_account']));

		# Local -- time offsets.
		$offset = tz_offset($_POST["local_zoneid"]);
		$update["t_offset_o"]                    = ($offset >= 0) ? "+" : "-";
		$update["t_offset"]                      = tz_hours($offset);
		$update["t_offset_min"]                  = tz_minutes($offset, $update["t_offset"]);

		if ( isset($GLOBALS['_hosted_account']) ) {
			$update["onbehalfof"]                = (int)ac_http_param_exists('onbehalfof');
		}

		$r = ac_sql_update('#backend', $update);

		if ( isset($GLOBALS['_hosted_account']) ) {
			$hosted_cname = (string)ac_http_param('site_cname');
			$_SESSION[$GLOBALS["domain"]]["cname"] =
			$GLOBALS['_hosted_cname'] = $hosted_cname;
			if ( file_exists(ac_base('tools/setcname.php')) ) {
				$act = ( isset($_SESSION[$GLOBALS["domain"]]["account"]) ? $_SESSION[$GLOBALS["domain"]]["account"] : $GLOBALS['_hosted_account'] );
				ac_http_spawn($this->site['p_link'] . '/tools/setcname.php?domain=' . $act . '&cname=' . $hosted_cname);
			}
			//dbg($GLOBALS['_hosted_account'] . "\n" . $_SESSION[$GLOBALS["domain"]]["account"] . "\n" . $hosted_cname);
			$smarty->assign('hosted_cname', $hosted_cname);
		}

		if ($r) {
			ac_session_drop_cache();
			$GLOBALS['site'] = ac_site_unsafe();
			$smarty->assign("site", $GLOBALS["site"]);
			return ac_ajax_api_result(1, _a("Settings Saved."));
		}
		return ac_ajax_api_result(0, _a("Settings could not be saved. " . ac_sql_error()));
	}
}

?>
