<?PHP

require_once(ac_global_functions('rss.php'));
require_once(ac_global_classes('page.php'));
require_once ac_admin("functions/subscriber.php");
require_once ac_admin("functions/list.php");
require_once ac_admin("functions/group.php");
require_once ac_admin("functions/campaign.select.php");

class startup_context extends ACP_Page {



	// constructor
	function startup_context() {
		$this->pageTitle = _a("Startup Page");
		parent::ACP_Page();
		// get parameters
		$this->getParams();
	}




	// try to catch parameter from post, get or session
	function getParams() {
	}





	function process(&$smarty) {
 		$this->setTemplateData($smarty);

 		$groupids = implode(",", $this->admin["groups"]);
 		$group_users = group_get_users($this->admin["groups"]);

 		// Lists that group is a part of
		$group_lists_status = ( count($this->admin["lists"]) > 0 ) ? 0 : 1;

		$group_listids = implode("','", $this->admin["lists"]);

		// Pull subscribers that are part of this user's group(s) lists
		$group_lists_subscribers = ac_sql_select_one("SELECT COUNT(*) FROM #subscriber_list WHERE listid IN ('$group_listids')");
		$group_lists_subscribers_status = ( $group_lists_subscribers > 0 ) ? 0 : 1;

		// Pull subscription forms that are part of user's group(s) lists
		$group_lists_forms = ac_sql_select_one("SELECT COUNT(*) FROM #form_list WHERE listid IN ('$group_listids')");
		$group_lists_forms_status = ( $group_lists_forms > 0 ) ? 0 : 1;

		// Pull campaigns that are part of user's group(s) lists
		$group_lists_campaigns = ac_sql_select_one("SELECT COUNT(*) FROM #campaign_list WHERE listid IN ('$group_listids')");
		$group_lists_campaigns_status = ( $group_lists_campaigns > 0 ) ? 0 : 1;

		$group_reports_link_status = ($group_lists_campaigns > 0 && $this->admin["pg_startup_reports"]) ? 0 : 1;

		// Add up all the 0 and 1 values. If they're all 0, that means they are all dimmed
		// If just one is 1, then we have to show the entire div still
		$group_all = $group_lists_status + $group_lists_subscribers_status + $group_lists_forms_status + $group_lists_campaigns_status + $group_reports_link_status;

		// 0 = hidden, 1 = show, 2 = hidden no matter what (they clicked the Close link)
		if ($group_all == 0) {
			// Flip it so it hides, if they're all dimmed
			$sql = ac_sql_update("#group", array("pg_startup_gettingstarted" => 0), "id IN ($groupids) AND pg_startup_gettingstarted = 1");
		}
		else {
			// Or if they're not all dimmed, flip it so it shows
			$sql = ac_sql_update("#group", array("pg_startup_gettingstarted" => 1), "id IN ($groupids) AND pg_startup_gettingstarted = 0");
		}

		$help_articles = array();
		$rss = ac_rss_fetch('http://www.mykbsite.com/email-marketing/index.php?rss=1&filter=mostviewed', 86400);
		if ( $rss and isset($rss['rss']) and isset($rss['rss']->items) ) {
			$help_articles = array_slice($rss['rss']->items, 0, 10);
		}

		# Check on the startup page if innodb memory is too low.
		if (!ac_sql_compare("innodb_buffer_pool_size", 1024*1024*64) && ac_sql_supports_engine("InnoDB") && $group_lists_subscribers > 50000)
			$smarty->assign("innodb_lowmem", 64);

		# Check on the startup page if htaccess is being used
		if(isset($_SERVER['PHP_AUTH_USER']))
			$smarty->assign("httpauth_warning", 1);

		$smarty->assign('groupids', $groupids);
		$smarty->assign('group_lists_status', $group_lists_status);
		$smarty->assign('group_lists_subscribers_status', $group_lists_subscribers_status);
		$smarty->assign('group_lists_forms_status', $group_lists_forms_status);
		$smarty->assign('group_lists_campaigns_status', $group_lists_campaigns_status);
		$smarty->assign('group_reports_link_status', $group_reports_link_status);
		$smarty->assign('help_articles', $help_articles);
		$smarty->assign("isWindows", strtoupper(substr(PHP_OS, 0, 3)) === 'WIN');
		$smarty->assign('content_template', 'startup.htm');
	}
}

?>
