<?PHP

/*
 *
 */

require_once(ac_admin('functions/subscriber_import.php'));
require_once(ac_global_functions('import.php'));

class subscriber_import_context extends ACP_Page {

	var $configured = false;
	var $cfg = array('lists' => null, 'status' => 0, 'columns' => array());

	var $cfields = array();

	// constructor
	function subscriber_import_context() {
		$this->ACP_Page();
		$this->pageTitle = _a("Subscriber Import Tool");
		$this->configured = false;
	}

	function process(&$smarty) {
		$this->setTemplateData($smarty);

		$canImportSubscriber = $this->admin['pg_subscriber_import'];
		if ( !isset($GLOBALS['_hosted_account']) ) {
			$canImportSubscriber = $canImportSubscriber && withinlimits('subscriber', limit_count($this->admin, 'subscriber') + 1);
		}

		if ( !$canImportSubscriber ) {
			$smarty->assign('content_template', 'noaccess.htm');
			return;
		}

		if ( list_get_cnt() == 0 ) {
			$smarty->assign('content_template', 'nolists.htm');
			return;
		}

		// cleanup
		if ( (int)ac_sql_select_one('=COUNT(*)', '#subscriber_import') > 100000 ) {
			ac_sql_query("TRUNCATE TABLE #subscriber_import");
		} else {
			ac_sql_delete('#subscriber_import', "`tstamp` < SUBDATE(NOW(), INTERVAL 1 DAY)");
		}

		// check if form is submitted
		ac_smarty_submitted($smarty, $this);

		// get all lists
		$lists = list_get_all();
		$smarty->assign("lists", $lists);

		$require_name = false;
		if ( $this->cfg['lists'] ) {
			$listslist = implode("', '", $this->cfg['lists']);
			$require_name = (bool)ac_sql_select_one('=SUM(require_name)', '#list', "id IN ('$listslist')");
		}
		$smarty->assign("require_name", $require_name);

		// get all autoresponders
		$so = new AC_Select();
		$responders = responder_select_bylist($so, ( $this->cfg['lists'] ? implode(',', $this->cfg['lists']) : null ));
		$smarty->assign("responders", $responders);

		// did he send any campaigns in the past (needed for "send last message")
		$campaigns_sent = (int)ac_sql_select_one('=COUNT(*)', '#campaign', "status != 0 AND cdate < NOW()");
		$smarty->assign("campaigns_sent", $campaigns_sent);

		$smarty->assign('fields', ac_ihook('ac_import_fields', $this->cfg['lists'], $this->cfg['status']));
		$smarty->assign('cfields', $this->cfields);
        $smarty->assign('cfield_types', ac_custom_fields_types());

		// step 1 completed
		$smarty->assign("configured", $this->configured);
		$smarty->assign("config", $this->cfg);

		$smarty->assign("curl", function_exists('curl_init'));
		// array of all external sources, and whether or not they are supported
		$external_sources = subscriber_import_external_sources();
		// array of all server requirements for external sources, and whether or not they are enabled for this server
		$external_sources_check = subscriber_import_external_sources(true);
		$external_sources_supported = $external_sources_check_supported = 0;
		foreach ($external_sources as $source) $external_sources_supported += (int)$source["supported"];
		foreach ($external_sources_check as $source) $external_sources_check_supported += (int)$source["supported"];
		if ( $external_sources_check_supported < count($external_sources_check) ) {
			$smarty->assign("all_external_sources_supported", 0);
		}
		else {
			$smarty->assign("all_external_sources_supported", 1);
		}
		$smarty->assign("external_sources", $external_sources);
		$smarty->assign("external_sources_supported", $external_sources_supported);
		$smarty->assign("external_sources_check", $external_sources_check);

		$maxfilesize = @ini_get("upload_max_filesize");
		$smarty->assign("maxfilesize", $maxfilesize);

		$smarty->assign("content_template", "subscriber_import.htm");
		$smarty->assign("side_content_template", "side.subscriber.htm");
	}

	function formProcess(&$smarty) {
		// result is 0 if rows are not uploaded
		$r = array('status' => 0, 'section' => 'generic', 'message' => _a('Import '));
		$this->cfg['lists'] = ac_http_param('into');
		if ( !is_array($this->cfg['lists']) ) {
			$this->cfg['lists'] = null;
		} else {
			$this->cfg['lists'] = array_diff(array_map('intval', $this->cfg['lists']), array(0));
		}
		if ( !$this->cfg['lists'] ) {
			$r['message'] = _a('Lists not selected.');
			return $r;
		}
		$this->cfg['status'] = (int)ac_http_param('status');

		$this->cfg['update'] = (int)ac_http_param_exists('update');
		$this->cfg['skipbounced'] = (int)ac_http_param_exists('skipbounced');
		$this->cfg['sendlast'] = (int)ac_http_param_exists('sendlast');
		$this->cfg['sendresponders'] = (int)ac_http_param_exists('sendresponders');
		$this->cfg['sentresponders'] = (int)ac_http_param_exists('sentresponders');

		$this->cfg['from'] = trim((string)ac_http_param('from'));
		if ( !in_array($this->cfg['from'], array('file', 'text', 'external')) ) {
			$this->cfg['from'] = 'text';
		}

		/* handle file upload / text parsing / external service connection here */
		$path = ac_cache_dir() . "/";
		$charset = _i18n("utf-8");
		$this->cfg['columns'] = array();

		$fileiscsv = false;

		if ( $this->cfg['from'] == 'file' ) {
			// handle file upload
			if ( is_array($_FILES['file']['tmp_name']) ) {
				$r['message'] = _a('It seems like you tried to upload multiple files. You can import only one file at a time.');
				return $r;
			}
			if ( $_FILES['file']['error'] ) {
				if ($_FILES['file']['error'] == UPLOAD_ERR_INI_SIZE) {
					$r['message'] = sprintf(_a("The file you've uploaded is too large for the server to process; it must be less than %d megabyte(s).", @ini_get("upload_max_filesize")));
					$r['section'] = "importfrom_file";
				} else {
					$r['message'] = _a('There was an error while uploading your file.');
				}
				return $r;
			}
			if ( !file_exists($_FILES['file']['tmp_name']) ) {
				$r['message'] = _a('The uploaded file can not be imported. Please contact support for details.');
				return $r;
			}

			$file_extension = explode('.', $_FILES['file']['name']);
			$file_extension = strtolower($file_extension[ count($file_extension) - 1 ]);

			// prevent PHP file uploads
			if ( substr($file_extension, 0, 3) == 'php' || $_FILES['file']['type'] == 'application/x-httpd-php' ) {
				$r['message'] = _a('You cannot upload PHP files.');
				$r['section'] = "importfrom_file";
				return $r;
			}

			if ( in_array($file_extension, array('xls', 'xlsm', 'xlsb')) ) {
				$r['message'] = _a('We were unable to read that file. Please save that file as a CSV (comma separated) file. You can do so by going to File > Save As and choosing CSV as the file type.');
				$r['section'] = "importfrom_file";
				return $r;
			}
			elseif ($file_extension == 'xlsx') {
				$file_content = ac_file_upload_read($_FILES['file']['type'], $_FILES['file']['tmp_name'], ac_file_get($_FILES['file']['tmp_name']), "xlsx", "csv");
				if ( is_array($file_content) && isset($file_content['error']) && $file_content['error'] ) {
					$r['section'] = "importfrom_file";
					if ( isset($GLOBALS['_hosted_account']) and !class_exists('ZipArchive') || !function_exists('simplexml_load_string') ) {
						$r['message'] = _a('We were unable to read that file. Please save that file as a CSV (comma separated) file. You can do so by going to File > Save As and choosing CSV as the file type.');
					} else {
						$r['message'] = $file_content['error'];
					}
					return $r;
				}
				else {
					$text = $file_content;
				}
			}
			/*
			elseif ($file_extension == 'vcf') {
				require_once(ac_global_classes('vcard.php'));
				require_once(ac_global_functions('vcard.php'));
				$lines = file($_FILES['file']['tmp_name']);
				$card = parse_vcards($lines);
				foreach ($card as $entry) {
					dbg($entry,1);
					$entry = print_vcard($entry, array());
					//dbg($entry,1);
				}
				dbg('stop');
			}
			*/
			else {
				$fileiscsv = true;
				$text = (string)@file_get_contents($_FILES['file']['tmp_name']);
			}
			if ( !$text ) {
				$r['message'] = _a('The uploaded file seems to be empty, or could not be read. Please verify that the file is in CSV format.');
				$r['section'] = "importfrom_file";
				return $r;
			}
		} elseif ( $this->cfg['from'] == 'text' ) {
			// handle text parsing
			$text = trim((string)ac_http_param('text'));
			$this->cfg['from'] = 'file';
		} elseif ( $this->cfg['from'] == 'external' ) {
			// handle external service connection test
			$res = subscriber_import_external($this->cfg, $_POST);
			if ( !$res['succeeded'] ) {
				$r['message'] = $res['message'];
				return $r;
			}
			$text = $res['data'];
			$charset = 'utf-8';
		}
		// they save the output to a temp file
		if ( !$text && $this->cfg['from'] != 'file' ) {
			$r['message'] = _a('You did not enter any data into a text box. Please add data first...');
			return $r;
		}

		if ($text) {
			//$r['delimiter_file'] = $delimiter = (string)ac_http_param("delimiter_text");
			$r['delimiter_file'] = ac_import_delimiter_guess(substr($text, 0, 1000));
			unset($_POST['text']);
			//$text = ac_utf_conv("utf-8", _i18n("utf-8"), $text);
			$text = ac_utf_conv($charset, "utf-8", trim($text));

			if (isset($_FILES['file'])) {
				$filename = 'csvimport-' . $this->admin['id'] . sprintf('-%s.csv', md5($_FILES['file']['name']));
			} else {
				$filename = 'csvimport-' . $this->admin['id'] . '-tmpfile.csv';
			}

			if ( !@file_put_contents($path . $filename, $text) ) {
				$r['message'] = _a('Could not save the content to import.');
				return $r;
			}

			// do stuff with $text (data) string variable
			// get array from CSV file
			$csv = ac_import_csv2array($text, $r['delimiter_file']);
			unset($text);
			// get fields
			$this->cfg['columns'] = ac_import_columns($csv);
			$this->cfg['import_file'] = $filename;
			// save rows count
			$this->cfg['rows'] = count($csv);
			unset($csv);
			if ( !count($this->cfg['columns']) ) {
				$r['message'] = _a('No columns could be matched. Please try using different settings.');
				return $r;
			}
		} else {
			# We got here because we uploaded a csv file; let's move it to the right location.
			$filename = 'csvimport-' . $this->admin['id'] . '-' . md5($_FILES['file']['name']) . '.csv';
			$this->cfg['import_file'] = $filename;

			move_uploaded_file($_FILES['file']['tmp_name'], $path . $filename);
			$fp = @fopen($path . $filename, "r");
			$this->cfg = array_merge($this->cfg, subscriber_import_fileinfo($fp));
			$this->cfg['rows'] = $this->cfg['lines'];
			fclose($fp);
		}

		// get custom fields
		$this->cfields = list_get_fields($this->cfg['lists'], true);
		// count required fields
		$required = 1; // email is required
		// 2do: check if any list requires name, then increment
		$require_name = false;
		if ( $require_name ) $required++;
		foreach ( $this->cfields as $row ) {
			if ( $row['req'] ) $required++;
		}
		if ( count($this->cfg['columns']) < $required ) {
			$r['message'] = sprintf(_a('The data  does not have enough columns to complete the import. It needs to have at least %d columns.'), $required);
			return $r;
		}

		$this->cfg['valid'] = ( isset($GLOBALS['_hosted_account']) || withinlimits('subscriber', limit_count($this->admin, 'subscriber') + $this->cfg['rows']) );

		$this->configured = true;

		$r['status'] = true;
		$r['message'] = _a('Your content was successfully parsed.');

		$_SESSION['subscriber_importer'] = $this->cfg;
		return $r;
	}

}

?>