<?php
/**
 * This file defines (or reads) application settings in regards to ac_global library
 * It should be included first before engine file
 * It is designed to be included more than once
 * For some uses, it needs to be loaded again
 */


// application folder (usualy public interface), absolute path
$GLOBALS['ac_app_path'] = dirname(dirname(dirname(__FILE__)));  // out of functions and admin

// define ac_global folder path (so they can change it in engine if needed) ;-)
if ( !isset($GLOBALS['ac_library_path']) ) {
	$GLOBALS['ac_library_path'] = $GLOBALS['ac_app_path'] . '/ac_global';
}

if (!isset($_SERVER['REQUEST_URI'])) {
	if (!isset($_SERVER["QUERY_STRING"]))	# This is bad.
		$_SERVER["REQUEST_URI"] = $_SERVER["PHP_SELF"];
	else
		$_SERVER['REQUEST_URI'] = $_SERVER['PHP_SELF'] . '?' . $_SERVER['QUERY_STRING'];
}

// define ac_global folder path (so they can change it in engine if needed) ;-)
if ( !isset($GLOBALS['ac_library_url']) and isset($_SERVER['REQUEST_URI']) ) {
	$uri = preg_replace('/(\?.*)/', '', $_SERVER['REQUEST_URI']);
	$libPath = str_replace('\\', '/', $GLOBALS['ac_library_path']);
	$prodName = basename($GLOBALS['ac_app_path']);
	if ( strpos($uri, "/$prodName/") !== false ) {
		$uriRoot = preg_replace('/(.*)(\/' . preg_quote($prodName, '/') . ')(\/.*)/', '$1$2', $uri);
	} else {
		$uriRoot = '';
	}
	$GLOBALS['ac_library_url'] = $uriRoot . '/ac_global';
	if ( $GLOBALS['ac_library_path'] != $GLOBALS['ac_app_path'] . '/ac_global' ) {
		// completely different ac_global URL, figure it out here
	}
	//$docRoot = str_replace('\\', '/', $GLOBALS['ac_app_path']);
	//$docRoot = preg_replace('/(\/' . preg_quote($prodName, '/') . '.*)/', '', $docRoot);
	//$GLOBALS['ac_library_url'] = substr($libPath, strlen($docRoot));
}

// define database prefix (so they can change it in engine if needed) ;-)
if ( !isset($GLOBALS['ac_prefix_use']) ) {
	$GLOBALS['ac_prefix_use'] = 'em_';
}


// full application name
$GLOBALS['ac_app_name'] = 'Email Marketing Software';

// internal application id
$GLOBALS['ac_app_id'] = '12all';

$GLOBALS['ac_editor_rootpath'] = "images/" . ( isset($GLOBALS['_hosted_account']) ? $GLOBALS['_hosted_account'] . '/' : '' ) . "__USER__";

// if our database uses UTF-8 as its encoding
$GLOBALS['ac_app_utf8'] = true;

// current version of the application
include(dirname(__FILE__) . '/versioning.php');
$GLOBALS['ac_app_version'] = $thisVersion;

// current version of the ac_global library soon?
$GLOBALS['ac_library_version'] = '0.9.9';


/*
	allowed ac_global contexts
*/

// for public side
$GLOBALS['ac_context_whitelist'] = array(
);

// for admin side
$GLOBALS['ac_context_whitelist_admin'] = array(
	'about',
	'cron',
	'errorslog',
	'group',
	'loginsource',
	'processes',
	'sync',
	'user',
	'widget'
);


$GLOBALS['ac_cron_protected'] = 9;

// branding variable will get set after arrays are initialized
if ( isset($GLOBALS['admin']) ) {
	$GLOBALS['ac_branding_array'] =& $GLOBALS['admin'];
}

// branding array
$GLOBALS['ac_branding_table'] = 'branding';


// sending options: table and fields in it
$GLOBALS['ac_mail_engine'] = ( isset($GLOBALS['useOLDengine']) ? 'mailer' : 'swift' ); // since we let them tweak it in engine, it on the top of function_global.php we change this if needed
$GLOBALS['ac_mail_table'] = 'mailer';

// database sync options: table
$GLOBALS['ac_sync_table'] = 'sync';


// side menus
$GLOBALS['ac_sidemenu_settings'] = '';

// folders that must be writable
$GLOBALS['ac_writables'] = array(
	dirname(dirname(__FILE__)) . '/cache/admin',
	dirname(dirname(__FILE__)) . '/images',
);

// minimum requirements
$GLOBALS['ac_requirements'] = array(
	'php' => '4.3',
	'mysql' => '4.1'
);

// needed functions
$GLOBALS['ac_functions'] = array(
	//'mail'
);

if (!defined("LANGFILES_UTF8"))
	define("LANGFILES_UTF8", 1);

if ( !defined("AC_IMPORT_LOGTABLE") ) define("AC_IMPORT_LOGTABLE", '#subscriber_import');
if ( !defined("AC_SYNC_LOGTABLE"  ) ) define("AC_SYNC_LOGTABLE"  , '#subscriber_import');

// we have our own swift/php mailers here
//if ( !defined('SWIFT_ABS_PATH') ) define('SWIFT_ABS_PATH', $GLOBALS['ac_library_path'] . '/swiftmailer/php' . (int)PHP_VERSION);
if ( !defined('SWIFT_ABS_PATH') ) define('SWIFT_ABS_PATH', $GLOBALS['ac_library_path'] . '/swiftmailer/php4');
//if ( !defined('SWIFT_ABS_PATH') ) define('SWIFT_ABS_PATH', dirname(__FILE__) . '/mailer');
if ( !defined('MAILER_ABS_PATH') ) define('MAILER_ABS_PATH', dirname(__FILE__) . '/sender.php');

if ( !function_exists('_ac_global_fixrootpath') ) {
function _ac_global_fixrootpath() {
	# Necessary kludge to fix images/__USER__ if the global $admin variable doesn't exist (which
	# it probably won't) earlier in the file.
	if (isset($GLOBALS["admin"]))
		$GLOBALS['ac_editor_rootpath'] = str_replace("__USER__", $GLOBALS["admin"]["username"], $GLOBALS["ac_editor_rootpath"]);
}
}
?>
