<?php

require_once ac_global_classes("select.php");

$GLOBALS['subscribers4approval'] = isset($GLOBALS['_hosted_account']) ? 20 : 0;

function approval_select_query(&$so) {
	return $so->query("
		SELECT
			a.*,
			( SELECT c.name FROM #campaign c WHERE c.id = a.campaignid ) AS campaignname,
			( SELECT g.title FROM #group g WHERE g.id = a.groupid ) AS groupname,
			( SELECT COUNT(suba.id) FROM #approval suba WHERE suba.userid = a.userid AND suba.approved = 1 ) AS approvals
		FROM
			#approval a
		WHERE
		[...]
	");
}

function approval_select_prepare($row) {
	$row['hash'] = md5($row['id'] . 'acp' . $row['campaignid'] . 'ac' . $row['groupid'] . 'a' . $row['userid']);
	$row['username'] = user_get($row['userid'], true);
	return $row;
}

function approval_select_row($id, $field = 'id') {
	if ( !in_array($field, array('campaignid', 'userid', 'groupid')) ) $field = 'id';
	$id = intval($id);
	$so = new AC_Select;
	$so->push("AND a.$field = '$id'");
	if ( $field != 'id' ) {
		//$so->orderby("a.adate DESC");
		$so->orderby("a.approved ASC");
		//$so->orderby("a.approved ASC, a.adate DESC");
	}

	$r = ac_sql_select_row(approval_select_query($so));
	if ( $r ) $r = approval_select_prepare($r);

	return $r;
}

function approval_select_array($so = null, $ids = null) {
	if ($so === null || !is_object($so))
		$so = new AC_Select;

	if ($ids !== null) {
		if ( !is_array($ids) ) $ids = explode(',', $ids);
		$tmp = array_diff(array_map('intval', $ids), array(0));
		$ids = implode("','", $tmp);
		$so->push("AND a.id IN ('$ids')");
	}
	$rows = ac_sql_select_array(approval_select_query($so));
	if ( $rows ) {
		foreach ( $rows as $k => $v ) $rows[$k] = approval_select_prepare($v);
	}
	return $rows;
}

function approval_select_array_paginator($id, $sort, $offset, $limit, $filter) {
	$admin = ac_admin_get();
	$so = new AC_Select;
	$so->push("AND a.approved = 0");

	$filter = intval($filter);
	if ($filter > 0) {
		$conds = ac_sql_select_one("SELECT conds FROM #section_filter WHERE id = '$filter' AND userid = '$admin[id]' AND sectionid = 'approval'");
		$so->push($conds);
	}

	$so->count();
	$total = (int)ac_sql_select_one(approval_select_query($so));

	switch ($sort) {
	}

	if ( (int)$limit == 0 ) $limit = 999999999;
	$limit  = (int)$limit;
	$offset = (int)$offset;
	$so->limit("$offset, $limit");
	$rows = approval_select_array($so);

	return array(
		"paginator"   => $id,
		"offset"      => $offset,
		"limit"       => $limit,
		"total"       => $total,
		"cnt"         => count($rows),
		"rows"        => $rows,
	);
}
/*
function approval_filter_post() {
	$whitelist = array("sdate");

	$ary = array(
		"userid" => $GLOBALS['admin']['id'],
		"sectionid" => "approval",
		"conds" => "",
		"=tstamp" => "NOW()",
	);

	if (isset($_POST["qsearch"]) && !isset($_POST["content"])) {
		$_POST["content"] = $_POST["qsearch"];
	}

	if (isset($_POST["content"]) and $_POST["content"] != "") {
		$content = ac_sql_escape($_POST["content"], true);
		$conds = array();

		if (!isset($_POST["section"]) || !is_array($_POST["section"]))
			$_POST["section"] = $whitelist;

		foreach ($_POST["section"] as $sect) {
			if (!in_array($sect, $whitelist))
				continue;
			$conds[] = "$sect LIKE '%$content%'";
		}

		$conds = implode(" OR ", $conds);
		$ary["conds"] = "AND ($conds) ";
	}
	if ( $ary['conds'] == '' ) return array('filterid' => 0);

	$conds_esc = ac_sql_escape($ary["conds"]);
	$filterid = ac_sql_select_one("
		SELECT
			id
		FROM
			#section_filter
		WHERE
			userid = '$ary[userid]'
		AND
			sectionid = 'approval'
		AND
			conds = '$conds_esc'
	");

	if (intval($filterid) > 0)
		return array("filterid" => $filterid);
	ac_sql_insert("#section_filter", $ary);
	return array("filterid" => ac_sql_insert_id());
}

function approval_insert_post() {
	$ary = array(
	);

	$sql = ac_sql_insert("#approval", $ary);
	if ( !$sql ) {
		return ac_ajax_api_result(false, _a("Campaign Approval could not be added."));
	}
	$id = ac_sql_insert_id();

	return ac_ajax_api_added(_a("Campaign Approval"));
}

function approval_update_post() {
	global $admin;
	$ary = array(
		'approved' => 1,
		'adminid' => $admin['id'],
		'=adate' => 'NOW()',
	);

	$cid = intval($_POST["cid"]);
	$id = intval($_POST["id"]);
	$sql = ac_sql_update("#approval", $ary, "id = '$id'");
	if ( !$sql ) {
		return ac_ajax_api_result(false, _a("Campaign Approval could not be updated."));
	}

	// start the campaign
	$sql = ac_sql_update_one('#campaign', 'status', 1, "`id` = '$cid'");
	if ( !$sql ) {
		return ac_ajax_api_result(false, _a("Campaign could not be started."));
	}
	// init the campaign
	campaign_init($cid);

	return ac_ajax_api_updated(_a("Campaign Approval"));
}
*/

function approval_delete($id) {
	$id = intval($id);
	$campaignid = ac_sql_select_one('campaignid', '#approval', "`id` = '$id'");
	ac_sql_query("DELETE FROM #approval WHERE id = '$id'");
	approval_delete_relations(array($campaignid));
	return ac_ajax_api_deleted(_a("Campaign Approval"));
}

function approval_delete_multi($ids) {
	if ($ids == "_all") {
		ac_sql_query("TRUNCATE TABLE #approval");
		approval_delete_relations(null);
		return;
	}
	$tmp = array_map("intval", explode(",", $ids));
	$ids = implode("','", $tmp);
	$campaignids = ac_sql_select_list("SELECT campaignid FROM #approval WHERE `id` IN ('$ids')");
	ac_sql_query("DELETE FROM #approval WHERE id IN ('$ids')");
	approval_delete_relations($campaignids);
	return ac_ajax_api_deleted(_a("Campaign Approval"));
}

function approval_delete_relations($ids) {
	foreach ( $ids as $id ) {
		campaign_delete($id);
	}
}


function approval_needed($admin = null) {
	if ( is_null($admin) ) $admin = ac_admin_get();
	// if approval is not needed
	if ( !$admin['req_approval'] ) return false;
	// if we should approve only the first X
	if ( $admin['req_approval_1st'] > 0 ) {
		if ( $admin['req_approval_1st'] <= approval_count($admin['groups'], 1) ) return false;
	}
	return true;
}

function approval_count($groups = array(), $approved = null) {
	$conds = array();
	if ( count($groups) ) {
		$list = implode("', '", $groups);
		$conds[] = "`groupid` IN ('$list')";
	}
	if ( !is_null($approved) ) {
		$approved = (int)$approved;
		$conds[] = "`approved` = '$approved'";
	}
	return (int)ac_sql_select_one('=COUNT(*)', '#approval', implode(" AND ", $conds));
}

function approval_add($campaign, $user = null) {
	if ( is_null($user) ) {
		$origAdmin = ac_admin_get();
		$user = ac_admin_get_totally_unsafe($campaign['userid']);
		$GLOBALS['admin'] = $origAdmin;
	}
	if ( !isset($user['groups']) ) {
		$user['groups'] = user_get_groups($user['id']);
	}
	$groupid = current($user['groups']);
	if ( ac_sql_select_one("=COUNT(*)", "#approval", "campaignid = '$campaign[id]' AND approved = 0") ) {
		/* it should NEVER get here, but somehow it does! */
		//ac_sql_update("#approval", array('approved' => 0, '=adate' => 'NULL'), "campaignid = '$campaign[id]'");
		return false;
	} else {
		ac_sql_delete("#approval", "campaignid = '$campaign[id]'");
		$insert = array(
			'id' => 0,
			'campaignid' => $campaign['id'],
			'userid' => $user['id'],
			'groupid' => $groupid,
			'approved' => 0,
			'adminid' => 0,
			'=sdate' => 'NOW()',
			'=adate' => 'NULL',
		);
		$done = ac_sql_insert('#approval', $insert);
		if ( !$done ) {
			return false;
		}
		$id = (int)ac_sql_insert_id();
	}
	return true;
}

function approval_notify($campaign, $user = null) {
	global $site;
	require_once(ac_global_functions('mail.php'));
	if ( is_null($user) ) {
		$origAdmin = ac_admin_get();
		$user = ac_admin_get_totally_unsafe($campaign['userid']);
		$GLOBALS['admin'] = $origAdmin;
	}

	// checks if there's no approval || notification involved
	if ( !$user['req_approval'] ) return 0;
	if ( !$user['req_approval_notify'] ) return 0;

	// email sending vars
	$from_name = $site['site_name'];
	$from_mail = $site['emfrom'];
	$subject = _a('A new campaign needs approval in order to be sent');
	$recipients = $user['req_approval_notify'];
	$to_name = _a('Campaign Approval Admin');

	$approval = approval_select_row($campaign['id'], 'campaignid');

	// campaign view & approve link
	$approvelink = ac_site_plink("index.php?action=approve&a=$approval[id]&c=$campaign[id]&h=$approval[hash]");

	// call smarty to make an e-mail body
	$vars = array(
		'campaign' => $campaign,
		'user' => $user,
		'approvelink' => $approvelink,
	);
	$message = ac_mail_prepare('campaign_approval', $vars);

	// send an email
	if ( isset($GLOBALS['_hosted_account']) ) {
		require(dirname(dirname(__FILE__)) . '/manage/approve.add.inc.php');
	} else {
		$options = array();
		$options['userid'] = $user['id'];
		$sent = ac_mail_send($message['type'], $from_name, $from_mail, $message['body'], $subject, $recipients, $to_name, $options);
	}
	return $sent;
}

function approval_approve($approvalid, $hash) {
	global $admin;

	// get the approval
	$approval = approval_select_row($approvalid);
	if ( !$approval or $approval['approved'] or $approval['hash'] != $hash ) {
		return ac_ajax_api_result(false, _a("Campaign Approval not found."));
	}

	// get the campaign
	$campaign = campaign_select_row($approval['campaignid']);
	if ( !$campaign ) {
		return ac_ajax_api_result(false, _a("Campaign not found."));
	}

	// update the approval
	$ary = array(
		'approved' => 1,
		'adminid' => $admin['id'],
		'=adate' => 'NOW()',
	);
	$sql = ac_sql_update("#approval", $ary, "id = '$approvalid'");
	if ( !$sql ) {
		return ac_ajax_api_result(false, _a("Campaign Approval could not be approved."));
	}

	// hard set the campaign status back to draft
	ac_sql_update_one('#campaign', 'status', 0, "id = '$campaign[id]'");

	// init the campaign
	$sendnow = ( in_array($campaign['type'], array('single', /*'recurring',*/ 'split')) && $campaign['sdate'] <= AC_CURRENTDATETIME );
	if ( $sendnow ) {
		$init = campaign_init($approval['campaignid']);
		if ( !$init ) {
			return ac_ajax_api_result(false, _a("Campaign Approval could not be initialized."));
		}
	} else {
		// hard set the campaign status to scheduled
		ac_sql_update_one('#campaign', 'status', 1, "id = '$campaign[id]'");
	}

	return ac_ajax_api_result(true, _a("Campaign Approved."));
}

function approval_decline_only($approvalid, $hash) {
	global $admin;

	// get the approval
	$approval = approval_select_row($approvalid);
	if ( !$approval or $approval['approved'] or $approval['hash'] != $hash ) {
		return ac_ajax_api_result(false, _a("Campaign Approval not found."));
	}

	// get the campaign
	$campaign = campaign_select_row($approval['campaignid']);
	if ( !$campaign ) {
		return ac_ajax_api_result(false, _a("Campaign not found."));
	}

	// update the approval
	$ary = array(
		'approved' => 1,
		'adminid' => $admin['id'],
		'=adate' => 'NOW()',
	);
	$sql = ac_sql_update("#approval", $ary, "id = '$approvalid'");
	if ( !$sql ) {
		return ac_ajax_api_result(false, _a("Campaign Approval could not be declined."));
	}

	// hard set the campaign status back to draft
	ac_sql_delete("#approval", "`id` = '$approvalid'");

	// re-draft the campaign
	$sql = ac_sql_update_one('#campaign', 'status', 0, "`id` = '$approval[campaignid]'");
	if ( !$sql ) {
		return ac_ajax_api_result(false, _a("Campaign could not be declined."));
	}
	return ac_ajax_api_result(true, _a("Campaign declined."));
}

function approval_decline() {
	global $site;

	$approvalid = (int)ac_http_param('id');
	$hash = (string)ac_http_param('hash');
	$from_mail = ac_http_param('from_mail');
	$from_name = ac_http_param('from_name');
	$to_mail = ac_http_param('to_mail');
	$to_name = ac_http_param('to_name');
	$subject = ac_http_param('subject');
	$message = ac_http_param('message');

	$approval = approval_select_row($approvalid);
	if ( !$approval or $approval['approved'] or $approval['hash'] != $hash ) {
		return ac_ajax_api_result(false, _a("Campaign Approval not found."));
	}
	ac_sql_delete("#approval", "`id` = '$approvalid'");

	// re-draft the campaign
	$sql = ac_sql_update_one('#campaign', 'status', 0, "`id` = '$approval[campaignid]'");
	if ( !$sql ) {
		return ac_ajax_api_result(false, _a("Campaign could not be declined."));
	}

	$options = array();
	$options['userid'] = 1;

	$options = array();
	$options['userid'] = 1;

	// notify admin
	if ( $to_mail ) {
		$sent = ac_mail_send('text', $from_name, $from_mail, $message, $subject, $to_mail, $to_name, $options);
		if ( !$sent ) {
			return ac_ajax_api_result(false, _a("Campaign was declined, but creator was not notified."));
		}
	}

	return ac_ajax_api_result(true, _a("Campaign Declined."));
}

?>
