<?php

require_once ac_global_classes("select.php");

function campaign_select_totals($campaignid, $messageid) {
	$campaignid = intval($campaignid);
	$messageid  = intval($messageid);
	$table      = "#campaign";
	$cond       = "id = '$campaignid'";
	$type       = "type, ldate, status,";

	if ($messageid > 0) {
		$table = "#campaign_message";
		$cond  = "messageid = '$messageid' AND campaignid = '$campaignid'";
		$type  = "( SELECT ldate FROM #campaign WHERE id = '$campaignid' ) AS ldate,";
		$type .= "( SELECT status FROM #campaign WHERE id = '$campaignid' ) AS status,";
	}

	return ac_sql_select_row("
		SELECT
			$type
			total_amt,
			send_amt,
			uniqueopens,
			uniquelinkclicks,
			subscriberclicks,
			unsubscribes,
			forwards,
			updates,
			hardbounces + softbounces AS totalbounces,
			socialshares
		FROM
			$table
		WHERE
			$cond
	", array("ldate"));
}

function campaign_select_query(&$so, $deleted = false) {
	if ( !ac_admin_ismain() ) {
		$admin = ac_admin_get();
		if ( $admin['id'] > 1 ) {
			if ( !isset($so->permsAdded) ) {
				$so->permsAdded = 1;
				$liststr = implode("','", $admin["lists"]);

				if ($so->counting)
					$so->push("AND (SELECT COUNT(*) FROM #campaign_list subq WHERE subq.campaignid = c.id AND subq.listid IN ('$liststr'))");
				else
					$so->push("AND l.listid IN ('$liststr')");
			}
		}
	}
	$tablesuffix = $deleted ? '_deleted' : '';
	return $so->query("
		SELECT
			c.*,
			COUNT(l.id) AS lists
		FROM
			#campaign$tablesuffix c
		LEFT JOIN
			#campaign_list l
		ON
			c.id = l.campaignid
		WHERE
			[...]
		GROUP BY
			c.id
	");
}

function campaign_select_prepare($row, $full = false) {
	if ( $full ) {
		if ( ac_http_param_exists('nolt') and ac_http_param('nolt') ) {
			$row['tracklinks'] = 'none';
		}
		$row['lists'] = campaign_lists($row['id']);
		if ( !$row['lists'] ) $row['lists'] = array();
		// calculate list limits
		$row['p_duplicate_send']     = 1;
		$row['p_embed_image']        = 0;
		$row['p_use_scheduling']     = ( $row['status'] == 3 or $row['status'] == 4 );
		$row['p_use_tracking']       = 0;
		$row['p_use_analytics_read'] = 0;
		$row['p_use_analytics_link'] = 0;
		$row['p_use_twitter'] = 0;
		$row['p_use_facebook'] = 0;
		$lists = array();
		foreach ( $row['lists'] as $l ) {
			$lists[] = $l['listid'];
			if ( !$l['p_duplicate_send'] )    $row['p_duplicate_send']     = $l['p_duplicate_send'];
			if ( $l['p_embed_image'] )        $row['p_embed_image']        = $l['p_embed_image'];
			if ( $l['p_use_tracking'] )       $row['p_use_tracking']       = $l['p_use_tracking'];
			if ( $l['p_use_analytics_read'] ) $row['p_use_analytics_read'] = $l['p_use_analytics_read'];
			if ( $l['p_use_analytics_link'] ) $row['p_use_analytics_link'] = $l['p_use_analytics_link'];
			if ( $l['p_use_twitter'] )        $row['p_use_twitter']        = $l['p_use_twitter'];
			if ( $l['p_use_facebook'] )       $row['p_use_facebook']       = $l['p_use_facebook'];
		}
		$row['listslist'] = implode('-', $lists);
		// fetch all fields (for those lists only, globals should be prefetched elsewhere)
		$row['fields'] = list_get_fields($lists, false);
		// fetch all messages that belong to this campaign
		$row['ratios'] = array();
		$row['sources'] = array();
		$messages = array();
		$sql = ac_sql_query("SELECT * FROM #campaign_message WHERE campaignid = '$row[id]'");
		while ( $msg = ac_sql_fetch_assoc($sql) ) {
			$messages[] = $msg['messageid'];
			$row['ratios'][$msg['messageid']] = $msg['percentage'];
			$row['sources'][$msg['messageid']] = $msg['sourcesize'];
		}
		// fetch all message info
		$row['messages'] = message_select_array(null, $messages, implode(',', $lists));
		foreach ( $row['messages'] as $k => $v ) {
			$row['messages'][$k]['percentage'] = $row['ratios'][$v['id']];
			$row['messages'][$k]['sourcesize'] = $row['sources'][$v['id']];
		}
		$row['messageslist'] = implode('-', $messages);
		// fetch all links for parsing
		$row['tlinks'] = campaign_links_get($row);
		$row['readactions'] = campaign_read_actions($row["id"]);
	}
	if ( isset($GLOBALS['_hosted_account']) ) {
		$row['bounceid'] = -1;
	}
	return $row;
}

function campaign_select_row($id, $full = true, $offset = true, $trydeleted = false) {
	$id = intval($id);
	$so = new AC_Select;
	$so->push("AND c.id = '$id'");

	if ($offset)
		$r = ac_sql_select_row(campaign_select_query($so, false), array("sdate", "ldate"));
	else
		$r = ac_sql_select_row(campaign_select_query($so, false));

	// if we should check deleted campaigns as well
	if ( !$r and $trydeleted ) {
		if ($offset)
			$r = ac_sql_select_row(campaign_select_query($so, true), array("sdate", "ldate"));
		else
			$r = ac_sql_select_row(campaign_select_query($so, true));
	}

	if ( $r ) {
		$r = campaign_select_prepare($r, $full);
	}
	return $r;
}

function campaign_select_array($so = null, $ids = null, $full = false) {
	if ($so === null || !is_object($so))
		$so = new AC_Select;

	if ($ids !== null) {
		if ( !is_array($ids) ) $ids = explode(",", $ids);
		$tmp = array_diff(array_map("intval", $ids), array(0));
		$ids = implode("','", $tmp);
		$so->push("AND c.id IN ('$ids')");
	}
	//dbg(ac_prefix_replace(campaign_select_query($so)));
	$r = ac_sql_select_array(campaign_select_query($so), array("sdate", "ldate"));
	foreach ( $r as $k => $v ) {
		if ( $v ) {
			$r[$k] = campaign_select_prepare($v, $full);
		}
	}

	return $r;
}

function campaign_select_array_paginator($id, $sort, $offset, $limit, $filter, $public = false, $list_stringid = null) {
	$admin = ac_admin_get();
	$so = new AC_Select;
	$so2 = new AC_Select;

	$so->push("AND c.type != 'special'");
	$so2->push("AND c.type != 'special'");

	$filter = intval($filter);
	if ($filter > 0) {
		$conds = ac_sql_select_one("SELECT conds FROM #section_filter WHERE id = '$filter' AND userid = '$admin[id]' AND sectionid = 'campaign'");
		$so->push($conds);

		$conds = preg_replace(
			'/l\.listid = \'?(\d+)\'?/',
			'\1 IN (SELECT subq.listid FROM #campaign_list subq WHERE subq.campaignid = c.id)',
			$conds
		);

		$conds = preg_replace(
			'/l\.listid IN \(([^)]+)\)/',
			'(SELECT COUNT(*) FROM #campaign_list subq WHERE subq.campaignid = c.id AND subq.listid IN (\1)) > 0',
			$conds
		);

		$so2->push($conds);
	}

	if ( $public ) {
		$so->push("AND ( c.type IN ('responder', 'reminder') OR c.status = 5 )");
		$so2->push("AND ( c.type IN ('responder', 'reminder') OR c.status = 5 )");
	}

	$so2->count();
	//dbg(campaign_select_query($so2));
	$total = (int)ac_sql_select_one(campaign_select_query($so2));

	switch ($sort) {
		case "02":
			$so->orderby("c.type"); break;
		case "02D":
			$so->orderby("c.type DESC"); break;
		case "03":
			$so->orderby("c.status"); break;
		case "03D":
			$so->orderby("c.status DESC"); break;
		case "04":
			$so->orderby("c.name"); break;
		case "04D":
			$so->orderby("c.name DESC"); break;
		case "05":
			$so->orderby("c.sdate"); break;
		case "05D":
			$so->orderby("c.sdate DESC"); break;
		case "06":
			$so->orderby("c.cdate"); break;
		case "06D":
			$so->orderby("c.cdate DESC"); break;
		case "07":
			$so->orderby("messagesubject"); break;
		case "07D":
			$so->orderby("messagesubject DESC"); break;
		case "01":
			$so->orderby("c.ldate, c.sdate"); break;
		case "01D":
		default:
			$so->orderby("c.ldate DESC, c.sdate DESC"); break;
	}

	if ( (int)$limit == 0 ) $limit = 999999999;
	$limit  = (int)$limit;
	$offset = (int)$offset;
	$so->limit("$offset, $limit");

	// if public, add message subject
	if ($public) {
		// we need to add all "SELECT" elements here again
		$so->slist = array(
			"c.*",
			"COUNT(l.id) AS lists",
			"
				(
					SELECT
						IF(( m.subject IS NULL OR m.subject = '' ), m.html, m.subject) AS `subject`
					FROM
						#campaign_message cm,
						#message m
					WHERE
						cm.campaignid = c.id
					AND
						cm.messageid = m.id
					LIMIT 0, 1
				) AS messagesubject
			"
		);
		$so->remove = false;

		$rows = campaign_select_array($so);

		foreach ( $rows as $k => $v ) {
			$rows[$k]['url'] = campaign_url($v, $list_stringid);
		}
	} else {
		$rows = campaign_select_array($so/*, null, true*/);

		foreach ($rows as $k => $v) {
			$rows[$k]['canresend'] = filter_allows_campaignuse($v["filterid"]);
		}
	}
/*
	foreach ( $rows as $k => $v ) {
		//$rows[$k]['infuture'] = ( $v['sdate'] > AC_CURRENTDATETIME );
		$rows[$k]['infuture'] = ( $v['sdate'] > AC_CURRENTDATETIME  and ( !$v['ldate'] or $v['ldate'] < $v['sdate'] ) );
	}dbg($rows);
*/
	return array(
		"paginator"   => $id,
		"offset"      => $offset,
		"limit"       => $limit,
		"total"       => $total,
		"cnt"         => count($rows),
		"rows"        => $rows,
	);
}

function campaign_filter_post() {
	//$whitelist = array("c.name", "c.analytics_campaign_name", "_message");
	$whitelist = array("c.name", "_message_subject", "_message_from", "_message_body");

	$ary = array(
		"userid" => $GLOBALS['admin']['id'],
		"sectionid" => "campaign",
		"conds" => "",
		"=tstamp" => "NOW()",
	);

	if (isset($_POST["qsearch"]) && !isset($_POST["content"])) {
		$_POST["content"] = $_POST["qsearch"];
	}

	if (isset($_POST["content"]) and $_POST["content"] != "") {
		$content = ac_sql_escape($_POST["content"], true);
		$conds = array();

		if (!isset($_POST["section"]) || !is_array($_POST["section"]))
			$_POST["section"] = $whitelist;

		foreach ($_POST["section"] as $sect) {
			if (!in_array($sect, $whitelist))
				continue;
			if ( $sect == '_message_subject' ) {
				$conds[] = "( SELECT m.subject FROM #campaign_message cm, #message m WHERE cm.campaignid = c.id AND cm.messageid = m.id LIMIT 0, 1 ) LIKE '%$content%' ";
			} elseif ($sect == '_message_from') {
				$conds[] = "( SELECT CONCAT(m.fromname, m.fromemail) FROM #campaign_message cm, #message m WHERE cm.campaignid = c.id AND cm.messageid = m.id LIMIT 0, 1 ) LIKE '%$content%' ";
			} elseif ($sect == '_message_body') {
				$conds[] = "( SELECT CONCAT(m.text, m.html) FROM #campaign_message cm, #message m WHERE cm.campaignid = c.id AND cm.messageid = m.id LIMIT 0, 1 ) LIKE '%$content%' ";
			} else {
				$conds[] = "$sect LIKE '%$content%'";
			}
		}

		$conds = implode(" OR ", $conds);
		$ary["conds"] = "AND ($conds) ";
	}

	if ( isset($_POST['listid']) ) {
		if ( defined('ACPUBLIC') ) {
			$_SESSION['nlp'] = $_POST['listid'];
		} else {
			$_SESSION['nla'] = $_POST['listid'];
		}
	}
	$nl = null;
	if ( isset($_SESSION['nlp']) and defined('ACPUBLIC') ) {
		$nl = $_SESSION['nlp'];
	} elseif ( isset($_SESSION['nla']) ) {
		$nl = $_SESSION['nla'];
	}
	if ( $nl ) {
		if ( is_array($nl) ) {
			if ( count($nl) > 0 ) {
				$ids = implode("', '", array_map('intval', $nl));
				$ary["conds"] .= "AND (SELECT COUNT(*) FROM #campaign_list subq WHERE subq.campaignid = c.id AND subq.listid IN ('$ids')) > 0 ";
				//$ary['conds'] .= "AND l.listid IN ('$ids') ";
			} else {
				if ( defined('ACPUBLIC') ) {
					unset($_SESSION['nlp']);
				} else {
					unset($_SESSION['nla']);
				}
			}
		} else {
			$listid = (int)$nl;
			if ( $listid > 0 ) {
				$ary["conds"] .= "AND (SELECT COUNT(*) FROM #campaign_list subq WHERE subq.campaignid = c.id AND subq.listid = '$listid') > 0 ";
				//$ary['conds'] .= "AND l.listid = '$listid' ";
			} else {
				if ( defined('ACPUBLIC') ) {
					unset($_SESSION['nlp']);
				} else {
					unset($_SESSION['nla']);
				}
			}
		}
	}

	if (isset($_POST["status"])) {
		if ( is_array($_POST['status']) ) {
			if ( count($_POST['status']) > 0 ) {
				if ( !( count($_POST['status']) == 1 and $_POST['status'][0] == '' ) ) {
					$ids = implode("', '", array_map('intval', $_POST['status']));
					$ary['conds'] .= "AND c.status IN ('$ids') ";
				}
			}
		} else {
			if ( $_POST['status'] != '' ) {
				$status = (int)$_POST['status'];
				$ary['conds'] .= "AND c.status = '$status' ";
			}
		}
	}
	if (isset($_POST["type"])) {
		if ( is_array($_POST['type']) ) {
			if ( count($_POST['type']) > 0 ) {
				if ( !( count($_POST['type']) == 1 and $_POST['type'][0] == '' ) ) {
					$ids = implode("', '", array_map('ac_sql_escape', $_POST['type']));
					$ary['conds'] .= "AND c.type IN ('$ids') ";
				}
			}
		} else {
			if ( $_POST['type'] != '' ) {
				$type = ac_sql_escape($_POST['type']);
				$ary['conds'] .= "AND c.type = '$type' ";
			}
		}
	}

	if ( isset($_POST['public']) ) {
		$ary['conds'] .= "AND c.public = 1 ";
	}

	if ( $ary['conds'] == '' ) return array('filterid' => 0);

	$conds_esc = ac_sql_escape($ary["conds"]);
	$filterid = ac_sql_select_one("
		SELECT
			id
		FROM
			#section_filter
		WHERE
			userid = '$ary[userid]'
		AND
			sectionid = 'campaign'
		AND
			conds = '$conds_esc'
	");

	if (intval($filterid) > 0)
		return array("filterid" => $filterid);
	ac_sql_insert("#section_filter", $ary);
	return array("filterid" => ac_sql_insert_id());
}

function campaign_new() {
	// default campaign array (create new)
	$r = ac_sql_default_row('#campaign');
	// front-end stuff
	$r['step'] = 1;
	$r['lists'] = $r['messages'] = $r['tlinks'] = $r['links'] = $r['linkmessages'] = $r['actions'] = array();
	$r['listslist'] = '';
	$r['htmlunsubdata'] = _a('<div><a href="%UNSUBSCRIBELINK%">Click here</a> to unsubscribe from future mailings.</div>');
	$r['textunsubdata'] = _a('Click here to unsubscribe from future mailings: %UNSUBSCRIBELINK%');

	$r['sdate'] = strftime("%Y-%m-%d %H:%M:%S", strtotime(AC_CURRENTDATETIME));
	return $r;
}

function campaign_list_messages($type, $ids = '', $findPhrase = '') {
	require_once(ac_admin('functions/message.php'));
	$so = new AC_Select();
	if ( $ids ) {
		$sqlids = str_replace(",", "','", (string)$ids);
		$so->push("AND l.listid IN ('$sqlids')");
	}
	// messages stuff
	$so->push("AND m.hidden = 0");
	if ( $type == 'activerss' ) {
		$so->push("
			AND
			(
				m.text LIKE '%\%RSS-FEED|URL:%'
			OR
				SUBSTR(m.text, 1, 6) = 'fetch:'
			OR
				m.html LIKE '%\%RSS-FEED|URL:%'
			OR
				SUBSTR(m.html, 1, 6) = 'fetch:'
			)
		");
	}
	if ( $findPhrase = trim((string)$findPhrase) ) {
		$phrase = ac_sql_escape($findPhrase, true);
		$so->push("
			AND
			(
				m.fromname LIKE '%$phrase%'
			OR
				m.fromemail LIKE '%$phrase%'
			OR
				m.reply2 LIKE '%$phrase%'
			OR
				m.subject LIKE '%$phrase%'
			OR
				m.text LIKE '%$phrase%'
			OR
				m.html LIKE '%$phrase%'
			)
		");
	}
	$so->slist = array(
		"m.id",
		"m.cdate",
		"m.mdate",
		"m.fromname",
		"m.fromemail",
		"m.format",
		"IF(( m.subject IS NULL OR m.subject = '' ), m.html, m.subject) AS `subject`",
		"COUNT(l.id) AS lists",
		"
			(
				SELECT
					COUNT(*)
				FROM
					#campaign_message cm,
					#campaign_list cl,
					#campaign c
				WHERE
					c.status != 0
				AND
					c.filterid = 0
				AND
					c.type IN ('single', 'recurring', 'activerss')
				AND
					c.id = cm.campaignid
				AND
					c.id = cl.campaignid
				AND
					l.id = cl.listid
				AND
					m.id = cm.messageid
			) AS usedb4
		"
	);
	$so->remove = false;
	$so->orderby("usedb4, m.subject ASC");
	return message_select_array($so, null);
}

function campaign_list_change($campaignid, $ids, $includeGlobals, $type) {
	//require_once(ac_admin('functions/filter.php'));
	require_once(ac_admin('functions/bounce_management.php'));
	require_once(ac_admin('functions/personalization.php'));
	$showAllMessages = (bool)substr($type, -1);
	$type = substr($type, 0, -1);
	$idsarr = array_diff(array_map('intval', explode('-', $ids)), array(0));
	$ids = implode(',', $idsarr);
	$sqlids = implode("','", $idsarr);
	if ( !$ids ) {
		return array(
			//'filters' => array(),
			'messages' => array(),
			'fields' => array(),
			'lists' => array(),
			'bounces' => array(),
			'personalizations' => array(),
		);
	}
	$bso = new AC_Select();
	//$fso = new AC_Select();
	$pso = new AC_Select();
	$bso->push("AND l.listid IN ('$sqlids')");
	//$fso->push("AND f.id IN (SELECT l.filterid FROM #filter_list l WHERE l.listid IN ('$sqlids'))");
	//$fso->push("AND f.hidden = 0");
	$pso->push("AND l.listid IN ('$sqlids')");
	//$fso->orderby("f.name");
	return array(
		//'filters' => filter_select_array($fso, null),
		'messages' => campaign_list_messages($type, ( $showAllMessages ? '' : $ids )),
		'fields' => list_get_fields($idsarr, false),
		'lists' => list_select_array(null, $ids, ''),
		'bounces' => campaign_list_bounces($bso),
		'personalizations' => list_personalizations($pso),
	);
}

function campaign_list_bounces($so) {
	$so->push("AND b.type != 'none'");
	$so->push("AND b.email != ''");
	require_once ac_admin("functions/bounce_management.php");
	return ac_array_unique(bounce_management_select_array($so, null), 'email');
}

function campaign_list_headers($so) {
	require_once ac_admin("functions/header.php");
	return ac_array_unique(header_select_array($so, null), 'name');
}

function campaign_links_get($row, $messagesList = null) {
	if ( $row['tracklinks'] == 'none' ) return array();
	// prepare message condition
	$cond = ( is_null($messagesList) ? str_replace('-', "','", $row['messageslist']) : implode("','", $messagesList) );

	// fetch all links in messages specified in this campaign
	$tlinks = ac_sql_select_array("
		SELECT
			l.*,
			(SELECT m.format FROM #message m WHERE m.id = l.messageid) AS `format`
		FROM
			#link l
		WHERE
			l.campaignid = '$row[id]'
		AND
			l.messageid IN ('$cond')
	");

	if ( !$tlinks ) $tlinks = array();
	foreach ( $tlinks as $k => $v ) {
		$tlinks[$k]['actions'] = campaign_links_actions($v['id']);
	}
	return $tlinks;
}

function campaign_read_actions($campaignid) {
	$campaignid = (int)$campaignid;
	$rval = ac_sql_select_array("SELECT a.* FROM #subscriber_action a WHERE campaignid = '$campaignid' AND linkid = '0'");

	foreach ($rval as $k => $v) {
		$rval[$k]["parts"] = ac_sql_select_array("SELECT * FROM #subscriber_action_part WHERE actionid = '$v[id]'");
	}

	return $rval;
}

function campaign_links_actions($linkid) {
	$rval = ac_sql_select_array("SELECT a.* FROM #subscriber_action a WHERE linkid = '$linkid'");
	foreach ($rval as $k => $v) {
		$rval[$k]["parts"] = ac_sql_select_array("SELECT * FROM #subscriber_action_part WHERE actionid = '$v[id]'");
	}
	return $rval;
}

function campaign_selectdropdown_bylist($listid) {
	$listid = intval($listid);
	return ac_sql_select_array("
		SELECT
			c.id,
			c.name
		FROM
			#campaign c
		WHERE
			c.id IN
			(
				SELECT
					subcl.campaignid
				FROM
					#campaign_list subcl
				WHERE
					subcl.listid = '$listid'
			)
	");
}

function campaign_url($campaign, $list_stringid) {
	global $site;
	// use absolute URL?
	$base = $site['p_link'];
	// remove trailing slash if exists
	if ( substr($base, -1) == '/' ) $base = substr($base, 0, -1);
	// working array always starts with a base, without trailing slash
	$arr = array($base);

	if ( !$site['general_url_rewrite'] ) {
		$arr[] = 'index.php?action=message&c=' . $campaign['id'];
	}
	else {
		$arr[] = 'archive';
		$arr[] = $list_stringid;
		$arr[] = $campaign['id'];
	}
	// return an url
	return implode('/', $arr);
}

function campaign_lists($id) {
	$cond = '';
	if ( !ac_admin_ismain() ) {
		$admin = ac_admin_get();
		if ( $admin['id'] > 1 ) {
			$cond = "AND c.listid IN ('" . implode("', '", $admin['lists']) . "')";
		}
	}
	// fetch all lists it belongs to (should be only selected for campaign)
	$query = "
		SELECT
			*,
			c.id AS relid,
			l.id AS id
		FROM
			#campaign_list c,
			#list l
		WHERE
			c.campaignid = '$id'
		AND
			c.listid = l.id
		$cond
		ORDER BY
			l.name
	";
	return ac_sql_select_array($query);
}

function campaign_messages($id, $compact = false) {
	$what = ( $compact ? "IF(( m.subject IS NULL OR m.subject = '' ), m.html, m.subject) AS `subject`" : '*' );
	// fetch all lists it belongs to (should be only selected for campaign)
	$query = "
		SELECT
			$what,
			c.id AS relid,
			m.id AS id
		FROM
			#campaign_message c,
			#message m
		WHERE
			c.campaignid = '$id'
		AND
			c.messageid = m.id
		ORDER BY
			m.subject
	";
	return ac_sql_select_array($query);
}

function campaign_share_get($id, $email = 'web') {
	$campaign = campaign_select_row($id);
	if ( !$campaign ) return false;
	$campaign["sharelink"] = em_reporthash_link($campaign, $email);
	return $campaign;
}

// when updating this function, also update /admin/templates/strings.js, it contains the same names
function campaign_statuses() {
	return array(
		_a("Draft"),
		_a("Scheduled"),
		_a("Sending"),
		_a("Paused"),
		_a("Stopped"),
		_a("Completed"),
		_a("Disabled"),
		_a("Pending Approval"),
	);
}

// when updating this function, also update /admin/templates/strings.js, it contains the same names
function campaign_type() {
	return array(
		'single' => _a("One-Time Mailing"),
		'recurring' => _a("Recurring Mailing"),
		'responder' => _a("AutoResponder"),
		'reminder' => _a("Subscriber Date Based Mailing"),
		'split' => _a("Split Test"),
		'activerss' => _a("RSS Mailing"),
		//'special' => _a("Special Mailing")
	);
}

// when updating this function, also update /admin/templates/strings.js, it contains the same names
function campaign_types() {
	return array(
		'single' => _a("One-Time Mailings"),
		'recurring' => _a("Recurring Mailings"),
		'responder' => _a("AutoResponders"),
		'reminder' => _a("Subscriber Date Based Mailings"),
		'split' => _a("Split Tests"),
		'activerss' => _a("RSS Mailings"),
		//'special' => _a("Special Mailings")
	);
}

function campaign_recur_intervals() {
	return array(
		'hour0' => _a("Every Half an Hour"),
		'hour1' => _a("Every Hour"),
		'hour2' => _a("Every Other Hour"),
		'hour6' => _a("Every 6 Hours"),
		'hour12' => _a("Every 12 Hours"),
		'day1' => _a("Every Day"),
		'day2' => _a("Every Other Day"),
		'week1' => _a("Every Week"),
		'week2' => _a("Every Other Week"),
		'month1' => _a("Every Month"),
		'month2' => _a("Every Other Month"),
		'quarter1' => _a("Every Quarter"),
		'quarter2' => _a("Every Other Quarter"),
		'year1' => _a("Every Year"),
		'year2' => _a("Every Other Year"),
	);
}

?>
