<?php

require_once ac_global_classes("select.php");

function design_select_query(&$so) {
	return $so->query("
		SELECT
			*,
			g.id AS id
		FROM
			#group g,
			#branding b
		WHERE
		[...]
		AND
			g.id = b.groupid
		AND
			g.p_admin = 1
	");
}

function design_select_row($id) {
	$id = intval($id);
	$so = new AC_Select;
	$so->push("AND g.id = '$id'");

	return ac_sql_select_row(design_select_query($so));
}

function design_select_array($so = null, $ids = null) {
	if ($so === null || !is_object($so))
		$so = new AC_Select;

	if ($ids !== null) {
		if ( !is_array($ids) ) $ids = explode(',', $ids);
		$tmp = array_diff(array_map('intval', $ids), array(0));
		$ids = implode("','", $tmp);
		$so->push("AND g.id IN ('$ids')");
	}
	return ac_sql_select_array(design_select_query($so));
}

function design_select_array_paginator($id, $sort, $offset, $limit, $filter) {
	$admin = ac_admin_get();
	$so = new AC_Select;

	$filter = intval($filter);
	if ($filter > 0) {
		$conds = ac_sql_select_one("SELECT conds FROM #section_filter WHERE id = '$filter' AND userid = '$admin[id]' AND sectionid = 'design'");
		$so->push($conds);
	}

	$so->count();
	$total = (int)ac_sql_select_one(design_select_query($so));

	switch ($sort) {
		case '02':
			$so->orderby("b.site_name ASC"); break;
		case '02D':
			$so->orderby("b.site_name DESC"); break;

		case '01D':
			$so->orderby("g.title DESC"); break;
		case '01':
		default:
			$so->orderby("g.title ASC");
	}

	if ( (int)$limit == 0 ) $limit = 999999999;
	$so->limit("$offset, $limit");
	$rows = design_select_array($so);

	return array(
		"paginator"   => $id,
		"offset"      => $offset,
		"limit"       => $limit,
		"total"       => $total,
		"cnt"         => count($rows),
		"rows"        => $rows,
	);
}

function design_filter_post() {
	$whitelist = array("title", "descript", "site_name", "site_logo", "header_text", "header_html", "footer_text", "footer_html");

	$ary = array(
		"userid" => $GLOBALS['admin']['id'],
		"sectionid" => "design",
		"conds" => "",
		"=tstamp" => "NOW()",
	);

	if (isset($_POST["qsearch"]) && !isset($_POST["content"])) {
		$_POST["content"] = $_POST["qsearch"];
	}

	if (isset($_POST["content"]) and $_POST["content"] != "") {
		$content = ac_sql_escape($_POST["content"], true);
		$conds = array();

		if (!isset($_POST["section"]) || !is_array($_POST["section"]))
			$_POST["section"] = $whitelist;

		foreach ($_POST["section"] as $sect) {
			if (!in_array($sect, $whitelist))
				continue;
			$conds[] = "$sect LIKE '%$content%'";
		}

		$conds = implode(" OR ", $conds);
		$ary["conds"] = "AND ($conds) ";
	}
	if ( $ary['conds'] == '' ) return array('filterid' => 0);

	$conds_esc = ac_sql_escape($ary["conds"]);
	$filterid = ac_sql_select_one("
		SELECT
			id
		FROM
			#section_filter
		WHERE
			userid = '$ary[userid]'
		AND
			sectionid = 'design'
		AND
			conds = '$conds_esc'
	");

	if (intval($filterid) > 0)
		return array("filterid" => $filterid);
	ac_sql_insert("#section_filter", $ary);
	return array("filterid" => ac_sql_insert_id());
}
/*
function design_insert_post() {
	$ary = array(
	);

	$sql = ac_sql_insert("#design", $ary);
	if ( !$sql ) {
		return ac_ajax_api_result(false, _a("Design Settings could not be added."));
	}
	$id = ac_sql_insert_id();

	return ac_ajax_api_added(_a("Design Settings"));
}
*/
function design_update_post() {

	// templates & styles
	if ( ac_http_param_exists('template_show') ) {
		$template_htm = (string)ac_http_param('template');
	} else {
		$template_htm = '';
	}
	if ( ac_http_param_exists('style_show') ) {
		$template_css = (string)ac_http_param('style');
	} else {
		$template_css = '';
	}

	// supporting old API call
	// coming from branding_edit API
	if ( ac_http_param_exists('branding_url') ) {
		$design_url = $_POST["branding_url"];
	}
	else {
		$design_url = $_POST["design_url"];
	}

	$logo_source = ac_http_param("logo_source");

	$site_logo = $design_url;

	if ($logo_source == "upload") {
		list($attachment) = ac_http_param("_attachments_");
		if ($attachment) $site_logo = $GLOBALS["site"]["p_link"] . "/images/" . $GLOBALS["admin"]["username"] . "/" . $attachment;
	}

	$ary = array(
		"site_name" => $_POST["site_name"],
		"site_logo" => $site_logo,
		"header_text" => ( isset($_POST["header_text"]) ) ? 1 : 0,
		"header_text_value" => ( isset($_POST["header_text"]) ) ? $_POST["header_text_value"] : "",
		"header_html" => ( isset($_POST["header_html"]) ) ? 1 : 0,
		"header_html_value" => ( isset($_POST["header_html"]) ) ? ac_str_fixtinymce($_POST["header_html_valueEditor"]) : "",
		"footer_text" => ( isset($_POST["footer_text"]) ) ? 1 : 0,
		"footer_text_value" => ( isset($_POST["footer_text"]) ) ? $_POST["footer_text_value"] : "",
		"footer_html" => ( isset($_POST["footer_html"]) ) ? 1 : 0,
		"footer_html_value" => ( isset($_POST["footer_html"]) ) ? ac_str_fixtinymce($_POST["footer_html_valueEditor"]) : "",
		"copyright" => ( isset($_POST["copyright"]) ) ? 0 : 1,
		"version" => ( isset($_POST["version"]) ) ? 0 : 1,
		"license" => ( isset($_POST["license"]) ) ? 0 : 1,
		"links" => ( isset($_POST["links"]) ) ? 0 : 1,
		"help" => ( isset($_POST["help"]) ) ? 0 : 1,
		"demo" => ( isset($_POST["demo"]) && !isset($GLOBALS['_hosted_account']) ) ? 1 : 0,
		"admin_template_htm" => ( ac_http_param_exists('admin_template_show') ? (string)ac_http_param('admin_template') : '' ),
		"admin_template_css" => ( ac_http_param_exists('admin_style_show') ? (string)ac_http_param('admin_style') : '' ),
		"public_template_htm" => ( ac_http_param_exists('public_template_show') ? (string)ac_http_param('public_template') : '' ),
		"public_template_css" => ( ac_http_param_exists('public_style_show') ? (string)ac_http_param('public_style') : '' ),
	);

	$id = intval($_POST["id"]);

	// coming from branding_edit API
	if ( ac_http_param_exists('groupid') )
		$id = $_POST["groupid"];

	if ( $id != 3 ) $ary['site_logo'] = '';

	$sql = ac_sql_update("#branding", $ary, "groupid = '$id'");
	if ( !$sql ) {
		return ac_ajax_api_result(false, _a("Design Settings could not be updated."));
	}

	return ac_ajax_api_updated(_a("Design Settings"));
}
/*
function design_delete($id) {
	$id = intval($id);
	ac_sql_query("DELETE FROM #design WHERE id = '$id'");
	return ac_ajax_api_deleted(_a("Design Settings"));
}

function design_delete_multi($ids, $filter = 0) {
	if ( $ids == '_all' ) {
		$tmp = array();
		$so = new AC_Select();
		$filter = intval($filter);
		if ($filter > 0) {
			$admin = ac_admin_get();
			$conds = ac_sql_select_one("SELECT conds FROM #section_filter WHERE id = '$filter' AND userid = '$admin[id]' AND sectionid = 'design'");
			$so->push($conds);
		}
		$all = design_select_array($so);
		foreach ( $all as $v ) {
			$tmp[] = $v['id'];
		}
	} else {
		$tmp = array_map("intval", explode(",", $ids));
	}
	foreach ( $tmp as $id ) {
		$r = design_delete($id);
	}
	return $r;
}
*/

function design_template_personalize(&$smarty, $admin, $panel = 'public') {
	global $site;

	$prfx = ( $panel == 'admin' ? 'admin_' : 'public_' );

	$admin['template_htm'] =& $admin['brand_' . $prfx . 'template_htm'];

	// fetch html template
	$tplpath  = ( $panel == 'admin' ? ac_admin() : ac_basedir() );
	$tplpath .= '/templates/main.tpl';
	if ( !$admin['template_htm'] ) $admin['template_htm'] = ac_file_get($tplpath);
	if ( !ac_str_instr('%PAGECONTENT%', $admin['template_htm']) ) $admin['template_htm'] = ac_file_get($tplpath);

	// apply basic vars
	$siteurl = $smarty->get_template_vars('__');
	$admin['template_htm'] = str_replace('%SITEURL%', $siteurl, $admin['template_htm']);
	if($site['site_name']=="") $site['site_name'] = "&nbsp;";
	$admin['template_htm'] = str_replace('%SITENAME%', $site['site_name'], $admin['template_htm']);

	// fetch includes
	if ( ac_str_instr('%HEADERNAV%', $admin['template_htm']) ) {
		$headernav = $smarty->fetch('inc.headernav.htm');
		$admin['template_htm'] = str_replace('%HEADERNAV%', $headernav, $admin['template_htm']);
	}
	if ( $panel != 'admin' ) {
		if ( ac_str_instr('%FOOTERNAV%', $admin['template_htm']) ) {
			$footernav = $smarty->fetch('inc.footernav.htm');
			$admin['template_htm'] = str_replace('%FOOTERNAV%', $footernav, $admin['template_htm']);
		//} elseif ( $site['branding_links'] ) {
		} else {
			$acpowt = $site['acpow'] ? base64_decode($site["acpow"]) : 'Email Marketing Software';
			$admin['template_htm'] .= '<div align="center" style="font-size:11px;color:#999999;"><a href="http://www.activecampaign.com/help-desk-software/" style="text-decoration:none; color:#999999;" target="_blank" title="customer service software">' . $acpowt . '</a> ' . _i18n("by ActiveCampaign") . '</div>';
		}
		if ( ac_str_instr('%LANGSELECT%', $admin['template_htm']) ) {
			$langselect = $smarty->fetch('inc.langselect.htm');
			$admin['template_htm'] = str_replace('%LANGSELECT%', $langselect, $admin['template_htm']);
		}
	} else {
		if ( ac_str_instr('%SEARCHBAR%', $admin['template_htm']) ) {
			$searchbar = $smarty->fetch('inc.searchbar.htm');
			$admin['template_htm'] = str_replace('%SEARCHBAR%', $searchbar, $admin['template_htm']);
		}
		if ( ac_str_instr('%FOOTER%', $admin['template_htm']) ) {
			$smarty->assign('tip', em_tip_get());
			$footer = $smarty->fetch('inc.footer.htm');
			$admin['template_htm'] = str_replace('%FOOTER%', $footer, $admin['template_htm']);
		}
		if ( ac_str_instr('%ACCOUNTNAV%', $admin['template_htm']) ) {
			$accountnav = $smarty->fetch('inc.accountnav.htm');
			$admin['template_htm'] = str_replace('%ACCOUNTNAV%', $accountnav, $admin['template_htm']);
		}
	}


	$tmp = explode('%PAGECONTENT%', $admin['template_htm'], 2);

	$site['templates'] = array(
		'precontent'  => $tmp[0],
		'postcontent' => isset($tmp[1]) ? $tmp[1] : '',
	);
	$site['template_css'] = $admin['brand_' . $prfx . 'template_css'];

	return $admin;
}

?>
