<?php

$campaignid = intval(ac_http_param("id"));
$messageid = intval(ac_http_param("messageid"));
$period  = intval(ac_http_param("period"));
$from    = strval(ac_http_param("from"));
$to      = strval(ac_http_param("to"));

$series = array();
$graph  = array();

ac_graph_prepare_dateline($series, $graph, $period, $from, $to);

$cond = "";
if ($messageid > 0)
	$cond = "AND l.messageid = '$messageid'";
else
	$cond = "AND l.messageid = '0'";

$rs = ac_sql_query("
	SELECT
		DATE_FORMAT(ld.tstamp, '%m/%d') AS tstamp,
		DATEDIFF('$to', tstamp) AS diff,
		COUNT(*) AS count
	FROM
		#link_data ld
	WHERE
		ld.linkid IN
		(
			SELECT
				id
			FROM
				#link l
			WHERE
				l.link = 'open'
			AND l.campaignid = '$campaignid'
			$cond
		)
		AND DATE(ld.tstamp) > '$from'
		AND ld.tstamp < ('$to' + INTERVAL 1 DAY)
	GROUP BY
		DATE(ld.tstamp)
") or die(ac_sql_error());

while ($row = ac_sql_fetch_assoc($rs)) {
	$series[$row["diff"]] = $row["tstamp"];
	$graph[$row["diff"]] += $row["count"]; // "+" is here cuz we don't group by DATE(ld.tstamp)
}

$smarty->assign("series", $series);
$smarty->assign("graph", $graph);

?>
