<?php

$liststr   = implode("','", $admin["lists"]);
$period    = intval(ac_http_param("period"));
$from      = strval(ac_http_param("from"));
$to        = strval(ac_http_param("to"));


$listid    = (int)ac_http_param("id");
$mode      = (string)ac_http_param("mode");
$filterid  = (int)ac_http_param("filterid");

$range     = 'all';

$so = new AC_Select();
if ( $mode == 'report_list' ) {
	if ( $filterid ) {
		$so = select_filter_comment_parse($so, $filterid, $mode);
		if ( isset($so->graphfrom)     ) $from   = $so->graphfrom;
		if ( isset($so->graphto)       ) $to     = $so->graphto;
		if ( isset($so->graphperiod)   ) $period = $so->graphperiod;
		if ( isset($so->graphmode)     ) $range  = $so->graphmode;
	}
}

$series = array();
$graph  = array();

ac_graph_prepare_dateline($series, $graph, $period, $from, $to);

$cond = "";

if ( $mode == 'report_list' ) {
	if ( $listid > 0 ) {
		//$cond .= "AND sl.listid IN ( SELECT u.userid FROM #user_group u WHERE u.groupid = '$listid' ) ";
		$liststr = $listid;
	}
	if ( count($so->conds) > 1 ) {
		$f = $so->conds[1];
		// apply list filter
		$cond  = "AND sl.listid IN ( SELECT l.id FROM #list l WHERE 1 $f ) ";
	}
}


$rs   = ac_sql_query("
	SELECT
		DATE_FORMAT(sl.sdate, '%m/%d') AS cdate,
		DATEDIFF('$to', sl.sdate) AS diff,
		COUNT(*) AS count
	FROM
		#subscriber_list sl
	WHERE
		sl.listid IN ('$liststr')
	AND DATE(sl.sdate) > '$from'
	AND sl.sdate < ('$to' + INTERVAL 1 DAY)
	$cond
	GROUP BY
		DATE(sl.sdate)
");

$count = 0;
$total = intval(ac_http_param("total")) > 0;

while ($row = ac_sql_fetch_assoc($rs)) {
	if ($total)
		$count += $row["count"];
	else
		$count = $row["count"];

	$series[$row["diff"]] = $row["cdate"];
	$graph[$row["diff"]] += $count;
}

if ($total) {
	$xcount = 0;
	foreach ($graph as $key => $count) {
		if ($count > $xcount)
			$xcount = $count;
		$graph[$key] = $xcount;
	}
}

$smarty->assign("series", $series);
$smarty->assign("graph", $graph);

?>
