<?php

function list_field_getfielddata(&$subscriber, &$fields) {
	$fieldlist = ac_array_extract($fields, "id");
	$fieldstr  = implode("','", $fieldlist);
	$ary       = ac_sql_select_array("
		SELECT
			fieldid,
			val
		FROM
			#list_field_value
		WHERE
			fieldid IN ('$fieldstr')
		AND
			relid    = '$subscriber[id]'
		ORDER BY
			fieldid
	");

	return $ary;
}

function list_field_getfields($campaignid) {
	$campaignid = intval($campaignid);
	return ac_sql_select_array("
		SELECT DISTINCT
			f.id,
			f.title
		FROM
			#list_field f,
			#list_field_rel r
		WHERE
			f.id = r.fieldid
		AND
			( r.relid IN (
				SELECT
					cl.listid
				FROM
					#campaign_list cl
				WHERE
					cl.campaignid = '$campaignid'
			)
			OR r.relid='0' )
		ORDER BY
			f.id
	");
}

function list_field_getdefaults($listids) {
	# Return an array of the fields which have default values according to the given $listids
	# (and including any global fields).

	$ary     = array();
	$liststr = implode("','", $listids);
	$rs      = ac_sql_query("
		SELECT
			f.id,
			IF(f.`type` = 2, f.expl, f.onfocus) AS a_default
		FROM
			#list_field f
		WHERE
			IF(f.`type` = 2, f.expl, f.onfocus) != ''
		AND
			f.id IN (
				SELECT
					r.fieldid
				FROM
					#list_field_rel r
				WHERE
					r.relid IN ('0', '$liststr')
			)
	");

	while ($row = ac_sql_fetch_assoc($rs)) {
		$ary[$row["id"]] = $row["a_default"];
	}

	return $ary;
}

function list_field_insert_post() {
	$ary = array(
		'title' => ac_http_param('title'),
		'type' => ac_http_param('type'),
		'expl' => ac_http_param('expl'),
		'req' => ac_http_param('req'),
		'onfocus' => ac_http_param('onfocus'),
		'bubble_content' => ac_http_param('bubble_content'),
		'label' => ac_http_param('label'),
		'show_in_list' => ac_http_param('show_in_list'),
		'perstag' => ac_http_param('perstag'),
	);
	$fieldid = ac_custom_fields_insert('#list_field', $ary);
	if ( isset($_POST['p']) and is_array($_POST['p']) and count($_POST['p']) > 0 ) {
		$lists = array_map('intval', $_POST['p']);
	}
	else {
		$lists = array(0); // All lists
	}
	foreach ($lists as $list) {
		ac_sql_insert("#list_field_rel", array('id' => 0, 'relid' => $list, 'fieldid' => $fieldid));
	}
	$r = array();
	$r['fieldid'] = $fieldid;
	return ac_ajax_api_added(_a("Custom Field"), $r);
}

function list_field_update_post() {
	$fieldid = (int)ac_http_param('id');
	$ary = array(
		'title' => ac_http_param('title'),
		'type' => ac_http_param('type'),
		'expl' => ac_http_param('expl'),
		'req' => ac_http_param('req'),
		'onfocus' => ac_http_param('onfocus'),
		'bubble_content' => ac_http_param('bubble_content'),
		'label' => ac_http_param('label'),
		'show_in_list' => ac_http_param('show_in_list'),
		'perstag' => ac_http_param('perstag'),
	);
	$update = ac_custom_fields_update_field('#list_field', $ary, $fieldid);
	if ( isset($_POST['p']) and is_array($_POST['p']) and count($_POST['p']) > 0 ) {
		$lists = array_map('intval', $_POST['p']);
	}
	else {
		$lists = array(0); // All lists
	}
	ac_sql_delete("#list_field_rel", "`fieldid` = '$fieldid'");
	foreach ($lists as $list) {
		ac_sql_insert("#list_field_rel", array('id' => 0, 'relid' => $list, 'fieldid' => $fieldid));
	}
	$r = array();
	return ac_ajax_api_updated(_a("Custom Field"), $r);
}

function list_field_delete($fieldid) {
	ac_custom_fields_delete_field('#list_field', '#list_field_rel', 'fieldid', $fieldid);
	$r = array();
	$r['fieldid'] = $fieldid;
	return ac_ajax_api_deleted(_a("Custom Field"), $r);
}

function list_field_select_nodata_rel($fieldids, $filters = array()) {
	if ($fieldids && $fieldids != "all") {
		$fieldids = explode(",", $fieldids);
		$fieldids = implode("','", $fieldids);
	}
	$where = "f.id IN ('" . $fieldids . "')";
	$fields = ac_custom_fields_select_nodata_rel("#list_field", "#list_field_rel", $where);
	if ($fields) {

	}
	return $fields;
}

?>
