<?php

require_once ac_admin("functions/list.php");
require_once ac_global_functions("log.php");

// Email to subscriber or unsubscriber (optin or out)
function mail_opt_send($subscriber, $list, $listids, $subscription_form_id, $opt_info = null, $direction = 'in') {

	if ( isset($GLOBALS['demoMode']) ) return; // check if demo mode is on
	require_once(ac_admin('functions/optinoptout.php'));
	if ( $direction != 'out' ) $direction = 'in';
	if ( !$opt_info ) $opt_info = $list;
	if ( !$opt_info['opt' . $direction . '_confirm'] ) return;

	$admin = ac_admin_get();
	$site = ac_site_get();

	$options = array();

	$options['userid'] = $list['userid'];

	if ( !isset($opt_info['opt' . $direction . '_files']) ) {
		$opt_info = optinoptout_select_prepare($opt_info);
	}
	$options['attach'] = optinoptout_attachments($opt_info['opt' . $direction . '_files']);
	//$options['reply2'] = $list['reply2'];
	//$options['charset'] = $list['charset'];
	//$options['encoding'] = $list['encoding'];
	$options['charset'] = _i18n('utf-8');
	$options['encoding'] = _i18n('8bit');

	// Bounces
	$bso = new AC_Select();
	$sqlids = str_replace(",", "','", $listids);
	$bso->push("AND l.listid IN ('$sqlids')");
	require_once ac_admin("functions/campaign.select.php");
	$bounces = campaign_list_bounces($bso);
	$randombounce = array_rand($bounces);
	$options['bounce'] = $randombounce['email'];

	// Headers
	$hso = new AC_Select();
	$hso->push("AND l.listid IN (" . $list['id'] . ")");
	$options['headers'] = campaign_list_headers($hso);

	$header = $footer = $header_alt = $footer_alt = "";

	// Format
	if ($opt_info["opt" . $direction . "_format"] == "mime") {
		$header_alt = ($admin["brand_header_text"]) ? $admin["brand_header_text_value"] : "";
		$altBody = $header_alt . $opt_info["opt" . $direction . "_text"] . $footer_alt;
		$footer_alt = ($admin["brand_footer_text"]) ? $admin["brand_footer_text_value"] : "";
		if ( isset($GLOBALS['__hosted_footer_text']) ) {
			$tmpcontent = $header_alt . $altBody . $footer_alt;
			$abuseLink = ac_site_plink('box.php?nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid&funcml=unsub2');
			$unsubLink = ac_site_plink('index.php?action=abuse&nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid');
			$hasUnsub = ac_str_instr($unsubLink, $tmpcontent);
			$hasAbuse = ac_str_instr($abuseLink, $tmpcontent);
			if ( !$hasAbuse or !$hasUnsub ) {
				$footer_alt .= hosted_footer_personalize($GLOBALS['__hosted_footer_text']);
			}
		}
		$options['altBody'] = subscriber_personalize($subscriber, $listids, $subscription_form_id, $altBody, ( $direction == 'in' ? 'sub' : 'unsub' ));

		$header = ($admin["brand_header_html"]) ? $admin["brand_header_html_value"] : "";
		$body = $opt_info["opt" . $direction . "_html"];
		$footer = ($admin["brand_footer_html"]) ? $admin["brand_footer_html_value"] : "";
		if ( isset($GLOBALS['__hosted_footer_html']) ) {
			$tmpcontent = $header . $body . $footer;
			$abuseLink = ac_site_plink('box.php?nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid&funcml=unsub2');
			$unsubLink = ac_site_plink('index.php?action=abuse&nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid');
			$hasUnsub = ac_str_instr($unsubLink, $tmpcontent);
			$hasAbuse = ac_str_instr($abuseLink, $tmpcontent);
			if ( !$hasAbuse or !$hasUnsub ) {
				$footer .= hosted_footer_personalize($GLOBALS['__hosted_footer_html']);
			}
		}
	}
	elseif ($opt_info["opt" . $direction . "_format"] == "text") {
		$header = ($admin["brand_header_text"]) ? $admin["brand_header_text_value"] : "";
		$body = $opt_info["opt" . $direction . "_text"];
		$footer = ($admin["brand_footer_text"]) ? $admin["brand_footer_text_value"] : "";
		if ( isset($GLOBALS['__hosted_footer_text']) ) {
			$tmpcontent = $header . $body . $footer;
			$abuseLink = ac_site_plink('box.php?nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid&funcml=unsub2');
			$unsubLink = ac_site_plink('index.php?action=abuse&nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid');
			$hasUnsub = ac_str_instr($unsubLink, $tmpcontent);
			$hasAbuse = ac_str_instr($abuseLink, $tmpcontent);
			if ( !$hasAbuse or !$hasUnsub ) {
				$footer .= hosted_footer_personalize($GLOBALS['__hosted_footer_text']);
			}
		}
	}
	else {
		$header = ($admin["brand_header_html"]) ? $admin["brand_header_html_value"] : "";
		$body = $opt_info["opt" . $direction . "_html"];
		$footer = ($admin["brand_footer_html"]) ? $admin["brand_footer_html_value"] : "";
		if ( isset($GLOBALS['__hosted_footer_html']) ) {
			$tmpcontent = $header . $body . $footer;
			$abuseLink = ac_site_plink('box.php?nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid&funcml=unsub2');
			$unsubLink = ac_site_plink('index.php?action=abuse&nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid');
			$hasUnsub = ac_str_instr($unsubLink, $tmpcontent);
			$hasAbuse = ac_str_instr($abuseLink, $tmpcontent);
			if ( !$hasAbuse or !$hasUnsub ) {
				$footer .= hosted_footer_personalize($GLOBALS['__hosted_footer_html']);
			}
		}
	}

/*if your optin/optout messages are in MIME format, make sure $body is an array*/
	if($opt_info["opt" . $direction . "_format"] == "mime")
	{
		$body = array(
			'html' => $header . $body . $footer,
			'text' => $header_alt . $altBody . $footer_alt,
		);

		$body = mail_sender_info($list["id"], $body);

		// Personalization tags
		$body['html'] = subscriber_personalize($subscriber, $listids, $subscription_form_id, $body['html'], ( $direction == 'in' ? 'sub' : 'unsub' ));
		$body['text'] = subscriber_personalize($subscriber, $listids, $subscription_form_id, $body['text'], ( $direction == 'in' ? 'sub' : 'unsub' ));
	}
	else
	{
		$body = $header . $body . $footer;
		$body = mail_sender_info($list["id"], $body);

		// Personalization tags
		$body = subscriber_personalize($subscriber, $listids, $subscription_form_id, $body, ( $direction == 'in' ? 'sub' : 'unsub' ));
		$body = str_replace("<br />", "\n", $body);
	}


	$subject = subscriber_personalize($subscriber, $listids, $subscription_form_id, $opt_info["opt" . $direction . "_subject"], ( $direction == 'in' ? 'sub' : 'unsub' ));
	ac_mail_send($opt_info["opt" . $direction . "_format"], $opt_info["opt" . $direction . "_from_name"], $opt_info["opt" . $direction . "_from_email"], $body, $subject, $subscriber["email"], $subscriber["first_name"].' '.$subscriber["last_name"], $options);

}

function mail_responder_send($subscriber, $listids, $type = 'subscribe') {
	require_once ac_admin("functions/campaign.php");

	if ( $type != 'unsubscribe' ) $type = 'subscribe';

	if ( !is_array($listids) ) {
		$listids = array_diff(array_map('intval', explode(',', $listids)), array(0));
	}
	if ( count($listids) > 0 ) {
		$listslist = implode("','", $listids);

		$so = new AC_Select();
		$so->push("AND l.listid IN ('$listslist')");
		$so->push("AND c.type = 'responder'");
		$so->push("AND c.status IN (1, 5)"); // scheduled or completed (not draft, sending, stopped, paused, etc...)
		$so->push("AND c.responder_offset = 0");
		$so->push("AND c.responder_type = '$type'");
		$campaigns = campaign_select_array($so);

		foreach ( $campaigns as $k => $v ) {
			$campaign = campaign_select_prepare($v, true);
			campaign_send(null, $campaign, $subscriber, 'send');
		}
	}
}

function mail_campaign_send_last($subscriber, $listids) {
	require_once ac_admin("functions/campaign.php");

	if ( !is_array($listids) ) {
		$listids = array_diff(array_map('intval', explode(',', $listids)), array(0));
	}
	if ( count($listids) == 0 ) return 0;
	# If we just added this subscriber (which is likely), then their filter records won't
	# match anything.  We'll need to analyze them.
	filter_analyze_subscriber_inlist($subscriber["id"], $listids);

	$listslist = implode("','", $listids);
	$so = new AC_Select();
	$so->push("AND l.listid IN ('$listslist')"); // in subscriber's lists
	$so->push("AND c.type NOT IN ('responder', 'reminder', 'special', 'split')"); // real campaigns only
	$so->push("AND c.status = 5"); // completed only
	$so->orderby("c.sdate DESC");
	//dbg(campaign_select_query($so));
	$campaigns = campaign_select_array($so);

	$sent = 0;
	foreach ( $campaigns as $k => $v ) {
		if ($v["filterid"] > 0 && !filter_matches($subscriber["id"], $v["filterid"]))
			continue;
		$campaign = campaign_select_prepare($v, true);
		$sent += (int)campaign_send(null, $campaign, $subscriber, 'send');
		if ( $sent ) break;
	}
	return $sent;
}

// Email to list Admin
function mail_admin_send($subscriber, $lists, $type = 'subscribe') {
	if ( isset($GLOBALS['demoMode']) ) return; // check if demo mode is on
	global $site;
	if ( $type != 'unsubscribe' ) $type = 'subscribe';

	$listids = array();

	foreach ($lists as $list) {
		$listids[] = $list["id"];
	}

	$options = array();
	$options['userid'] = $lists[0]['userid'];

	$fields = subscriber_get_fields($subscriber["id"], $listids);

	// call smarty to make an e-mail body
	require_once(ac_global_functions('smarty.php'));
	$smarty = new AC_Smarty('public', true);

	// assign to template
	$smarty->assign('subscriber', $subscriber);
	$smarty->assign('fields', $fields);
	$smarty->assign('lists', $lists);
	$smarty->assign( 'udate_now', date('m/d/Y h:i', strtotime('now')) );
	$text = $smarty->fetch( $type == 'subscribe' ? 'new_subscriber_alert.txt' : 'new_unsubscriber_alert.txt' );

	$r = array();
	$listnames = array();

	foreach ($lists as $v) {
		// Comma-separated list of email addresses from DB table _list.(un)subscription_notify
		$f = $v[ $type == 'subscribe' ? 'subscription_notify' : 'unsubscription_notify' ];
		$arr = explode(",", $f);
		$emails = array_map('trim',$arr);

		$listnames[] = $v["name"];

		// Loop through email address values
		foreach ($emails as $e) {
			//if ( ac_str_is_email($e) ) $r[$e] = $v['name'] . _a(" Administrator");
			if ( ac_str_is_email($e) ) $r[] = $e;
		}
	}

	$subscribername = '';
	if ( isset($subscriber['lists']) and isset($subscriber['lists'][$listids[0]]) ) {
		$subscribername = $subscriber['lists'][$listids[0]]['first_name'] . " " . $subscriber['lists'][$listids[0]]['last_name'];
	}

	if ( count($r) > 0 ) {
		if ( $type == 'subscribe' ) {
			$subject = implode(", ", $listnames) . ": " . _p("You have a new subscriber to your list.");
		} else {
			$subject = implode(", ", $listnames) . ": " . _p("A subscriber has been removed from your list.");
		}
		//ac_mail_send("text", $site["site_name"], $site["emfrom"], $text, $subject, $r, "");
		$to_name = $v['name'] . _a(" Administrator");
		foreach($r as $email)
		{
			//ac_mail_send("text", $subscriber["first_name"].' '.$subscriber["last_name"], $subscriber["email"], $text, $subject, $email, $to_name, $options);
			ac_mail_send("text", $subscribername, $subscriber["email"], $text, $subject, $email, $to_name, $options);
		}
	}
}

// Forward to a Friend
function mail_forward_send($from_email, $from_name, $to_email, $to_name, $message) {
	require_once(ac_global_functions('ajax.php'));

	// check email validity
	if ( !ac_str_is_email($from_email) ) {
		return ac_ajax_api_result(false, _p("From email is not valid."), array('email' => $to_email));
	}

	// check email validity
	if ( !ac_str_is_email($to_email) ) {
		return ac_ajax_api_result(false, _p("To email is not valid."), array('email' => $to_email));
	}

	$admin = ac_admin_get();

	$header = $footer = "";

	$header = ($admin["brand_header_text"]) ? $admin["brand_header_text_value"] : "";
	$footer = ($admin["brand_footer_text"]) ? $admin["brand_footer_text_value"] : "";
	if ( isset($GLOBALS['__hosted_footer_text']) ) {
		$tmpcontent = $header . $header . $footer;
		$abuseLink = ac_site_plink('box.php?nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid&funcml=unsub2');
		$unsubLink = ac_site_plink('index.php?action=abuse&nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid');
		$hasUnsub = ac_str_instr($unsubLink, $tmpcontent);
		$hasAbuse = ac_str_instr($abuseLink, $tmpcontent);
		if ( !$hasAbuse or !$hasUnsub ) {
			$footer .= hosted_footer_personalize($GLOBALS['__hosted_footer_text']);
		}
	}

	$options = array();

	$listid = (ac_http_param('nl') ? (int)ac_http_param('nl') : null);

	if($listid) {
		$userid = ac_sql_select_one("userid", "#list", "id='$listid'");
		$options['userid'] = $userid;
	}
	elseif($admin['id'] && $admin['id'] != 0) {
		$options['userid'] = $admin['id'];
	}
	else {
		$options['userid'] = 1;
	}

	$subject = sprintf(_p("%s thought you may be interested in this mailing."), $from_name);

	$body = $header;
	$body .= _p("To: ") . $to_name . "\n";
	$body .= _p("From: ") . $from_name . "\n\n";
	$body .= $message . "\n\n";
	$body .= $footer;

	if ( !isset($GLOBALS['demoMode']) ) { // check if demo mode is on
		ac_mail_send("text", $from_name, $from_email, $body, $subject, $to_email, $to_name, $options);
	}

	return ac_ajax_api_result(true, _p("Email Sent."), array('email' => $to_email));
}

function mail_sender_info($listid, $body) {
	$list = list_select_row($listid);

	if (!$list || !$list["sender_name"]) {
		return $body;
	}

	if (is_string($body)) {
	   	if (ac_str_instr("%SENDER-INFO%", $body))
			return $body;
		else
			return $body . "\n\n%SENDER-INFO%";
	} elseif (is_array($body)) {
		if (!ac_str_instr("%SENDER-INFO%", $body["html"]))
			$body["html"] = str_replace("</body>", "<br>\n<br>\n%SENDER-INFO%</body>", $body["html"]);
		if (!ac_str_instr("%SENDER-INFO%", $body["text"]))
			$body["text"] .= "\n\n%SENDER-INFO%";

		return $body;
	} else {
		# Huh?
		return $body;
	}
}

?>
