<?php


//////////////////////////////////////////////////////////////////////////////////////////////////
// INSTANTIATE SWIFT MAILER

// define swift mailer's constants we want to change
if ( !defined('SWIFT_ABS_PATH') ) define('SWIFT_ABS_PATH', dirname(__FILE__));
if ( !defined('PRINT_SENDING_LOG') ) define('PRINT_SENDING_LOG', 0);
if ( !defined('SWIFT_LOG_NORMAL') ) define('SWIFT_LOG_NORMAL', '');

// include swift mailer core class
require_once(SWIFT_ABS_PATH . '/Swift.php');

// include our swift mailer plugin extensions
require_once(dirname(__FILE__) . '/logger.php');
require_once(dirname(__FILE__) . '/encoder.php');
require_once(dirname(__FILE__) . '/iterator.php');
require_once(dirname(__FILE__) . '/rotator.php');
require_once(dirname(__FILE__) . '/embedder.php');
require_once(dirname(__FILE__) . '/decorator.php');
require_once(dirname(__FILE__) . '/sendlistener.php');
require_once(dirname(__FILE__) . '/throttler.php');


/**
 * Handles batch mailing with Swift Mailer with fail-safe support.
 * Restarts the connection if it dies and then continues where it left off.
 * Please read the LICENSE file
 * @copyright Chris Corbyn <chris@w3style.co.uk>
 * @author Chris Corbyn <chris@w3style.co.uk>
 * @package Swift
 * @license GNU Lesser General Public License
 */

class CampaignMailer extends Swift_BatchMailer {

	// properties

	var $campaign = null; // prepared campaign array
	var $process = null; // if set, process to update after sending
	var $iterator = 'mysql'; // iterator to use

	var $action = 'test'; // what action is it performing (send, test, spamcheck (servers preview too), copy, etc)

	var $_campaignUpdater = array(); // what fields in #campaign to update in progress

	var $_orig_lang = null; // what was the original page language
	var $_orig_langtype = null; // what was the original page language type

	var $bounces = array(); // bounce(s)
	var $listheaders = array(); // list custom headers
	var $personalizations = array(); // sender personalizations
	var $mailers = array(); // mailers that will be used
	var $languages = array(); // used languages in lists

	var $messages = array(); // array of prepared message objects
	var $parts = array(); // array of prepared message part objects

	var $isSplit = false; // is split switch

	var $recipients = null; // recipients object
	var $it = null; // iterator object
	var $limiter = 0; // stop after this many

	// contructor
	function CampaignMailer($campaign = null, $process = null, $action = 'send') {
		// set action
		$this->action = $action;
		$this->_campaignUpdater = array(
			'=send_amt' => '`send_amt` + 1',
			'=ldate' => 'NOW()'
		);
		if ( $campaign ) $this->setCampaign($campaign);
		if ( $process ) $this->setProcess($process);
		$this->_orig_lang = ( isset($GLOBALS['__languageName']) ? $GLOBALS['__languageName'] : '' );
		$this->_orig_langtype = ( isset($GLOBALS['__languageType']) ? $GLOBALS['__languageType'] : '' );
		$this->setMaxTries(1);
		$this->recipients = new Swift_RecipientList();
	}

	function setCampaign($campaign) {
		$this->campaign = $campaign;
		$this->isSplit = ( $campaign['type'] == 'split' and count($campaign['messages']) > 1 );
		// fetch list based info:
		// bounce, header, languages(?), mailers, attachments, personalizations
		$this->fetchCampaignInfo();
		// prepare campaign
		$this->prepareCampaign();
		// prepare swift mailer
		$this->initMailer();
	}

	function fetchCampaignInfo() {
		// fetch list based info:
		require_once(ac_admin('functions/bounce_management.php'));
		require_once(ac_admin('functions/header.php'));
		require_once(ac_admin('functions/personalization.php'));
		// bounce, header, languages(?), mailers, personalizations
		$listslist = str_replace('-', ',', $this->campaign['listslist']);
		$listslist = str_replace(",", "', '", $listslist);
		$hso = new AC_Select();
		$bso = new AC_Select();
		$pso = new AC_Select();
		$hso->push("AND l.listid IN ('$listslist')");
		$bso->push("AND l.listid IN ('$listslist')");
		$pso->push("AND l.listid IN ('$listslist')");
		// bounces
		$this->bounces = campaign_list_bounces($bso);
		// list headers
		$this->listheaders = campaign_list_headers($hso);
		// sender personalization tags
		$this->personalizations = list_personalizations($pso);
		// languages
		$this->languages = array();
		/* don't have list languages anymore
		foreach ( $this->campaign['lists'] as $l ) {
			$this->languages[$l['lang']] = $l['lang'];
		}
		*/
		// campaign mailers to use
		$GLOBALS['_ac_mailer_connections'] = array();
		$query = "
			SELECT
				*,
				m.id AS id,
				c.id AS relid
			FROM
				#campaign_mailer c,
				#mailer m
			WHERE
				c.campaignid = '{$this->campaign['id']}'
			AND
				c.mailerid = m.id
			ORDER BY
				m.current DESC,
				m.corder ASC
		";
		$this->mailers =& ac_mail_connections($query);
		if ( count($this->mailers) == 0 ) {
			// group mailers to use
			if ( !isset($this->campaign['userid']) ) {
				$admin = ac_admin_get();
				$this->campaign['userid'] = $admin['id'];
			}
			$uid = (int)$this->campaign['userid'];
			$query = "
				SELECT
					m.*,
					0 AS campaignid,
					0 AS relid
				FROM
					#user_group u,
					#group_mailer g,
					#mailer m
				WHERE
					u.userid = '$uid'
				AND
					u.groupid = g.groupid
				AND
					g.mailerid = m.id
				ORDER BY
					m.current DESC,
					m.corder ASC
			";
			$this->mailers =& ac_mail_connections($query);
			if ( count($this->mailers) == 0 ) {
				// group mailers to use
				if ( !isset($this->campaign['userid']) || $this->campaign['userid']=='0' ) {
					$admin = ac_admin_get();
					$this->campaign['userid'] = $admin['id'];
				}
				$uid = (int)$this->campaign['userid'];
				$query = user_get_mail_conns_query($uid);
				$this->mailers =& ac_mail_connections($query);
				if ( count($this->mailers) == 0 ) {
					// default (system) mailers to use
					$this->mailers =& ac_mail_connections();
				}
			}
		}
		if ( !isset($this->campaign['fields']) ) {
			// fetch all custom fields that will be used
			$this->campaign['fields'] = list_get_fields(explode('-', $this->campaign['listslist']), true); // grab all custom fields
		}
		// prepare campaign?
		// MODIFY MESSAGE IF NEEDED (FETCH@SEND)
		// prepare swift mailer
		// prepare swift mailer message(s) (and attachments...)
	}

	function prepareCampaign() {
		// prepare campaign
	}

	function initMailer() {

		// disable backtracking in our trapperr
		if ( !defined('AC_TRAPPERR_NOBACKTRACE') ) define('AC_TRAPPERR_NOBACKTRACE', 1);
		if ( !defined('AC_TRAPPERR_NOVARS'     ) ) define('AC_TRAPPERR_NOVARS'     , 1);
		// set our trapperr to die on user errors (trigger_error() calls)
		$GLOBALS['_CONFIG']['trapperr']['user_error_is_deadly'] = 1;

		//////////////////////////////////////////////////////////////////////////////////////////////////
		// INSTANTIATE SWIFT MAILER

		// fetch all available connections
		//$connections =& ac_mail_connections();
		$connections =& $this->mailers;
		// extract the first connection that will be used
		$curr = key($connections);
		if ( is_null($curr) or !isset($connections[$curr]) ) $curr = 0;
		$connection =& $connections[$curr];
		$mailer =& $connection->_info;
		if ( count($connections) == 1 ) {
			// if only one connection is used, no need for rotator then
			$this->swift = new Swift($connection);
			if ( isset($mailer['dotfix']) ) {
				$encoder =& SendingEngineEncoder::instance();
				$encoder->setDotFix($mailer['dotfix']);
			}
		} else {
			// set connection rotator while loading Swift
			$rotator = new SendingEngineRotator($batch, $connections);
			$this->swift = new Swift($rotator);
			// set unique threshold value (minumum set)
			$rotatorPlugin =& $this->swift->getPlugin('_ROTATOR');
			//$rotatorPlugin->setThreshold($GLOBALS['_ac_mailer_rotator_threshold']);
			$rotatorPlugin->setThreshold($mailer['threshold']);
			if ( $mailer['threshold'] ) $rotatorPlugin->count = $mailer['sent'] % $mailer['threshold'];
		}

		// Set image embedder
		if ( $this->campaign['embed_images'] and $this->action != 'preview' ) {
			$extensions = array(
				0 => 'gif',
				1 => 'jpg',
				2 => 'jpeg',
				3 => 'pjpeg',
				4 => 'png'
			);
			$tags = array(
				'body' => 'background',
				'table' => 'background',
				'td' => 'background',
				'th' => 'background',
			);
			$embedder = new SendingEngineEmbedder($extensions, $tags);
			//$embedder->mimeTypes['php'] = 'image/gif';
			// attach plugin
			$this->swift->attachPlugin($embedder, 'embedder');
		}

		// Load 2 decorator plugins with the extended replacements class
		$personalizator = new Swift_Plugin_Decorator_Replacements();

		// predecorator will save the progress, since it is always the first plugin
		// it's sendPerformed() therefore runs the first after the real send
		$predecorator = new SendingEngineDecorator($this, $personalizator, true);
		$this->swift->attachPlugin($predecorator, 'predecorator');

		$decorator = new SendingEngineDecorator($this, $personalizator, false);
		$this->swift->attachPlugin($decorator, 'decorator');

		if ( $mailer['frequency'] and $mailer['pause'] ) $mailer['limit'] = 0;

		// Set the number of messages per minute limit
		$epm = (int)$mailer['limit'];
		// setting can be either per day or hour
		$throttler = new SendingEngineThrottler($this);
		if ( $epm ) {
			// conv days into hours
			if ( $mailer['limitspan'] == 'day' ) $epm /= 24;
			// conv hours into minutes
			$epm /= 60;
			// this many sent already (counted per second)
			//$throttler->setSent((int)( $mailer['sent'] % ( $epm / 60 ) ));
			$throttler->setSent(0);
		}
		$throttler->setTime();
		// if any limit is given
		$throttler->setEmailsPerMinute($epm); // max of X emails in a minute
		$this->swift->attachPlugin($throttler, 'throttler');

		// Load the plugin to deal with email checks and pausing (extends AntiFlood!!!)
		// this one should be loaded the last, as it performs all double-checks in beforeSendPerformed
		$sendHandler = new SendingEngineHandler($this, $mailer['frequency'], $mailer['pause']);
		if ( $mailer['frequency'] ) $sendHandler->count = $mailer['sent'] % $mailer['frequency'];
		$this->swift->attachPlugin($sendHandler, 'anti-flood');
	}

	function &getMessage($id) {
		// is there an already prepared message?
		if ( isset($this->messages[$id]) ) {
			// return it
			return $this->messages[$id];
		}
		// set this requested one
		$this->messages[$id] = $this->setMessage($id);
		// return it
		return $this->messages[$id];
	}

	function setMessage($id) {
		// get message data, prepare it, and return a swift message object
		return ( $messageData =& $this->getMessageData($id) ) ? $this->prepareMessage($messageData) : null;
	}

	function &getMessageData($id) {
		// find the message
		foreach ( $this->campaign['messages'] as $k => $v ) {
			// message found
			if ( $id == $v['id'] ) {
				return $v;
			}
		}
		$r = null;
		return $r;
	}

	function prepareMessage($row) {
		global $site;

		// try to fetch a message from archive (if exists)
		$cached = ac_sql_select_row("SELECT * FROM #message_archive WHERE `campaignid` = '{$this->campaign['id']}' AND `messageid` = '$row[id]'");
		if ( $cached ) {
			$row = array_merge($row, $cached);
			$GLOBALS['activerss_items_found'] = $row['rssitemshtml'] = $row['rssitemstext'] = 1;
		} else {
			// prepare swift mailer message(s) (and attachments...)
			// MODIFY MESSAGE IF NEEDED (FETCH@SEND)


			// figure out message settings
			if ( $row['format'] != 'text' and $row['format'] != 'html' ) $row['format'] = 'mime';
			if ( $row['encoding'] == '' ) $row['encoding'] = _i18n("8bit");
			if ( $row['charset'] == '' ) $row['charset'] = _i18n("utf-8");
			if ( !$row['priority'] ) $row['priority'] = 3; // default
			if ( $row['fromname'] == '' or $row['fromname'] == $row['fromemail'] ) $row['fromname'] = null; // default
			if ( $row['reply2'] == $row['fromemail'] ) $row['reply2'] = ''; // default

			// prepare and cleanup html version
			if ( $row['format'] != 'text' ) {
				$row = $this->prepareHTML($row);
			}
			$row['rssitemshtml'] = $GLOBALS['activerss_items_found'];
			// prepare and cleanup text version
			if ( $row['format'] != 'html' ) {
				$row = $this->prepareTEXT($row);
			}
			$row['rssitemstext'] = $GLOBALS['activerss_items_found'];
			$GLOBALS['activerss_items_found'] = $row['rssitemshtml'] + $row['rssitemstext'];

			// if real send, and found some rss items, store into archive
			if ( $this->campaign['id'] > 0 ) {
				if ( $this->action == 'send' ) {
					if ( $GLOBALS['activerss_items_found'] ) {
						$insert = array(
							'id' => 0,
							'campaignid' => $this->campaign['id'],
							'messageid' => $row['id'],
							'fromname' => $row['fromname'],
							'fromemail' => $row['fromemail'],
							'reply2' => $row['reply2'],
							'priority' => $row['priority'],
							'charset' => $row['charset'],
							'encoding' => $row['encoding'],
							'subject' => $row['subject'],
							'text' => $row['text'],
							'html' => $row['html'],
						);
						ac_sql_insert('#message_archive', $insert);
					}
				}
			}
		}

		if (strtoupper($row['charset']) != "UTF-8")
			$row = ac_utf_deepconv("UTF-8", $row['charset'], $row);

		// Create the message
		$message = new Swift_Message($row['subject'], null, "text/plain", $row['encoding'], $row['charset']);

		$txtPart = false;
		$htmPart = false;
		// if mime message
		if ( $row['format'] == 'mime' ) {
			// Add both parts
			$txtMsg = new Swift_Message_Part(message_wrap_text($row['text']), 'text/plain', $row['encoding'], $row['charset']);
			$txtMsg->setLineWrap(1000000000);
			$txtPart = $message->attach($txtMsg);
			$htmMsg = new Swift_Message_Part(message_wrap_html($row['html']), 'text/html', $row['encoding'], $row['charset']);
			$htmPart = $message->attach($htmMsg);
		} elseif ( $row['format'] == 'html' ) {
			$htmMsg = new Swift_Message_Part(message_wrap_html($row['html']), 'text/html', $row['encoding'], $row['charset']);
			$htmPart = $message->attach($htmMsg);
		} else/*if ( $row['format'] == 'text' )*/ {
			$type = 'text';
			$txtMsg = new Swift_Message_Part(message_wrap_text($row['text']), 'text/plain', $row['encoding'], $row['charset']);
			$txtMsg->setLineWrap(1000000000);
			$txtPart = $message->attach($txtMsg);
			//$message->setBody($row['text']);
		}
		$this->parts[$row['id']] = array('html' => $htmPart, 'text' => $txtPart);

		// set CHARSET/ENCODING
		$message->setEncoding($row['encoding']);
		$message->setCharset($row['charset']);
		$message->headers->setCharset($row['charset']);

		// set PRIORITY
		$message->setPriority((int)$row['priority']);

		// set BOUNCE SETTINGS (return-path)
		// assigned later in run()!

		// set FROM
		$message->_from = new Swift_Address($row['fromemail'], $row['fromname']);
		$message->setFrom($message->_from);

		// set REPLY-TO field
		if ( $row['reply2'] != '' ) $message->setReplyTo($row['reply2']);

		// add attachments
		$attachments = message_attachments($row['files']);
		foreach ( $attachments as $file ) {
			$message->attach(new Swift_Message_Attachment($file['data'], $file['name'], $file['mime_type']));
		}
		/*
		// add inline (image) attachments
		if ( isset($row['embed']) ) {
			foreach ( $row['embed'] as $file ) {
			    $att = new Swift_Message_EmbeddedFile($file['data'], $file['name'], $file['mime_type']);
			    $id = $message->attach($att);
			}
		}
		*/
		// set custom headers
		foreach ( $this->listheaders as $header ) {
			$message->headers->set($header['name'], personalization_basic($header['value'], ''));
		}

		$senderheader = false;
		if (isset($GLOBALS["_hosted_account"]))
			$senderheader = true;

		if ($senderheader && $site['onbehalfof'] && isset($GLOBALS["domain"])) {
			$info = $_SESSION[$GLOBALS["domain"]];
			$host = (string)ac_sql_select_one("SELECT host FROM #mailer WHERE id = '1'");

			if (preg_match('/(astirx.com|acemserv.com)$/', $host)) {
 				$message->headers->set("Sender", sprintf('%s@%s', $info["account"], $host));
 				$message->headers->set("X-Sender", sprintf('%s@%s', $info["account"], $host));
			}
		}

		// set internal custom headers
		$message->headers->set('X-mid', '%X-MID%');
		if ( trim(_i18n('ACEM')) != '' ) {
			$message->headers->set('X-Mailer', _i18n('ACEM'));
			$message->headers->set('User-Agent', _i18n('ACEM'));
			if (!$senderheader)
				$message->headers->set('X-Sender', '<' . $row['fromemail'] . '>');
		}

		$unsubactions = array();

		if ( isset($GLOBALS['_hosted_account']) ) {
			$hosted_domain = isset($_SESSION[$GLOBALS['domain']]['account']) ? $_SESSION[$GLOBALS['domain']]['account'] : $GLOBALS['domain'];
			$unsubactions[] = "mailto:unsubscribe@$hosted_domain";
		}

		$unsub = ac_site_plink('box.php?nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid&funcml=unsub2');
		if ( ac_str_instr($unsub, $row['html']) or ac_str_instr($unsub, $row['text']) ) {
			$unsubactions[] = $unsub;
		}
		if ( count($unsubactions) ) {
			$message->headers->set('List-Unsubscribe', "<" . implode(">, <", $unsubactions) . ">");
		}

		return $message;
	}

	function prepareHTML($row) {
		$origAdmin = ac_admin_get();
		$admin = ac_admin_get_totally_unsafe($this->campaign['userid']);
		$GLOBALS['admin'] = $origAdmin;
		$murl = ac_site_plink('lt.php?nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid&l=');
		$unsub = ac_site_plink('box.php?nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid&funcml=unsub2');
		// fetch content if needed (fetch@send scenario)
		if ( $row['htmlfetchurl'] and $row['htmlfetch'] == 'send' ) {
			// do_basic_personalization
			$row['htmlfetchurl'] = personalization_basic($row['htmlfetchurl'], $row['subject']);
			$row['html'] = ac_http_get($row['htmlfetchurl'], "UTF-8");
			$row['html'] = message_link_resolve($row['html'], $row['htmlfetchurl']);
			if ( $row['subject'] == '' ) {
				// try to find the title
				preg_match('/<title>(.*)<\/title>/i', $row['html'], $matches);
				if ( isset($matches[1]) ) $row['subject'] = $matches[1];
			}
		}
		// add header stuff
		$addOn = '';
		// branding header
		if ( $admin['brand_header_html'] ) {
			$addOn = $admin['brand_header_html_value'];
		}
		// whatever can be added, add it b4 closing BODY tag
		$row['html'] = ac_str_prepend_html($row['html'], $addOn);
		// add footer stuff
		$addOn = '';
		$addPre = '';
		// if unsub set to be added
		if ( $this->campaign['htmlunsub'] == 1 ) {
			// and not in message body
			if ( !ac_str_instr('%UNSUBSCRIBELINK%', $row['html']) and !ac_str_instr($unsub, $row['html']) ) {
				if ( ac_str_instr('%UNSUBSCRIBELINK%', $this->campaign['htmlunsubdata']) or ac_str_instr($unsub, $this->campaign['htmlunsubdata']) ) {
					$addOn .= $this->campaign['htmlunsubdata'];
				} else {
					$addOn .= _a('<div><a href="%UNSUBSCRIBELINK%">Click here</a> to unsubscribe from future mailings.</div>');
				}
			}
		}
		// add our image tracker
		if ( $this->campaign['trackreads'] == 1 ) {
			$imgtag = '<img src="' . $murl . 'open" border="0" />';
			if ( strlen($row['html']) > 100 * 1024 ) {
				$addPre .= $imgtag;
			} else {
				$addOn  .= $imgtag;
			}
		}
		// add analytics image tracker
		if ( $this->campaign['trackreadsanalytics'] == 1 ) {
			$url = message_read_analytics($this->campaign, $row);
			if ( $url ) {
				$imgtag = '<img src="' . $url . 'open" width="1" height="1" border="0" />';
				if ( strlen($row['html']) > 100 * 1024 ) {
					$addPre .= $imgtag;
				} else {
					$addOn  .= $imgtag;
				}
			}
		}
		// branding footer
		if ( $admin['brand_footer_html'] ) {
			$addOn .= '<br />' . $admin['brand_footer_html_value'];
		}

		$tmpcontent = $addPre . $row['html'] . $addOn;

		if ( isset($GLOBALS['__hosted_footer_html']) ) {
			$abuseLink = ac_site_plink('box.php?nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid&funcml=unsub2');
			$unsubLink = ac_site_plink('index.php?action=abuse&nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid');
			$hasUnsub = ac_str_instr($unsubLink, $tmpcontent);
			$hasAbuse = ac_str_instr($abuseLink, $tmpcontent);
			if ( !$hasAbuse or !$hasUnsub ) {
				$addOn .= hosted_footer_personalize($GLOBALS['__hosted_footer_html']);
				$tmpcontent = $addPre . $row['html'] . $addOn;
			}
		}
		if ( user_requires_senderinfo($admin["id"]) ) {
			if ( !ac_str_instr('%SENDER-INFO%', $tmpcontent) ) {
				$addOn .= '<br /><br />%SENDER-INFO%';
			}
		}
		//$addOn .= free_license_msg(true);
		// whatever can be added, add it b4 closing BODY tag
		$row['html'] = ac_str_append_html($row['html'], $addOn);
		// if message is over 5MB, image tracker will be at the top
		$row['html'] = ac_str_prepend_html($row['html'], $addPre, 0);
		// apply ActiveRSS
		$html = activerss_parse($this->campaign, $row, true, true);
		if ( $row['html'] != $html ) {
			$row['html'] = $html;
			// save them into campaign info
			$this->campaign['tlinks'] = campaign_links_get($this->campaign);
		}
		// apply sender personalization
		$row['html'] = personalization_apply($row['html'], $this->personalizations['html']);
		// do_basic_personalization
		$row['html'] = personalization_basic($row['html'], $row['subject']);
		// EMBED IMAGES
		//if ( $this->campaign['embed_images'] ) {
			// swiftmailer now does this (embedder plugin)
			//$row['embed'] = message_parse_images($row['html'], true);
		//}
		// PARSE LINKS
		if ( $this->campaign['tracklinks'] == 'mime' or $this->campaign['tracklinks'] == 'html' ) {
			$links = ac_array_groupby($this->campaign['tlinks'], 'messageid');
			if ( isset($links[$row['id']]) ) {
				message_parse_links($row['html'], $links[$row['id']], 'html');
			}
		}
		// preliminary message cleanup
		if ( !isset($GLOBALS['disableStripHTMLtag']) ) {
			/*
			// remove opening HTML tags (upper/lower cased)
			$row['html'] = preg_replace('/<html.*?>/i', '', $row['html']);
			// remove closing HTML tags (upper/lower cased)
			$row['html'] = preg_replace('/<\/html>/i', '', $row['html']);
			*/
			// remove opening TBODY tags (upper/lower cased)
			$row['html'] = preg_replace('/<tbody.*?>/i', '', $row['html']);
			// remove closing TBODY tags (upper/lower cased)
			$row['html'] = preg_replace('/<\/tbody>/i', '', $row['html']);
		}
		// postliminary message cleanup :)
		$row['html'] = str_replace('<title></title>', '', $row['html']);
		$row['html'] = str_replace('&amp;', '&', $row['html']);
		$row['html'] = trim($row['html']);
		return $row;
	}

	function prepareTEXT($row) {
		$origAdmin = ac_admin_get();
		$admin = ac_admin_get_totally_unsafe($this->campaign['userid']);
		$GLOBALS['admin'] = $origAdmin;
		//$murl = ac_site_plink();
		$unsub = ac_site_plink('box.php?nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid&funcml=unsub2');
		// fetch content if needed (fetch@send scenario)
		if ( $row['textfetchurl'] and $row['textfetch'] == 'send' ) {
			// do_basic_personalization
			$row['textfetchurl'] = personalization_basic($row['textfetchurl'], $row['subject']);
			$row['text'] = ac_http_get($row['textfetchurl'], "UTF-8");
		}
		// add header stuff
		$addOn = '';
		// branding header
		if ( $admin['brand_header_text'] ) {
			$addOn .= $admin['brand_header_text_value'] . "\n";
		}
		// whatever can be added, add it b4 closing BODY tag
		$row['text'] = ac_str_prepend_text($row['text'], $addOn);
		// add footer stuff
		$addOn = '';
		// if unsub set to be added
		if ( $this->campaign['textunsub'] == 1 ) {
			// and not in message body
			if ( !ac_str_instr('%UNSUBSCRIBELINK%', $row['text']) and !ac_str_instr($unsub, $row['text']) ) {
				if ( ac_str_instr('%UNSUBSCRIBELINK%', $this->campaign['textunsubdata']) or ac_str_instr($unsub, $this->campaign['textunsubdata']) ) {
					$addOn .= $this->campaign['textunsubdata'];
				} else {
					$addOn .= _a('Click here to unsubscribe from future mailings: %UNSUBSCRIBELINK%');
				}
			}
		}
		// branding footer
		if ( $admin['brand_footer_text'] ) {
			$addOn .= "\n" . $admin['brand_footer_text_value'];
		}

		$tmpcontent = $row['text'] . $addOn;

		if ( isset($GLOBALS['__hosted_footer_text']) ) {
			$abuseLink = ac_site_plink('box.php?nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid&funcml=unsub2');
			$unsubLink = ac_site_plink('index.php?action=abuse&nl=currentnl&c=cmpgnid&m=currentmesg&s=subscriberid');
			$hasUnsub = ac_str_instr($unsubLink, $tmpcontent);
			$hasAbuse = ac_str_instr($abuseLink, $tmpcontent);
			if ( !$hasAbuse or !$hasUnsub ) {
				$addOn .= hosted_footer_personalize($GLOBALS['__hosted_footer_text']);
				$tmpcontent = $row['text'] . $addOn;
			}
		}
		if ( user_requires_senderinfo($admin["id"]) ) {
			if ( !ac_str_instr('%SENDER-INFO%', $tmpcontent) ) {
				$addOn .= "\n\n%SENDER-INFO%";
			}
		}
		//$addOn .= free_license_msg(false);
		// append additional content
		$row['text'] = ac_str_append_text($row['text'], $addOn);
		// apply ActiveRSS
		$text = activerss_parse($this->campaign, $row, false, true);
		if ( $row['text'] != $text ) {
			$row['text'] = $text;
			// save them into campaign info
			$this->campaign['tlinks'] = campaign_links_get($this->campaign);
		}
		$row['text'] = ac_str_clean_word($row['text'], false);
		// apply sender personalization
		$row['text'] = personalization_apply($row['text'], $this->personalizations['text']);
		// do_basic_personalization
		$row['text'] = personalization_basic($row['text'], $row['subject']);
		// PARSE LINKS
		if ( $this->campaign['tracklinks'] == 'mime' or $this->campaign['tracklinks'] == 'text' ) {
			$links = ac_array_groupby($this->campaign['tlinks'], 'messageid');
			if ( isset($links[$row['id']]) ) {
				message_parse_links($row['text'], $links[$row['id']], 'text');
			}
		}
		$row['text'] = str_replace("\r", '', $row['text']);
		return $row;
	}

	function setProcess($process) {
		require_once(ac_global_functions('process.php'));
		if ( isset($process['id']) ) $this->process = $process;
	}

	function update() {
		if ( $this->process and $this->action == 'send' ) {
			campaign_sender_log("Updating the process...");
			ac_process_update($this->process['id']);
			$this->process['completed']++;
			campaign_sender_log("Process updated.");
		}
		if ( $this->campaign['id'] > 0 and count($this->_campaignUpdater) > 0 ) {
			// print out debugging: completed the subscriber update
			campaign_sender_log("Updating the campaign...");
			if ( !ac_sql_update('#campaign', $this->_campaignUpdater, "`id` = '{$this->campaign['id']}'") ) {
				$err = '#' . ac_sql_error_number() . ' - ' . ac_sql_error();
				campaign_sender_log("\n\n[+] COULD NOT UPDATE CAMPAIGN!!!\n\nError $err\n\n\n\n");
				campaign_log_save($this->campaign['id'], $this->action);
				die('could not update campaign.');
			}
			if ( @ac_sql_affected_rows($GLOBALS["db_link"]) == 0 ) {
				campaign_sender_log("\n\n[+] CAMPAIGN NOT UPDATED!!!\n\n\n\n");
				campaign_log_save($this->campaign['id'], $this->action);
				die('campaign not updated.');
			}
			if ( isset($this->_campaignUpdater['send_amt']) or isset($this->_campaignUpdater['=send_amt']) ) {
				$this->campaign['send_amt']++;
			}
			if ( isset($this->_campaignUpdater['total_amt']) or isset($this->_campaignUpdater['=total_amt']) ) {
				$this->campaign['total_amt']++;
			}
			campaign_update_splittotal($this->campaign["id"], 0);
			campaign_update_splitsend($this->campaign["id"], 0);
			campaign_sender_log("Campaign updated.");
		}
	}

	function setIterator($iterator) {
		// check if valid
		if ( !in_array($iterator, array('array', 'mysql')) ) return false;
		// set the iterator switch
		$this->iterator = $iterator;
		// initialize the object
		$this->it = new SendingEngineIterator(null, $iterator, true, 'email', 'name');
		// assign it to recipients object
		$this->recipients->setIterator($this->it, 'to'); //or cc, bcc
	}



	function setPersonalizations($subscriber) {
		// get the personalization array (pers tag => value)
		$personalizations = subscriber_personalize_get($subscriber, $this->campaign);
		// assign it to both predecorator and (post)decorator
		$predecorator =& $this->swift->getPlugin('predecorator');
		if ( $predecorator ) {
			$predecorator->replacements->setReplacements(array(trim($subscriber['email']) => $personalizations));
		}
		$decorator =& $this->swift->getPlugin('decorator');
		if ( $decorator ) {
			$decorator->replacements->setReplacements(array(trim($subscriber['email']) => $personalizations));
		}
	}



	/*
		SWITCH LANGUAGES IF NEEDED
	*/
	function switchLanguage($nl) {
		$langs = ac_lang_choices();
		// if list language exists in app
		if ( !isset($this->languages[$nl]) or !isset($langs[$this->languages[$nl]]) ) return;
		// if current language different than main language (or language not set yet)
		if ( !isset($GLOBALS['__languageName']) or $GLOBALS['__languageName'] != $this->languages[$nl] or $GLOBALS['__languageType'] != 'public' ) {
			// load the language strings
			ac_lang_load(ac_lang_file($this->languages[$nl], 'public'), true);
		}
	}

	function restoreErrorHandler() {
		restore_error_handler();
		//if ( in_array($this->action, array('send', 'test', 'copy')) ) {
			$GLOBALS['_CONFIG']['trapperr']['user_error_is_deadly'] = 0;
		//}
	}




	// original Swift_BatchMailer copy, modified "wrapper"
	/**
	 * Run a batch send in a fail-safe manner.
	 * This operates as Swift::batchSend() except it deals with errors itself.
	 * @param Swift_Message To send
	 * @param Swift_RecipientList Recipients (To: only)
	 * @param Swift_Address The sender's address
	 * @return int The number sent to
	 */
	function run($recipients, $action = 'send') {
		// set action
		$this->action = $action;
		// push recipients to iterator
		$this->it->set($recipients);
		$i = 0;
		$sent = 0;
		$str = '';
		$successive_fails = 0;
		$breakedOut = false;
		$log =& Swift_LogContainer::getLog();


		// set batch's error handler that can set it to restart the connection
		set_error_handler(array(&$this, "handleError"));

		$it = $this->recipients->getIterator("to");
		while ($it->hasNext())
		{
			//if($this->process){if(isset($GLOBALS['asdf1234']))dbg('stop');else $GLOBALS['asdf1234']=1;}// stop on second (every time script runs, increment a counter)
			//if($this->process)dbg('stop');// stop on first
			$it->next();
			$recipient = $it->getValue();
			/* 1-2-All */
			$i++;
			// clear out log
			campaign_log_save($this->campaign, $this->action);
			// figure out subscriber
			$subscriber = $it->currentRow;
			$tbl_id = $subscriber['id'];
			$eid = $subscriber['subscriberid'];
			$nl = $subscriber['listid'];
			campaign_sender_log("\n\nPREPARING AN EMAIL FOR SUBSCRIBER $subscriber[email] ($tbl_id=$eid@$nl):");
			// figure out list (languages, personalizations)
			$this->switchLanguage($nl);
			$message =& $this->getMessage($subscriber['messageid']);
			// activerss check
			if ( $this->campaign['type'] == 'activerss' ) {
				if ( !plugin_activerss() ) {
					// stop this mailing
					$GLOBALS['stopTHISmailing'] = 1;
					campaign_sender_log("\n\n[+] ACTIVERSS CAMPAIGNS NOT ALLOWED!!!\n\n\n\n");
				}
				// if we found 0 items (total! in both html and text, that is)
				if ( $GLOBALS['activerss_items_found'] == 0 ) {
					// stop this mailing
					$GLOBALS['stopTHISmailing'] = 1;
					campaign_sender_log("\n\n[+] THERE ARE NO NEW RSS FEEDS !!!\n\n\n\n");
				}
				$found = $GLOBALS['activerss_items_found'] / 2;
				campaign_sender_log("An RSS Triggered Campaign will be sent with $found RSS item(s).");
			}
			$from = $message->_from;
			// set BOUNCE SETTINGS (return-path)
			if ( $this->campaign['bounceid'] != 0 and count($this->bounces) > 0 ) {
				if ( $this->campaign['bounceid'] == -1 ) {
					// assign random one
					$rand = array_rand($this->bounces);
					$return_path = $this->bounces[$rand]['email'];
				} else {
					// find the specific one
					$return_path = '';
					foreach ( $this->bounces as $k => $v ) {
						if ( $v['id'] == $this->campaign['bounceid'] ) {
							$return_path = $v['email'];
							break;
						}
					}
				}
				if ( $return_path != '' and $return_path != $from->getAddress() ) {
					$message->setReturnPath($return_path);
				}
			}
			// fetch all personalization tags for this subscriber
			$this->setPersonalizations($subscriber);

			/* 1-2-All */
			$loop = true;
			$tries = 0;
			while ($loop && $tries < $this->getMaxTries())
			{
				$tries++;
				$loop = false;
				$this->copyMessageHeaders($message);
				/* 1-2-All */
				// our "get message source" switch
				//$this->swift->getsource = ( $this->action == 'spamcheck' );
				$this->swift->getsource = ( in_array($this->action, array('spamcheck', 'preview', 'messagesize', 'source')) );
				// before it calls the send method, we should check if mailing has stopped
				if ( !isset($GLOBALS['stopTHISmailing']) ) $GLOBALS['stopTHISmailing'] = 0;
				if ( $GLOBALS['stopTHISmailing'] ) {
					$GLOBALS['stopTHISmailing'] = 0;
					campaign_log_save($this->campaign, $this->action);
					$this->restoreErrorHandler();
					return ( $this->swift->getsource ? $str : $sent );
				}
				if ( $this->swift->getsource ) {
					$str .= ($n = $this->swift->send($message, $recipient, $from));
					$sent++;
				} else {
					// original "send!" function
					$sent += ($n = $this->swift->send($message, $recipient, $from));
				}
				/* 1-2-All */
				if (!$n) $this->addFailedRecipient($recipient->getAddress());
				if ($this->doRestart)
				{
					$successive_fails++;
					$this->restoreMessageHeaders($message);
					if (($max = $this->getMaxSuccessiveFailures()) && $successive_fails > $max)
					{
						campaign_log_save($this->campaign, $this->action);
						$this->restoreErrorHandler();
						Swift_Errors::trigger(
							new Swift_Exception(
								"Too many successive failures. BatchMailer is configured to allow no more than " . $max .
								" successive failures."
							)
						);
						return 0;
					}
					$loop = true;
					//Give it one more shot
					if ($t = $this->getSleepTime()) sleep($t);
					$this->forceRestartSwift();
				}
				else
				{
					$successive_fails = 0;
				}
			}
			if ( $this->limiter != 0 and $this->limiter <= $i ) {
				$breakedOut = true;
				break(1);
			}
			//if($this->process)dbg('stop'); // stop after first
		}
		$this->restoreErrorHandler();

		// old "if completed" switch
		if ( (!$breakedOut or $it->numRows == $i) and !( isset($GLOBALS['stopTHISmailing']) and $GLOBALS['stopTHISmailing'] ) ) {
			$GLOBALS['completed'] = 1;
		}

		// if current language different than main language
		if ( !isset($GLOBALS['__languageName']) or $GLOBALS['__languageName'] != $this->_orig_lang or $GLOBALS['__languageType'] != $this->_orig_langtype ) {
			// load the language strings
			ac_lang_load(ac_lang_file($this->_orig_lang, $this->_orig_langtype), true);
		}
		campaign_log_save($this->campaign, $this->action);
		return ( $this->swift->getsource ? $str : $sent );
	}
}


?>
